/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.drawable;

import com.cleanroommc.modularui.api.IJsonSerializable;
import com.cleanroommc.modularui.api.drawable.IDrawable;
import com.cleanroommc.modularui.screen.viewport.GuiContext;
import com.cleanroommc.modularui.theme.WidgetTheme;
import com.google.gson.JsonObject;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class DrawableStack
implements IDrawable,
IJsonSerializable {
    public static final IDrawable[] EMPTY_BACKGROUND = new IDrawable[0];
    private final IDrawable[] drawables;

    public DrawableStack(IDrawable ... drawables) {
        this.drawables = drawables == null || drawables.length == 0 ? EMPTY_BACKGROUND : drawables;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void draw(GuiContext context, int x, int y, int width, int height, WidgetTheme widgetTheme) {
        for (IDrawable drawable : this.drawables) {
            drawable.draw(context, x, y, width, height, widgetTheme);
        }
    }

    @Override
    public boolean canApplyTheme() {
        for (IDrawable drawable : this.drawables) {
            if (!drawable.canApplyTheme()) continue;
            return true;
        }
        return false;
    }

    public IDrawable[] getDrawables() {
        return this.drawables;
    }

    @Override
    public boolean saveToJson(JsonObject json) {
        throw new IllegalStateException();
    }
}

