/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.factory;

import com.cleanroommc.modularui.api.IMuiScreen;
import com.cleanroommc.modularui.api.MCHelper;
import com.cleanroommc.modularui.api.RecipeViewerSettings;
import com.cleanroommc.modularui.api.UIFactory;
import com.cleanroommc.modularui.factory.GuiData;
import com.cleanroommc.modularui.network.NetworkHandler;
import com.cleanroommc.modularui.network.packets.OpenGuiPacket;
import com.cleanroommc.modularui.screen.GuiContainerWrapper;
import com.cleanroommc.modularui.screen.GuiScreenWrapper;
import com.cleanroommc.modularui.screen.ModularContainer;
import com.cleanroommc.modularui.screen.ModularPanel;
import com.cleanroommc.modularui.screen.ModularScreen;
import com.cleanroommc.modularui.screen.UISettings;
import com.cleanroommc.modularui.value.sync.PanelSyncManager;
import com.cleanroommc.modularui.widget.WidgetTree;
import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.player.PlayerContainerEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public class GuiManager {
    private static final Object2ObjectMap<String, UIFactory<?>> FACTORIES = new Object2ObjectOpenHashMap(16);
    private static final List<EntityPlayer> openedContainers = new ArrayList<EntityPlayer>(4);

    public static void registerFactory(UIFactory<?> factory) {
        Objects.requireNonNull(factory);
        String name = Objects.requireNonNull(factory.getFactoryName());
        if (name.length() > 32) {
            throw new IllegalArgumentException("The factory name length must not exceed 32!");
        }
        if (FACTORIES.containsKey((Object)name)) {
            throw new IllegalArgumentException("Factory with name '" + name + "' is already registered!");
        }
        FACTORIES.put((Object)name, factory);
    }

    @NotNull
    public static UIFactory<?> getFactory(String name) {
        UIFactory factory = (UIFactory)FACTORIES.get((Object)name);
        if (factory == null) {
            throw new NoSuchElementException();
        }
        return factory;
    }

    public static boolean hasFactory(String name) {
        return FACTORIES.containsKey((Object)name);
    }

    public static <T extends GuiData> void open(@NotNull UIFactory<T> factory, @NotNull T guiData, EntityPlayerMP player) {
        if (player instanceof FakePlayer || openedContainers.contains(player)) {
            return;
        }
        openedContainers.add((EntityPlayer)player);
        UISettings settings = new UISettings(RecipeViewerSettings.DUMMY);
        settings.defaultCanInteractWith(factory, guiData);
        PanelSyncManager syncManager = new PanelSyncManager(false);
        ModularPanel panel = factory.createPanel(guiData, syncManager, settings);
        WidgetTree.collectSyncValues(syncManager, panel);
        ModularContainer container = settings.hasContainer() ? settings.createContainer() : factory.createContainer();
        container.construct((EntityPlayer)player, syncManager, settings, panel.getName(), guiData);
        player.func_71117_bO();
        player.func_71128_l();
        int windowId = player.field_71139_cq;
        PacketBuffer buffer = new PacketBuffer(Unpooled.buffer());
        factory.writeGuiData(guiData, buffer);
        NetworkHandler.sendToPlayer(new OpenGuiPacket<T>(windowId, factory, buffer), player);
        player.field_71070_bA = container;
        player.field_71070_bA.field_75152_c = windowId;
        player.field_71070_bA.func_75132_a((IContainerListener)player);
        MinecraftForge.EVENT_BUS.post((Event)new PlayerContainerEvent.Open((EntityPlayer)player, (Container)container));
    }

    @SideOnly(value=Side.CLIENT)
    @ApiStatus.Internal
    public static <T extends GuiData> void openFromClient(int windowId, @NotNull UIFactory<T> factory, @NotNull PacketBuffer data, @NotNull EntityPlayerSP player) {
        T guiData = factory.readGuiData((EntityPlayer)player, data);
        UISettings settings = new UISettings();
        settings.defaultCanInteractWith(factory, guiData);
        PanelSyncManager syncManager = new PanelSyncManager(true);
        ModularPanel panel = factory.createPanel(guiData, syncManager, settings);
        WidgetTree.collectSyncValues(syncManager, panel);
        ModularScreen screen = factory.createScreen(guiData, panel);
        screen.getContext().setSettings(settings);
        ModularContainer container = settings.hasContainer() ? settings.createContainer() : factory.createContainer();
        container.construct((EntityPlayer)player, syncManager, settings, panel.getName(), (GuiData)guiData);
        IMuiScreen wrapper = factory.createScreenWrapper(container, screen);
        GuiScreen guiScreen = wrapper.getGuiScreen();
        if (!(guiScreen instanceof GuiContainer)) {
            throw new IllegalStateException("The wrapping screen must be a GuiContainer for synced GUIs!");
        }
        GuiContainer guiContainer = (GuiContainer)guiScreen;
        if (guiContainer.field_147002_h != container) {
            throw new IllegalStateException("Custom Containers are not yet allowed!");
        }
        guiContainer.field_147002_h.field_75152_c = windowId;
        MCHelper.displayScreen(wrapper.getGuiScreen());
        player.field_71070_bA = guiContainer.field_147002_h;
    }

    @SideOnly(value=Side.CLIENT)
    public static <T extends GuiData> void openFromClient(@NotNull UIFactory<T> factory, @NotNull T guiData) {
        PacketBuffer buffer = new PacketBuffer(Unpooled.buffer());
        factory.writeGuiData(guiData, buffer);
        NetworkHandler.sendToServer(new OpenGuiPacket<T>(0, factory, buffer));
    }

    @SideOnly(value=Side.CLIENT)
    static void openScreen(ModularScreen screen, UISettings settings) {
        IMuiScreen guiScreen;
        screen.getContext().setSettings(settings);
        if (settings.hasContainer()) {
            ModularContainer container = settings.createContainer();
            container.constructClientOnly();
            guiScreen = new GuiContainerWrapper(container, screen);
        } else {
            guiScreen = new GuiScreenWrapper(screen);
        }
        MCHelper.displayScreen(guiScreen);
    }

    @SubscribeEvent
    public void onTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            openedContainers.clear();
        }
    }
}

