/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.theme;

import com.cleanroommc.modularui.api.ITheme;
import com.cleanroommc.modularui.api.IThemeApi;
import com.cleanroommc.modularui.theme.AbstractTheme;
import com.cleanroommc.modularui.theme.DefaultTheme;
import com.cleanroommc.modularui.theme.ThemeManager;
import com.cleanroommc.modularui.theme.WidgetTheme;
import com.cleanroommc.modularui.theme.WidgetThemeEntry;
import com.cleanroommc.modularui.theme.WidgetThemeKey;
import com.cleanroommc.modularui.theme.WidgetThemeMap;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.jetbrains.annotations.UnmodifiableView;

public class Theme
extends AbstractTheme {
    private final WidgetThemeMap widgetThemes;

    Theme(String id, ITheme parent, WidgetThemeMap widgetThemes) {
        block4: {
            block3: {
                super(id, parent);
                this.widgetThemes = new WidgetThemeMap();
                this.widgetThemes.putAll((Map)((Object)widgetThemes));
                if (!(parent instanceof Theme)) break block3;
                Theme theme = (Theme)parent;
                for (WidgetThemeEntry entry : theme.widgetThemes.values()) {
                    if (this.widgetThemes.containsKey(entry.getKey())) continue;
                    this.widgetThemes.put(entry.getKey(), entry);
                }
                break block4;
            }
            if (parent != DefaultTheme.INSTANCE) break block4;
            if (!this.widgetThemes.containsKey(IThemeApi.FALLBACK)) {
                this.widgetThemes.putTheme(IThemeApi.FALLBACK, ThemeManager.defaultFallbackWidgetTheme);
            }
            for (WidgetThemeEntry<?> entry : DefaultTheme.INSTANCE.getWidgetThemes()) {
                if (this.widgetThemes.containsKey(entry.getKey())) continue;
                this.widgetThemes.put(entry.getKey(), entry);
            }
        }
    }

    @Override
    public @UnmodifiableView Collection<WidgetThemeEntry<?>> getWidgetThemes() {
        return Collections.unmodifiableCollection(this.widgetThemes.values());
    }

    @Override
    public <T extends WidgetTheme> WidgetThemeEntry<T> getWidgetTheme(WidgetThemeKey<T> key) {
        WidgetThemeEntry<T> widgetTheme = this.widgetThemes.getTheme(key);
        while (widgetTheme == null && key.isSubWidgetTheme()) {
            widgetTheme = this.widgetThemes.getTheme(key.getParent());
        }
        return widgetTheme;
    }
}

