/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.utils.fakeworld;

import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;

public class BlockPosUtil {
    public static final BlockPos MAX = new BlockPos(Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE);
    public static final BlockPos MIN = new BlockPos(Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE);

    public static int getManhattanDistance(BlockPos p1, BlockPos p2) {
        return BlockPosUtil.getXDist(p1, p2) + BlockPosUtil.getYDist(p1, p2) + BlockPosUtil.getZDist(p1, p2);
    }

    public static int getBlockCountInside(BlockPos p1, BlockPos p2) {
        return BlockPosUtil.getXDist(p1, p2) * BlockPosUtil.getYDist(p1, p2) * BlockPosUtil.getZDist(p1, p2);
    }

    public static int getXDist(BlockPos p1, BlockPos p2) {
        return Math.abs(p1.func_177958_n() - p2.func_177958_n());
    }

    public static int getYDist(BlockPos p1, BlockPos p2) {
        return Math.abs(p1.func_177956_o() - p2.func_177956_o());
    }

    public static int getZDist(BlockPos p1, BlockPos p2) {
        return Math.abs(p1.func_177952_p() - p2.func_177952_p());
    }

    public static BlockPos getMin(BlockPos p1, BlockPos p2) {
        return new BlockPos(Math.min(p1.func_177958_n(), p2.func_177958_n()), Math.min(p1.func_177956_o(), p2.func_177956_o()), Math.min(p1.func_177952_p(), p2.func_177952_p()));
    }

    public static BlockPos getMax(BlockPos p1, BlockPos p2) {
        return new BlockPos(Math.max(p1.func_177958_n(), p2.func_177958_n()), Math.max(p1.func_177956_o(), p2.func_177956_o()), Math.max(p1.func_177952_p(), p2.func_177952_p()));
    }

    public static void setMin(BlockPos.MutableBlockPos p1, BlockPos p2) {
        p1.func_181079_c(Math.min(p1.func_177958_n(), p2.func_177958_n()), Math.min(p1.func_177956_o(), p2.func_177956_o()), Math.min(p1.func_177952_p(), p2.func_177952_p()));
    }

    public static void setMax(BlockPos.MutableBlockPos p1, BlockPos p2) {
        p1.func_181079_c(Math.max(p1.func_177958_n(), p2.func_177958_n()), Math.max(p1.func_177956_o(), p2.func_177956_o()), Math.max(p1.func_177952_p(), p2.func_177952_p()));
    }

    public static BlockPos getCenter(BlockPos p1, BlockPos p2) {
        BlockPos min = BlockPosUtil.getMin(p1, p2);
        return new BlockPos(BlockPosUtil.getXDist(p1, p2) / 2 + min.func_177958_n(), BlockPosUtil.getYDist(p1, p2) / 2 + min.func_177956_o(), BlockPosUtil.getYDist(p1, p2) / 2 + min.func_177956_o());
    }

    public static Vec3d getCenterD(BlockPos p1, BlockPos p2) {
        return BlockPosUtil.getCenterD(BlockPosUtil.getMin(p1, p2), BlockPosUtil.getXDist(p1, p2), BlockPosUtil.getYDist(p1, p2), BlockPosUtil.getZDist(p1, p2));
    }

    public static Vec3d getCenterD(BlockPos origin, int xs, int ys, int zs) {
        return new Vec3d((double)xs / 2.0 + (double)origin.func_177958_n(), (double)ys / 2.0 + (double)origin.func_177956_o(), (double)zs / 2.0 + (double)origin.func_177952_p());
    }

    public static Iterable<BlockPos.MutableBlockPos> getAllInside(BlockPos p1, BlockPos p2, boolean includeBorder) {
        int x0 = Math.min(p1.func_177958_n(), p2.func_177958_n());
        int y0 = Math.min(p1.func_177956_o(), p2.func_177956_o());
        int z0 = Math.min(p1.func_177952_p(), p2.func_177952_p());
        int x1 = Math.max(p1.func_177958_n(), p2.func_177958_n());
        int y1 = Math.max(p1.func_177956_o(), p2.func_177956_o());
        int z1 = Math.max(p1.func_177952_p(), p2.func_177952_p());
        if (includeBorder) {
            --x0;
            --y0;
            --z0;
        } else {
            --x1;
            --y1;
            --z1;
        }
        return BlockPos.func_191531_b((int)x0, (int)y0, (int)z0, (int)x1, (int)y1, (int)z1);
    }

    public static boolean isOnBorder(BlockPos boxMin, BlockPos boxMax, BlockPos p) {
        return p.func_177958_n() == boxMin.func_177958_n() || p.func_177958_n() == boxMax.func_177958_n() || p.func_177956_o() == boxMin.func_177956_o() || p.func_177956_o() == boxMax.func_177956_o() || p.func_177952_p() == boxMin.func_177952_p() || p.func_177952_p() == boxMax.func_177952_p();
    }

    public static BlockPos.MutableBlockPos add(BlockPos.MutableBlockPos pos, int x, int y, int z) {
        return pos.func_181079_c(pos.func_177958_n() + x, pos.func_177956_o() + y, pos.func_177952_p() + z);
    }
}

