/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.widgets;

import com.cleanroommc.modularui.api.widget.IWidget;
import com.cleanroommc.modularui.widget.Widget;
import java.util.ArrayList;
import java.util.List;
import java.util.function.IntConsumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public class PagedWidget<W extends PagedWidget<W>>
extends Widget<W> {
    private final List<IWidget> pages = new ArrayList<IWidget>();
    private IWidget currentPage;
    private int currentPageIndex = 0;
    @Nullable
    private IntConsumer onPageChange;

    @Override
    public void afterInit() {
        this.setPage(this.currentPageIndex);
    }

    public W onPageChange(@Nullable IntConsumer onPageChange) {
        this.onPageChange = onPageChange;
        return (W)((PagedWidget)this.getThis());
    }

    public void setPage(int page) {
        if (page < 0 || page >= this.pages.size()) {
            throw new IndexOutOfBoundsException("Setting page of " + this + " to " + page + " failed. Only values from 0 to " + (this.pages.size() - 1) + " are allowed.");
        }
        this.currentPageIndex = page;
        if (this.currentPage != null) {
            this.currentPage.setEnabled(false);
        }
        this.currentPage = this.pages.get(this.currentPageIndex);
        this.currentPage.setEnabled(true);
        if (this.onPageChange != null) {
            this.onPageChange.accept(page);
        }
    }

    public void nextPage() {
        if (++this.currentPageIndex == this.pages.size()) {
            this.currentPageIndex = 0;
        }
        this.setPage(this.currentPageIndex);
    }

    public void previousPage() {
        if (--this.currentPageIndex == -1) {
            this.currentPageIndex = this.pages.size() - 1;
        }
        this.setPage(this.currentPageIndex);
    }

    public List<IWidget> getPages() {
        return this.pages;
    }

    public IWidget getCurrentPage() {
        return this.currentPage;
    }

    public int getCurrentPageIndex() {
        return this.currentPageIndex;
    }

    @Override
    public @Unmodifiable @NotNull List<IWidget> getChildren() {
        return this.pages;
    }

    public W initialPage(int page) {
        if (!this.isValid()) {
            this.currentPageIndex = page;
        }
        return (W)((PagedWidget)this.getThis());
    }

    public W addPage(IWidget widget) {
        this.pages.add(widget);
        widget.setEnabled(false);
        return (W)((PagedWidget)this.getThis());
    }

    public W controller(Controller controller) {
        controller.setPagedWidget(this);
        return (W)((PagedWidget)this.getThis());
    }

    public static class Controller {
        private PagedWidget<?> pagedWidget;

        public boolean isInitialised() {
            return this.pagedWidget != null && this.pagedWidget.isValid();
        }

        private void validate() {
            if (!this.isInitialised()) {
                throw new IllegalStateException("PagedWidget controller does not have a valid PagedWidget! Current PagedWidget: " + this.pagedWidget);
            }
        }

        private void setPagedWidget(PagedWidget<?> pagedWidget) {
            this.pagedWidget = pagedWidget;
        }

        public void setPage(int page) {
            this.validate();
            this.pagedWidget.setPage(page);
        }

        public void nextPage() {
            this.validate();
            this.pagedWidget.nextPage();
        }

        public void previousPage() {
            this.validate();
            this.pagedWidget.previousPage();
        }

        public IWidget getActivePage() {
            this.validate();
            return this.pagedWidget.getCurrentPage();
        }

        public int getActivePageIndex() {
            this.validate();
            return this.pagedWidget.getCurrentPageIndex();
        }
    }
}

