/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.widgets;

import com.cleanroommc.modularui.animation.Animator;
import com.cleanroommc.modularui.animation.IAnimator;
import com.cleanroommc.modularui.animation.SequentialAnimator;
import com.cleanroommc.modularui.animation.Wait;
import com.cleanroommc.modularui.api.drawable.IKey;
import com.cleanroommc.modularui.drawable.text.TextRenderer;
import com.cleanroommc.modularui.screen.viewport.ModularGuiContext;
import com.cleanroommc.modularui.theme.WidgetTheme;
import com.cleanroommc.modularui.theme.WidgetThemeEntry;
import com.cleanroommc.modularui.utils.Interpolation;
import com.cleanroommc.modularui.widgets.TextWidget;

public class ScrollingTextWidget
extends TextWidget<ScrollingTextWidget> {
    private TextRenderer.Line line;
    private float progress = 0.0f;
    private IAnimator animator;
    private Animator forward;
    private Animator backward;
    private int speed = 15;

    public ScrollingTextWidget(IKey key) {
        super(key);
        this.tooltipBuilder(tooltip -> {
            tooltip.showUpTimer(10);
            if (this.line.getWidth() > (float)this.getArea().width) {
                tooltip.addLine(key);
            }
        });
    }

    @Override
    public void dispose() {
        super.dispose();
        this.animator.stop(true);
    }

    @Override
    public void onMouseStartHover() {
        super.onMouseStartHover();
        this.animator.resume(false);
    }

    @Override
    public void onMouseEndHover() {
        super.onMouseEndHover();
        this.animator.stop(true);
        this.animator.reset();
        this.progress = 0.0f;
    }

    @Override
    public void draw(ModularGuiContext context, WidgetThemeEntry<?> widgetTheme) {
        if (this.animator == null) {
            this.animator(new Animator().curve(Interpolation.SINE_INOUT));
        }
        if (this.line == null) {
            this.updateLine(this.getKey().getFormatted());
        }
        this.checkString();
        WidgetTheme theme = this.getActiveWidgetTheme(widgetTheme, this.isHovering());
        TextRenderer renderer = TextRenderer.SHARED;
        renderer.setColor(this.getColor() != null ? this.getColor().getAsInt() : theme.getTextColor());
        renderer.setAlignment(this.getAlignment(), this.getArea().w(), this.getArea().h());
        renderer.setShadow(this.isShadow() != null ? this.isShadow().booleanValue() : theme.getTextShadow());
        renderer.setPos(this.getArea().getPadding().getLeft(), this.getArea().getPadding().getTop());
        renderer.setScale(this.getScale());
        renderer.setSimulate(false);
        if (this.isHovering()) {
            renderer.drawScrolling(this.line, this.progress, this.getArea(), context);
        } else {
            renderer.drawCut(this.line);
        }
    }

    @Override
    protected void onTextChanged(String newText) {
        super.onTextChanged(newText);
        this.updateLine(newText);
        this.markTooltipDirty();
    }

    protected void updateLine(String newText) {
        TextRenderer.SHARED.setScale(this.getScale());
        this.line = TextRenderer.SHARED.line(newText);
        this.animator.stop(true);
        this.animator.reset();
        this.forward.duration(this.line.upperWidth() * this.speed);
        this.backward.duration(this.forward.getDuration() * 3 / 4);
    }

    public ScrollingTextWidget scrollSpeed(int speed) {
        this.speed = speed;
        return this;
    }

    public ScrollingTextWidget animator(Animator animator) {
        this.forward = animator.onUpdate(val -> {
            this.progress = (float)val;
        });
        this.backward = animator.copy(true);
        this.animator = new SequentialAnimator(this.forward, new Wait(500), this.backward, new Wait(1000)).repeatsOnFinish(20);
        return this;
    }
}

