/*
 * Decompiled with CFR 0.152.
 */
package org.mariuszgromada.math.mxparser.mathcollection;

import org.mariuszgromada.math.mxparser.Argument;
import org.mariuszgromada.math.mxparser.Expression;
import org.mariuszgromada.math.mxparser.mXparser;
import org.mariuszgromada.math.mxparser.mathcollection.MathFunctions;
import org.mariuszgromada.math.mxparser.mathcollection.ProbabilityDistributions;

public final class Calculus {
    public static final int LEFT_DERIVATIVE = 1;
    public static final int RIGHT_DERIVATIVE = 2;
    public static final int GENERAL_DERIVATIVE = 3;

    public static double integralTrapezoid(Expression f, Argument x, double a, double b, double eps, int maxSteps) {
        double h = 0.5 * (b - a);
        double s = MathFunctions.getFunctionValue(f, x, a) + MathFunctions.getFunctionValue(f, x, b) + 2.0 * MathFunctions.getFunctionValue(f, x, a + h);
        double intF = s * h * 0.5;
        double intFprev = 0.0;
        double t = a;
        int n = 1;
        for (int i = 1; i <= maxSteps; ++i) {
            n += n;
            t = a + 0.5 * h;
            intFprev = intF;
            for (int j = 1; j <= n; ++j) {
                if (mXparser.isCurrentCalculationCancelled()) {
                    return Double.NaN;
                }
                s += 2.0 * MathFunctions.getFunctionValue(f, x, t);
                t += h;
            }
            intF = s * (h *= 0.5) * 0.5;
            if (Math.abs(intF - intFprev) <= eps) {
                return intF;
            }
            if (!mXparser.isCurrentCalculationCancelled()) continue;
            return Double.NaN;
        }
        return intF;
    }

    public static double derivative(Expression f, Argument x, double x0, int derType, double eps, int maxSteps) {
        double START_DX = 0.1;
        int step = 0;
        double error = 2.0 * eps;
        double y0 = 0.0;
        double derF = 0.0;
        double derFprev = 0.0;
        double dx = 0.0;
        dx = derType == 1 ? -0.1 : 0.1;
        double dy = 0.0;
        if (derType == 1 || derType == 2) {
            y0 = MathFunctions.getFunctionValue(f, x, x0);
            dy = MathFunctions.getFunctionValue(f, x, x0 + dx) - y0;
            derF = dy / dx;
        } else {
            derF = (MathFunctions.getFunctionValue(f, x, x0 + dx) - MathFunctions.getFunctionValue(f, x, x0 - dx)) / (2.0 * dx);
        }
        do {
            derFprev = derF;
            dx /= 2.0;
            if (derType == 1 || derType == 2) {
                dy = MathFunctions.getFunctionValue(f, x, x0 + dx) - y0;
                derF = dy / dx;
            } else {
                derF = (MathFunctions.getFunctionValue(f, x, x0 + dx) - MathFunctions.getFunctionValue(f, x, x0 - dx)) / (2.0 * dx);
            }
            error = Math.abs(derF - derFprev);
            ++step;
            if (!mXparser.isCurrentCalculationCancelled()) continue;
            return Double.NaN;
        } while (step < maxSteps && (error > eps || Double.isNaN(derF)));
        return derF;
    }

    public static double derivativeNth(Expression f, double n, Argument x, double x0, int derType, double eps, int maxSteps) {
        int i;
        n = Math.round(n);
        int step = 0;
        double error = 2.0 * eps;
        double derFprev = 0.0;
        double dx = 0.01;
        double derF = 0.0;
        if (derType == 2) {
            i = 1;
            while ((double)i <= n) {
                derF += MathFunctions.binomCoeff(-1.0, n - (double)i) * MathFunctions.binomCoeff(n, i) * MathFunctions.getFunctionValue(f, x, x0 + (double)i * dx);
                ++i;
            }
        } else {
            i = 1;
            while ((double)i <= n) {
                derF += MathFunctions.binomCoeff(-1.0, i) * MathFunctions.binomCoeff(n, i) * MathFunctions.getFunctionValue(f, x, x0 - (double)i * dx);
                ++i;
            }
        }
        derF /= Math.pow(dx, n);
        do {
            derFprev = derF;
            dx /= 2.0;
            derF = 0.0;
            if (derType == 2) {
                i = 1;
                while ((double)i <= n) {
                    derF += MathFunctions.binomCoeff(-1.0, n - (double)i) * MathFunctions.binomCoeff(n, i) * MathFunctions.getFunctionValue(f, x, x0 + (double)i * dx);
                    ++i;
                }
            } else {
                i = 1;
                while ((double)i <= n) {
                    derF += MathFunctions.binomCoeff(-1.0, i) * MathFunctions.binomCoeff(n, i) * MathFunctions.getFunctionValue(f, x, x0 - (double)i * dx);
                    ++i;
                }
            }
            error = Math.abs((derF /= Math.pow(dx, n)) - derFprev);
            ++step;
            if (!mXparser.isCurrentCalculationCancelled()) continue;
            return Double.NaN;
        } while (step < maxSteps && (error > eps || Double.isNaN(derF)));
        return derF;
    }

    public static double forwardDifference(Expression f, Argument x, double x0) {
        if (Double.isNaN(x0)) {
            return Double.NaN;
        }
        double xb = x.getArgumentValue();
        double delta = MathFunctions.getFunctionValue(f, x, x0 + 1.0) - MathFunctions.getFunctionValue(f, x, x0);
        x.setArgumentValue(xb);
        return delta;
    }

    public static double forwardDifference(Expression f, Argument x) {
        double xb = x.getArgumentValue();
        if (Double.isNaN(xb)) {
            return Double.NaN;
        }
        double fv = f.calculate();
        x.setArgumentValue(xb + 1.0);
        double delta = f.calculate() - fv;
        x.setArgumentValue(xb);
        return delta;
    }

    public static double backwardDifference(Expression f, Argument x, double x0) {
        if (Double.isNaN(x0)) {
            return Double.NaN;
        }
        double xb = x.getArgumentValue();
        double delta = MathFunctions.getFunctionValue(f, x, x0) - MathFunctions.getFunctionValue(f, x, x0 - 1.0);
        x.setArgumentValue(xb);
        return delta;
    }

    public static double backwardDifference(Expression f, Argument x) {
        double xb = x.getArgumentValue();
        if (Double.isNaN(xb)) {
            return Double.NaN;
        }
        double fv = f.calculate();
        x.setArgumentValue(xb - 1.0);
        double delta = fv - f.calculate();
        x.setArgumentValue(xb);
        return delta;
    }

    public static double forwardDifference(Expression f, double h, Argument x, double x0) {
        if (Double.isNaN(x0)) {
            return Double.NaN;
        }
        double xb = x.getArgumentValue();
        double delta = MathFunctions.getFunctionValue(f, x, x0 + h) - MathFunctions.getFunctionValue(f, x, x0);
        x.setArgumentValue(xb);
        return delta;
    }

    public static double forwardDifference(Expression f, double h, Argument x) {
        double xb = x.getArgumentValue();
        if (Double.isNaN(xb)) {
            return Double.NaN;
        }
        double fv = f.calculate();
        x.setArgumentValue(xb + h);
        double delta = f.calculate() - fv;
        x.setArgumentValue(xb);
        return delta;
    }

    public static double backwardDifference(Expression f, double h, Argument x, double x0) {
        if (Double.isNaN(x0)) {
            return Double.NaN;
        }
        double xb = x.getArgumentValue();
        double delta = MathFunctions.getFunctionValue(f, x, x0) - MathFunctions.getFunctionValue(f, x, x0 - h);
        x.setArgumentValue(xb);
        return delta;
    }

    public static double backwardDifference(Expression f, double h, Argument x) {
        double xb = x.getArgumentValue();
        if (Double.isNaN(xb)) {
            return Double.NaN;
        }
        double fv = f.calculate();
        x.setArgumentValue(xb - h);
        double delta = fv - f.calculate();
        x.setArgumentValue(xb);
        return delta;
    }

    public static double solveBrent(Expression f, Argument x, double a, double b, double eps, double maxSteps) {
        double c;
        double tmp;
        if (b < a) {
            tmp = a;
            a = b;
            b = tmp;
        }
        double fa = MathFunctions.getFunctionValue(f, x, a);
        double fb = MathFunctions.getFunctionValue(f, x, b);
        if (MathFunctions.abs(fa) <= eps) {
            return a;
        }
        if (MathFunctions.abs(fb) <= eps) {
            return b;
        }
        if (b == a) {
            return Double.NaN;
        }
        if (fa * fb > 0.0) {
            boolean rndflag = false;
            int i = 0;
            while ((double)i < maxSteps) {
                double ap = ProbabilityDistributions.rndUniformContinuous(a, b);
                double bp = ProbabilityDistributions.rndUniformContinuous(a, b);
                if (bp < ap) {
                    tmp = ap;
                    ap = bp;
                    bp = tmp;
                }
                fa = MathFunctions.getFunctionValue(f, x, ap);
                fb = MathFunctions.getFunctionValue(f, x, bp);
                if (MathFunctions.abs(fa) <= eps) {
                    return ap;
                }
                if (MathFunctions.abs(fb) <= eps) {
                    return bp;
                }
                if (fa * fb < 0.0) {
                    rndflag = true;
                    a = ap;
                    b = bp;
                    break;
                }
                if (mXparser.isCurrentCalculationCancelled()) {
                    return Double.NaN;
                }
                ++i;
            }
            if (!rndflag) {
                return Double.NaN;
            }
        }
        double d = c = a;
        double fc = MathFunctions.getFunctionValue(f, x, c);
        if (MathFunctions.abs(fa) < MathFunctions.abs(fb)) {
            tmp = a;
            a = b;
            b = tmp;
            tmp = fa;
            fa = fb;
            fb = tmp;
        }
        boolean mflag = true;
        int iter = 0;
        while (MathFunctions.abs(fb) > eps && MathFunctions.abs(b - a) > eps && (double)iter < maxSteps) {
            double s;
            if (fa != fc && fb != fc) {
                double c0 = a * fb * fc / ((fa - fb) * (fa - fc));
                double c1 = b * fa * fc / ((fb - fa) * (fb - fc));
                double c2 = c * fa * fb / ((fc - fa) * (fc - fb));
                s = c0 + c1 + c2;
            } else {
                s = b - fb * (b - a) / (fb - fa);
            }
            if (s < 3.0 * (a + b) / 4.0 || s > b || mflag && MathFunctions.abs(s - b) >= MathFunctions.abs(b - c) / 2.0 || !mflag && MathFunctions.abs(s - b) >= MathFunctions.abs(c - d) / 2.0) {
                s = (a + b) / 2.0;
                mflag = true;
            } else {
                mflag = true;
            }
            double fs = MathFunctions.getFunctionValue(f, x, s);
            d = c;
            c = b;
            fc = fb;
            if (fa * fs < 0.0) {
                b = s;
            } else {
                a = s;
            }
            if (MathFunctions.abs(fa) < MathFunctions.abs(fb)) {
                tmp = a;
                a = b;
                b = tmp;
                tmp = fa;
                fa = fb;
                fb = tmp;
            }
            ++iter;
            if (!mXparser.isCurrentCalculationCancelled()) continue;
            return Double.NaN;
        }
        return MathFunctions.round(b, MathFunctions.decimalDigitsBefore(eps) - 1);
    }
}

