/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.api;

import com.cleanroommc.modularui.api.ITheme;
import com.cleanroommc.modularui.drawable.GuiTextures;
import com.cleanroommc.modularui.screen.ModularScreen;
import com.cleanroommc.modularui.theme.SelectableTheme;
import com.cleanroommc.modularui.theme.SlotTheme;
import com.cleanroommc.modularui.theme.TextFieldTheme;
import com.cleanroommc.modularui.theme.ThemeAPI;
import com.cleanroommc.modularui.theme.ThemeBuilder;
import com.cleanroommc.modularui.theme.WidgetTheme;
import com.cleanroommc.modularui.theme.WidgetThemeKey;
import com.cleanroommc.modularui.theme.WidgetThemeKeyBuilder;
import com.cleanroommc.modularui.theme.WidgetThemeParser;
import com.cleanroommc.modularui.utils.JsonBuilder;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnmodifiableView;

@ApiStatus.NonExtendable
public interface IThemeApi {
    public static final WidgetThemeKey<WidgetTheme> FALLBACK = IThemeApi.get().widgetThemeKeyBuilder("default", WidgetTheme.class).defaultTheme(WidgetTheme.darkTextNoShadow(18, 18, null)).register();
    public static final WidgetThemeKey<WidgetTheme> PANEL = IThemeApi.get().widgetThemeKeyBuilder("panel", WidgetTheme.class).defaultTheme(WidgetTheme.darkTextNoShadow(176, 166, GuiTextures.MC_BACKGROUND)).register();
    public static final WidgetThemeKey<WidgetTheme> BUTTON = IThemeApi.get().widgetThemeKeyBuilder("button", WidgetTheme.class).defaultTheme(WidgetTheme.whiteTextShadow(18, 18, GuiTextures.MC_BUTTON)).defaultHoverTheme(WidgetTheme.whiteTextShadow(18, 18, GuiTextures.MC_BUTTON_HOVERED)).register();
    public static final WidgetThemeKey<SlotTheme> ITEM_SLOT = IThemeApi.get().widgetThemeKeyBuilder("itemSlot", SlotTheme.class).defaultTheme(new SlotTheme(GuiTextures.SLOT_ITEM)).register();
    public static final WidgetThemeKey<SlotTheme> FLUID_SLOT = IThemeApi.get().widgetThemeKeyBuilder("fluidSlot", SlotTheme.class).defaultTheme(new SlotTheme(GuiTextures.SLOT_FLUID)).register();
    public static final WidgetThemeKey<TextFieldTheme> TEXT_FIELD = IThemeApi.get().widgetThemeKeyBuilder("textField", TextFieldTheme.class).defaultTheme(new TextFieldTheme(-13667672, -10526881)).register();
    public static final WidgetThemeKey<SelectableTheme> TOGGLE_BUTTON = IThemeApi.get().widgetThemeKeyBuilder("toggleButton", SelectableTheme.class).defaultTheme(SelectableTheme.whiteTextShadow(18, 18, GuiTextures.MC_BUTTON, GuiTextures.MC_BUTTON_DISABLED)).defaultHoverTheme(SelectableTheme.whiteTextShadow(18, 18, GuiTextures.MC_BUTTON_HOVERED, GuiTextures.MC_BUTTON_DISABLED)).register();
    public static final WidgetThemeKey<SlotTheme> ITEM_SLOT_PLAYER = ITEM_SLOT.createSubKey("player");
    public static final WidgetThemeKey<SlotTheme> ITEM_SLOT_PLAYER_HOTBAR = ITEM_SLOT_PLAYER.createSubKey("playerHotbar");
    public static final WidgetThemeKey<SlotTheme> ITEM_SLOT_PLAYER_MAIN_INV = ITEM_SLOT_PLAYER.createSubKey("playerMainInventory");
    public static final WidgetThemeKey<SlotTheme> ITEM_SLOT_PLAYER_OFFHAND = ITEM_SLOT_PLAYER.createSubKey("playerOffhand");
    public static final WidgetThemeKey<SlotTheme> ITEM_SLOT_PLAYER_ARMOR = ITEM_SLOT_PLAYER.createSubKey("playerArmor");
    public static final String HOVER_SUFFIX = ":hover";
    public static final String PARENT = "parent";
    public static final String DEFAULT_WIDTH = "defaultWidth";
    public static final String DEFAULT_HEIGHT = "defaultHeight";
    public static final String BACKGROUND = "background";
    public static final String COLOR = "color";
    public static final String TEXT_COLOR = "textColor";
    public static final String TEXT_SHADOW = "textShadow";
    public static final String ICON_COLOR = "iconColor";
    public static final String SLOT_HOVER_COLOR = "slotHoverColor";
    public static final String MARKED_COLOR = "markedColor";
    public static final String HINT_COLOR = "hintColor";
    public static final String SELECTED_BACKGROUND = "selectedBackground";
    public static final String SELECTED_COLOR = "selectedColor";
    public static final String SELECTED_TEXT_COLOR = "selectedTextColor";
    public static final String SELECTED_TEXT_SHADOW = "selectedTextShadow";
    public static final String SELECTED_ICON_COLOR = "selectedIconColor";

    @Contract(pure=true)
    public static IThemeApi get() {
        return ThemeAPI.INSTANCE;
    }

    public ITheme getDefaultTheme();

    @NotNull
    public ITheme getTheme(String var1);

    public boolean hasTheme(String var1);

    public void registerTheme(String var1, JsonBuilder var2);

    default public void registerTheme(ThemeBuilder<?> themeBuilder) {
        this.registerTheme(themeBuilder.getId(), themeBuilder);
    }

    public List<JsonBuilder> getJavaDefaultThemes(String var1);

    public ITheme getThemeForScreen(String var1, String var2, @Nullable String var3);

    default public ITheme getThemeForScreen(ModularScreen screen, @Nullable String defaultTheme) {
        return this.getThemeForScreen(screen.getOwner(), screen.getName(), defaultTheme);
    }

    default public void registerThemeForScreen(String owner, String name, String theme) {
        this.registerThemeForScreen(owner + ":" + name, theme);
    }

    public void registerThemeForScreen(String var1, String var2);

    public <T extends WidgetTheme> WidgetThemeKey<T> registerWidgetTheme(String var1, T var2, T var3, WidgetThemeParser<T> var4);

    default public <T extends WidgetTheme> WidgetThemeKeyBuilder<T> widgetThemeKeyBuilder(String id, Class<T> type) {
        return new WidgetThemeKeyBuilder(id);
    }

    public @UnmodifiableView List<WidgetThemeKey<?>> getWidgetThemeKeys();
}

