/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.api;

import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import org.jetbrains.annotations.Nullable;

public class MCHelper {
    public static boolean hasMc() {
        return MCHelper.getMc() != null;
    }

    @Nullable
    public static Minecraft getMc() {
        return Minecraft.getMinecraft();
    }

    @Nullable
    public static EntityPlayerSP getPlayer() {
        if (MCHelper.hasMc()) {
            return MCHelper.getMc().player;
        }
        return null;
    }

    public static boolean closeScreen() {
        if (!MCHelper.hasMc()) {
            return false;
        }
        EntityPlayerSP player = MCHelper.getPlayer();
        if (player != null) {
            player.closeScreen();
            return true;
        }
        Minecraft.getMinecraft().displayGuiScreen(null);
        return false;
    }

    public static boolean displayScreen(GuiScreen screen) {
        Minecraft mc = MCHelper.getMc();
        if (mc != null) {
            mc.displayGuiScreen(screen);
            return true;
        }
        return false;
    }

    public static GuiScreen getCurrentScreen() {
        Minecraft mc = MCHelper.getMc();
        return mc != null ? mc.currentScreen : null;
    }

    public static FontRenderer getFontRenderer() {
        if (MCHelper.hasMc()) {
            return MCHelper.getMc().fontRenderer;
        }
        return null;
    }

    public static List<String> getItemToolTip(ItemStack item) {
        if (!MCHelper.hasMc()) {
            return Collections.emptyList();
        }
        if (MCHelper.getMc().currentScreen != null) {
            return MCHelper.getMc().currentScreen.getItemToolTip(item);
        }
        List list = item.getTooltip((EntityPlayer)MCHelper.getPlayer(), (ITooltipFlag)(MCHelper.getMc().gameSettings.advancedItemTooltips ? ITooltipFlag.TooltipFlags.ADVANCED : ITooltipFlag.TooltipFlags.NORMAL));
        for (int i = 0; i < list.size(); ++i) {
            if (i == 0) {
                list.set(i, item.getItem().getForgeRarity(item).getColor() + (String)list.get(i));
                continue;
            }
            list.set(i, TextFormatting.GRAY + (String)list.get(i));
        }
        return list;
    }
}

