/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.config;

import com.cleanroommc.modularui.config.ConfigPanel;
import com.cleanroommc.modularui.config.Value;
import com.cleanroommc.modularui.network.NetworkHandler;
import com.cleanroommc.modularui.network.packets.SyncConfig;
import com.cleanroommc.modularui.screen.ModularScreen;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import java.io.File;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.stream.Collectors;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.common.Loader;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Deprecated
@ApiStatus.Experimental
public class Config {
    private static final Map<String, Config> configs = new Object2ObjectLinkedOpenHashMap();
    private static final Path configPath = Loader.instance().getConfigDir().toPath();
    private final String name;
    private final String basePath;
    private final Map<String, Config> categories = new Object2ObjectLinkedOpenHashMap();
    private final Map<String, Value> values = new Object2ObjectLinkedOpenHashMap();
    private final File filePath;
    private final boolean synced;

    @NotNull
    public static Config getConfig(String name) {
        Config config = configs.get(name);
        if (config == null) {
            throw new NoSuchElementException("No config with name " + name + " is registered!");
        }
        return config;
    }

    public static Builder builder(String name) {
        if (configs.containsKey(name)) {
            throw new IllegalStateException("Config already exists with name " + name);
        }
        return new Builder(name, null);
    }

    public Config(String name, Map<String, Config> categories, Map<String, Value> values, String basePath, boolean synced) {
        this.name = name;
        this.basePath = basePath;
        this.categories.putAll(categories);
        this.values.putAll(values);
        String path = configPath.toString();
        if (!this.basePath.isEmpty()) {
            path = path + File.separator + this.basePath;
        }
        path = path + File.separator + this.name + ".json";
        this.filePath = new File(path);
        configs.put(name, this);
        this.synced = synced && this.determineSynced();
    }

    private boolean determineSynced() {
        for (Config category : this.categories.values()) {
            if (!category.isSynced()) continue;
            return true;
        }
        for (Value value : this.values.values()) {
            if (!value.isSynced()) continue;
            return true;
        }
        return false;
    }

    public ModularScreen createScreen() {
        return new ModularScreen(new ConfigPanel(this));
    }

    public JsonObject serialize() {
        JsonObject json = new JsonObject();
        for (Map.Entry<String, Value> entry : this.values.entrySet()) {
            JsonElement jsonElement = entry.getValue().writeJson();
            json.add(entry.getKey(), jsonElement);
        }
        for (Map.Entry<String, Object> entry : this.categories.entrySet()) {
            JsonObject jsonObject = ((Config)entry.getValue()).serialize();
            json.add(entry.getKey(), (JsonElement)jsonObject);
        }
        return json;
    }

    public void deserialize(JsonObject json) {
        for (Map.Entry entry : json.entrySet()) {
            Config category;
            if (((JsonElement)entry.getValue()).isJsonObject() && (category = this.categories.get(entry.getKey())) != null) {
                category.deserialize(((JsonElement)entry.getValue()).getAsJsonObject());
                continue;
            }
            Value value = this.values.get(entry.getKey());
            if (value == null) continue;
            value.readJson((JsonElement)entry.getValue());
        }
    }

    public void syncToServer() {
        if (!this.synced) {
            return;
        }
        NetworkHandler.sendToServer(new SyncConfig(this));
    }

    public void writeToBuffer(PacketBuffer buffer) {
        List categories = this.categories.values().stream().filter(Config::isSynced).collect(Collectors.toList());
        List values = this.values.values().stream().filter(Value::isSynced).collect(Collectors.toList());
        buffer.writeVarInt(categories.size());
        for (Config category : categories) {
            buffer.writeString(category.getName());
            category.writeToBuffer(buffer);
        }
        buffer.writeVarInt(values.size());
        for (Value value : values) {
            buffer.writeString(value.getKey());
            value.writeToPacket(buffer);
        }
    }

    public void readFromBuffer(PacketBuffer buffer) {
        int i;
        int n = buffer.readVarInt();
        for (i = 0; i < n; ++i) {
            Config category = this.categories.get(buffer.readString(64));
            category.readFromBuffer(buffer);
        }
        n = buffer.readVarInt();
        for (i = 0; i < n; ++i) {
            Value value = this.values.get(buffer.readString(64));
            value.readFromPacket(buffer);
        }
    }

    public String getName() {
        return this.name;
    }

    public File getFilePath() {
        return this.filePath;
    }

    public boolean isSynced() {
        return this.synced;
    }

    public static class Builder {
        private final String name;
        private final Builder parent;
        private String basePath = "modularui";
        private final Map<String, Config> categories = new Object2ObjectLinkedOpenHashMap();
        private final Map<String, Value> values = new Object2ObjectLinkedOpenHashMap();
        private boolean synced = true;

        private Builder(String name, Builder parent) {
            this.name = name;
            this.parent = parent;
        }

        public Builder basePath(String basePath) {
            this.basePath = basePath;
            return this;
        }

        public Builder synced(boolean synced) {
            this.synced = synced;
            return this;
        }

        public Value value(Value value) {
            this.values.put(value.getKey(), value);
            return value;
        }

        public Builder createCategory(String name) {
            return new Builder(name, this);
        }

        public Builder buildCategory() {
            if (this.parent == null) {
                throw new IllegalStateException("Call 'build' on root config");
            }
            Config config = this.buildInternal();
            this.parent.categories.put(this.name, config);
            return this.parent;
        }

        public Config build() {
            if (this.parent != null) {
                throw new IllegalStateException("Call 'buildCategory' on categories!");
            }
            return this.buildInternal();
        }

        private Config buildInternal() {
            return new Config(this.name, this.categories, this.values, this.basePath, this.synced);
        }
    }
}

