/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.drawable.text;

import com.cleanroommc.modularui.drawable.text.FontRenderHelper;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.util.text.TextFormatting;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.jetbrains.annotations.Nullable;

public class FormattingState {
    private TextFormatting reset;
    private TextFormatting color;
    private TextFormatting underline;
    private TextFormatting italic;
    private TextFormatting bold;
    private TextFormatting strikethrough;
    private TextFormatting obfuscated;
    private boolean forceDefaultColor;

    public void reset() {
        this.reset = null;
        this.color = null;
        this.underline = null;
        this.italic = null;
        this.bold = null;
        this.strikethrough = null;
        this.obfuscated = null;
        this.forceDefaultColor = false;
    }

    public void add(TextFormatting formatting, boolean removeAllOnReset) {
        if (formatting == TextFormatting.RESET) {
            if (removeAllOnReset) {
                this.reset();
            }
            this.reset = formatting;
            return;
        }
        if (formatting.isFancyStyling()) {
            switch (formatting) {
                case UNDERLINE: {
                    this.underline = formatting;
                    break;
                }
                case ITALIC: {
                    this.italic = formatting;
                    break;
                }
                case BOLD: {
                    this.bold = formatting;
                    break;
                }
                case STRIKETHROUGH: {
                    this.strikethrough = formatting;
                    break;
                }
                case OBFUSCATED: {
                    this.obfuscated = formatting;
                }
            }
            return;
        }
        this.color = formatting;
    }

    public void forceDefaultColor() {
        this.forceDefaultColor = true;
        this.color = null;
    }

    public String getFormatting() {
        StringBuilder sb = new StringBuilder();
        if (this.reset != null) {
            sb.append(this.reset);
        }
        if (this.color != null) {
            sb.append(this.color);
        }
        if (this.underline != null) {
            sb.append(this.underline);
        }
        if (this.italic != null) {
            sb.append(this.italic);
        }
        if (this.bold != null) {
            sb.append(this.bold);
        }
        if (this.strikethrough != null) {
            sb.append(this.strikethrough);
        }
        if (this.obfuscated != null) {
            sb.append(this.obfuscated);
        }
        return sb.toString();
    }

    public StringBuilder prependText(StringBuilder builder) {
        return this.prependText(builder, null);
    }

    public StringBuilder prependText(StringBuilder builder, @Nullable FormattingState fallback) {
        FormattingState.prependText(this, fallback, fs -> fs.reset, builder);
        if (!this.forceDefaultColor) {
            if (this.color != null) {
                builder.append(this.color);
            } else if (fallback != null && !fallback.forceDefaultColor && fallback.color != null) {
                builder.append(fallback.color);
            }
        }
        FormattingState.prependText(this, fallback, fs -> fs.underline, builder);
        FormattingState.prependText(this, fallback, fs -> fs.italic, builder);
        FormattingState.prependText(this, fallback, fs -> fs.bold, builder);
        FormattingState.prependText(this, fallback, fs -> fs.strikethrough, builder);
        FormattingState.prependText(this, fallback, fs -> fs.obfuscated, builder);
        return builder;
    }

    public void setFrom(FormattingState state) {
        this.reset = state.reset;
        this.color = state.color;
        this.underline = state.underline;
        this.italic = state.italic;
        this.bold = state.bold;
        this.strikethrough = state.strikethrough;
        this.obfuscated = state.obfuscated;
        this.forceDefaultColor = state.forceDefaultColor;
    }

    public void parseFrom(String text) {
        int i = -2;
        while ((i = text.indexOf(167, i + 2)) >= 0 && i < text.length() - 1) {
            TextFormatting formatting = FontRenderHelper.getForCharacter(text.charAt(i + 1));
            if (formatting == null) continue;
            this.add(formatting, true);
        }
    }

    public FormattingState copy() {
        FormattingState state = new FormattingState();
        state.setFrom(this);
        return state;
    }

    public FormattingState merge(FormattingState state) {
        if (state.hasReset()) {
            this.setFrom(state);
            return this;
        }
        if (state.color != null) {
            this.color = state.color;
        }
        if (state.underline != null) {
            this.underline = state.underline;
        }
        if (state.italic != null) {
            this.italic = state.italic;
        }
        if (state.bold != null) {
            this.bold = state.bold;
        }
        if (state.strikethrough != null) {
            this.strikethrough = state.strikethrough;
        }
        if (state.obfuscated != null) {
            this.obfuscated = state.obfuscated;
        }
        if (state.forceDefaultColor) {
            this.forceDefaultColor();
        }
        return this;
    }

    public boolean hasReset() {
        return this.reset != null;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("reset", (Object)this.reset).append("color", (Object)this.color).append("underline", (Object)this.underline).append("italic", (Object)this.italic).append("bold", (Object)this.bold).append("strikethrough", (Object)this.strikethrough).append("obfuscated", (Object)this.obfuscated).append("forceDefaultColor", this.forceDefaultColor).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FormattingState that = (FormattingState)o;
        return this.forceDefaultColor == that.forceDefaultColor && this.reset == that.reset && this.color == that.color && this.underline == that.underline && this.italic == that.italic && this.bold == that.bold && this.strikethrough == that.strikethrough && this.obfuscated == that.obfuscated;
    }

    public int hashCode() {
        return Objects.hash(this.reset, this.color, this.underline, this.italic, this.bold, this.strikethrough, this.obfuscated, this.forceDefaultColor);
    }

    private static void prependText(FormattingState state, @Nullable FormattingState fallback, Function<FormattingState, TextFormatting> getter, StringBuilder builder) {
        if (getter.apply(state) != null) {
            builder.append(getter.apply(state));
        } else if (fallback != null && getter.apply(fallback) != null) {
            builder.append(getter.apply(fallback));
        }
    }

    public static FormattingState merge(@Nullable FormattingState state1, @Nullable FormattingState state2) {
        return FormattingState.merge(state1, state2, null);
    }

    public static FormattingState merge(@Nullable FormattingState state1, @Nullable FormattingState state2, @Nullable FormattingState result) {
        if (state1 == null) {
            if (state2 == null) {
                if (result == null) {
                    result = new FormattingState();
                }
                result.reset();
                return result;
            }
            return state2;
        }
        if (state2 == null) {
            return state1;
        }
        if (result == null) {
            result = new FormattingState();
        }
        if (result != state1) {
            result.setFrom(state1);
        }
        return result.merge(state2);
    }

    public static StringBuilder appendFormat(StringBuilder builder, @Nullable FormattingState state) {
        return FormattingState.appendFormat(builder, state, null);
    }

    public static StringBuilder appendFormat(StringBuilder builder, @Nullable FormattingState state, @Nullable FormattingState fallback) {
        if (state == null) {
            return builder;
        }
        return state.prependText(builder, fallback);
    }
}

