/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.screen.viewport;

import com.cleanroommc.modularui.ClientProxy;
import com.cleanroommc.modularui.api.ITheme;
import com.cleanroommc.modularui.api.MCHelper;
import com.cleanroommc.modularui.api.widget.IDraggable;
import com.cleanroommc.modularui.api.widget.IFocusedWidget;
import com.cleanroommc.modularui.api.widget.IGuiElement;
import com.cleanroommc.modularui.api.widget.IVanillaSlot;
import com.cleanroommc.modularui.api.widget.IWidget;
import com.cleanroommc.modularui.api.widget.ResizeDragArea;
import com.cleanroommc.modularui.screen.DraggablePanelWrapper;
import com.cleanroommc.modularui.screen.ModularPanel;
import com.cleanroommc.modularui.screen.ModularScreen;
import com.cleanroommc.modularui.screen.PanelManager;
import com.cleanroommc.modularui.screen.RecipeViewerSettingsImpl;
import com.cleanroommc.modularui.screen.UISettings;
import com.cleanroommc.modularui.screen.viewport.GuiContext;
import com.cleanroommc.modularui.screen.viewport.LocatedElement;
import com.cleanroommc.modularui.screen.viewport.LocatedWidget;
import com.cleanroommc.modularui.screen.viewport.TransformationMatrix;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiScreen;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModularGuiContext
extends GuiContext {
    private final ModularScreen screen;
    @Nullable
    private GuiScreen parent;
    private LocatedWidget focusedWidget = LocatedWidget.EMPTY;
    @Nullable
    private LocatedWidget hovered;
    private int timeHovered = 0;
    private final HoveredIterable hoveredWidgets;
    private LocatedElement<IDraggable> draggable;
    private int lastButton = -1;
    private long lastClickTime = 0L;
    private int lastDragX;
    private int lastDragY;
    public List<Consumer<ModularGuiContext>> postRenderCallbacks = new ArrayList<Consumer<ModularGuiContext>>();
    private UISettings settings;

    public ModularGuiContext(ModularScreen screen) {
        this.screen = screen;
        this.hoveredWidgets = new HoveredIterable(this.screen.getPanelManager());
    }

    public ModularScreen getScreen() {
        return this.screen;
    }

    @Nullable
    public GuiScreen getParentScreen() {
        return this.parent;
    }

    @ApiStatus.Internal
    public void setParentScreen(@Nullable GuiScreen parent) {
        this.parent = parent;
    }

    public boolean isHovered() {
        return this.hovered != null;
    }

    public boolean isHovered(IGuiElement guiElement) {
        return this.isHovered() && this.getHovered() == guiElement;
    }

    public boolean isHoveredFor(IGuiElement guiElement, int ticks) {
        return this.isHovered(guiElement) && this.timeHovered / 3 >= ticks;
    }

    @Nullable
    public IWidget getHovered() {
        return this.hovered != null ? (IWidget)this.hovered.getElement() : null;
    }

    public Iterable<IGuiElement> getAllBelowMouse() {
        return this.hoveredWidgets;
    }

    public boolean isFocused() {
        return this.focusedWidget.getElement() != null;
    }

    public boolean isFocused(IFocusedWidget widget) {
        return this.focusedWidget.getElement() == widget;
    }

    public LocatedWidget getFocusedWidget() {
        return this.focusedWidget;
    }

    public void focus(IFocusedWidget widget) {
        this.focus(LocatedWidget.of((IWidget)((Object)widget)));
    }

    public void focus(@NotNull LocatedWidget widget) {
        IFocusedWidget focusedWidget;
        if (this.focusedWidget.getElement() == widget.getElement()) {
            return;
        }
        if (widget.getElement() != null && !(widget.getElement() instanceof IFocusedWidget)) {
            throw new IllegalArgumentException();
        }
        if (this.focusedWidget.getElement() != null) {
            focusedWidget = (IFocusedWidget)this.focusedWidget.getElement();
            focusedWidget.onRemoveFocus(this);
            this.screen.setFocused(false);
        }
        this.focusedWidget = widget;
        if (this.focusedWidget.getElement() != null) {
            focusedWidget = (IFocusedWidget)this.focusedWidget.getElement();
            focusedWidget.onFocus(this);
            this.screen.setFocused(true);
        }
    }

    public void removeFocus() {
        this.focus(LocatedWidget.EMPTY);
    }

    public boolean focusNext(IWidget parent) {
        return this.focus(parent, -1, 1);
    }

    public boolean focusPrevious(IWidget parent) {
        return this.focus(parent, -1, -1);
    }

    public boolean focus(IWidget parent, int index, int factor) {
        return this.focus(parent, index, factor, false);
    }

    public boolean focus(IWidget widget, int index, int factor, boolean stop) {
        List<IWidget> children = widget.getChildren();
        factor = factor >= 0 ? 1 : -1;
        index += factor;
        while (index >= 0 && index < children.size()) {
            IWidget child = children.get(index);
            if (child.isEnabled()) {
                int start;
                if (child instanceof IFocusedWidget) {
                    IFocusedWidget focusedWidget1 = (IFocusedWidget)((Object)child);
                    this.focus(focusedWidget1);
                    return true;
                }
                int n = start = factor > 0 ? -1 : child.getChildren().size();
                if (this.focus(child, start, factor, true)) {
                    return true;
                }
            }
            index += factor;
        }
        IWidget grandparent = widget.getParent();
        boolean isRoot = grandparent instanceof ModularPanel;
        if (!stop && (isRoot || grandparent.canBeSeen(this))) {
            List<IWidget> siblings = grandparent.getChildren();
            if (this.focus(grandparent, siblings.indexOf(widget), factor)) {
                return true;
            }
            if (isRoot) {
                return this.focus(grandparent, factor > 0 ? -1 : siblings.size() - 1, factor);
            }
        }
        return false;
    }

    public boolean hasDraggable() {
        return this.draggable != null;
    }

    public boolean isMouseItemEmpty() {
        EntityPlayerSP player = MCHelper.getPlayer();
        return player == null || player.inventory.getItemStack().isEmpty();
    }

    @ApiStatus.Internal
    public boolean onMousePressed(int button) {
        if ((button == 0 || button == 1) && this.isMouseItemEmpty() && this.hasDraggable()) {
            this.dropDraggable();
            return true;
        }
        return false;
    }

    @ApiStatus.Internal
    public boolean onMouseReleased(int button) {
        if (button == this.lastButton && this.isMouseItemEmpty() && this.hasDraggable()) {
            long time = Minecraft.getSystemTime();
            if (time - this.lastClickTime < 200L) {
                return false;
            }
            this.dropDraggable();
            return true;
        }
        return false;
    }

    @ApiStatus.Internal
    public void dropDraggable() {
        this.draggable.applyMatrix(this);
        this.draggable.getElement().onDragEnd(this.draggable.getElement().canDropHere(this.getAbsMouseX(), this.getAbsMouseY(), this.getHovered()));
        this.draggable.getElement().setMoving(false);
        this.draggable.unapplyMatrix(this);
        this.draggable = null;
        this.lastButton = -1;
        this.lastClickTime = 0L;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @ApiStatus.Internal
    public boolean onHoveredClick(int button, LocatedWidget hovered) {
        LocatedElement<IDraggable> draggable;
        if (button != 0 && button != 1 || !this.isMouseItemEmpty() || this.hasDraggable()) return false;
        IWidget widget = (IWidget)hovered.getElement();
        if (widget instanceof IDraggable) {
            IDraggable iDraggable = (IDraggable)((Object)widget);
            draggable = new LocatedElement<IDraggable>(iDraggable, hovered.getTransformationMatrix());
        } else {
            if (!(widget instanceof ModularPanel)) return false;
            ModularPanel panel = (ModularPanel)widget;
            if (!panel.isDraggable()) return false;
            if (!panel.flex().hasFixedSize()) {
                throw new IllegalStateException("Panel must have a fixed size. It can't specify left AND right or top AND bottom!");
            }
            draggable = new LocatedElement<DraggablePanelWrapper>(new DraggablePanelWrapper(panel), TransformationMatrix.EMPTY);
        }
        if (!draggable.getElement().onDragStart(button)) return false;
        draggable.getElement().setMoving(true);
        this.draggable = draggable;
        this.lastButton = button;
        this.lastClickTime = Minecraft.getSystemTime();
        return true;
    }

    @ApiStatus.Internal
    public void drawDraggable() {
        if (this.hasDraggable()) {
            this.draggable.applyMatrix(this);
            this.draggable.getElement().drawMovingState(this, this.getPartialTicks());
            this.draggable.unapplyMatrix(this);
        }
    }

    @ApiStatus.Internal
    public void onFrameUpdate() {
        LocatedWidget locatedHovered;
        if (this.hasDraggable() && (this.lastDragX != this.getAbsMouseX() || this.lastDragY != this.getAbsMouseY())) {
            this.lastDragX = this.getAbsMouseX();
            this.lastDragY = this.getAbsMouseY();
            this.draggable.applyMatrix(this);
            this.draggable.getElement().onDrag(this.lastButton, this.lastClickTime);
            this.draggable.unapplyMatrix(this);
        }
        IWidget hovered = (locatedHovered = this.screen.getPanelManager().getTopWidgetLocated(false)) != null ? (IWidget)locatedHovered.getElement() : null;
        IWidget oldHovered = this.getHovered();
        if (oldHovered != hovered) {
            if (this.hovered != null && oldHovered != null) {
                if (this.hovered.getAdditionalHoverInfo() instanceof ResizeDragArea) {
                    ClientProxy.resetCursorIcon();
                }
                oldHovered.onMouseEndHover();
            }
            this.hovered = locatedHovered;
            this.timeHovered = 0;
            if (this.hovered != null) {
                IVanillaSlot vanillaSlot;
                Object object = locatedHovered.getAdditionalHoverInfo();
                if (object instanceof ResizeDragArea) {
                    ResizeDragArea dragArea = (ResizeDragArea)((Object)object);
                    ClientProxy.setCursorResizeIcon(dragArea);
                }
                hovered.onMouseStartHover();
                object = this.hovered;
                if (object instanceof IVanillaSlot && (vanillaSlot = (IVanillaSlot)object).handleAsVanillaSlot()) {
                    this.screen.getScreenWrapper().setHoveredSlot(vanillaSlot.getVanillaSlot());
                } else {
                    this.screen.getScreenWrapper().setHoveredSlot(null);
                }
            }
        } else if (this.hovered != null && locatedHovered != null && this.hovered.getAdditionalHoverInfo() != locatedHovered.getAdditionalHoverInfo()) {
            Object object = locatedHovered.getAdditionalHoverInfo();
            if (object instanceof ResizeDragArea) {
                ResizeDragArea dragArea = (ResizeDragArea)((Object)object);
                ClientProxy.setCursorResizeIcon(dragArea);
            } else {
                ClientProxy.resetCursorIcon();
            }
            this.hovered = locatedHovered;
        } else {
            ++this.timeHovered;
        }
    }

    public ITheme getTheme() {
        return this.screen.getCurrentTheme();
    }

    @Override
    public boolean isMuiContext() {
        return true;
    }

    @Override
    public ModularGuiContext getMuiContext() {
        return this;
    }

    public UISettings getUISettings() {
        if (this.settings == null) {
            throw new IllegalStateException("The screen is not yet initialised!");
        }
        return this.settings;
    }

    public RecipeViewerSettingsImpl getRecipeViewerSettings() {
        if (this.screen.isOverlay()) {
            throw new IllegalStateException("Overlays don't have recipe viewer settings!");
        }
        return (RecipeViewerSettingsImpl)this.getUISettings().getRecipeViewerSettings();
    }

    @ApiStatus.Internal
    public void setSettings(UISettings settings) {
        if (this.settings != null) {
            throw new IllegalStateException("Tried to set settings twice");
        }
        this.settings = settings;
    }

    private static class HoveredIterable
    implements Iterable<IGuiElement> {
        private final PanelManager panelManager;

        private HoveredIterable(PanelManager panelManager) {
            this.panelManager = panelManager;
        }

        @Override
        @NotNull
        public Iterator<IGuiElement> iterator() {
            return new Iterator<IGuiElement>(){
                private final Iterator<ModularPanel> panelIt;
                private Iterator<LocatedWidget> widgetIt;
                {
                    this.panelIt = panelManager.getOpenPanels().iterator();
                }

                @Override
                public boolean hasNext() {
                    if (this.widgetIt == null) {
                        if (!this.panelIt.hasNext()) {
                            return false;
                        }
                        this.widgetIt = this.panelIt.next().getHovering().iterator();
                    }
                    return this.widgetIt.hasNext();
                }

                @Override
                public IGuiElement next() {
                    if (this.widgetIt == null || !this.widgetIt.hasNext()) {
                        this.widgetIt = this.panelIt.next().getHovering().iterator();
                    }
                    return (IGuiElement)this.widgetIt.next().getElement();
                }
            };
        }
    }
}

