/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.test;

import com.cleanroommc.modularui.api.IGuiHolder;
import com.cleanroommc.modularui.api.drawable.IKey;
import com.cleanroommc.modularui.api.widget.IWidget;
import com.cleanroommc.modularui.factory.GuiData;
import com.cleanroommc.modularui.factory.SimpleGuiFactory;
import com.cleanroommc.modularui.screen.ModularPanel;
import com.cleanroommc.modularui.screen.UISettings;
import com.cleanroommc.modularui.utils.Alignment;
import com.cleanroommc.modularui.value.sync.IntSyncValue;
import com.cleanroommc.modularui.value.sync.PanelSyncManager;
import com.cleanroommc.modularui.value.sync.StringSyncValue;
import com.cleanroommc.modularui.widgets.TextWidget;
import com.cleanroommc.modularui.widgets.layout.Column;
import com.cleanroommc.modularui.widgets.layout.Flow;
import com.cleanroommc.modularui.widgets.layout.Row;
import com.cleanroommc.modularui.widgets.slot.ItemSlot;
import com.cleanroommc.modularui.widgets.slot.ModularSlot;
import com.cleanroommc.modularui.widgets.textfield.TextFieldWidget;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTException;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.EnumHand;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;

public class ItemEditorGui
implements IGuiHolder<GuiData> {
    private static final SimpleGuiFactory GUI = new SimpleGuiFactory("mui:item_editor", ItemEditorGui::new);
    private final ItemStackHandler stackHandler = new ItemStackHandler(1);

    private ItemStack getStack() {
        return this.stackHandler.getStackInSlot(0);
    }

    private void setStack(ItemStack stack) {
        this.stackHandler.setStackInSlot(0, stack);
    }

    @Override
    public ModularPanel buildUI(GuiData data, PanelSyncManager syncManager, UISettings settings) {
        ItemStack itemStack = data.getPlayer().getHeldItemMainhand();
        if (!itemStack.isEmpty()) {
            this.setStack(itemStack.copy());
            data.getPlayer().setHeldItem(EnumHand.MAIN_HAND, ItemStack.EMPTY);
            syncManager.addCloseListener(player -> {
                if (!this.getStack().isEmpty()) {
                    if (syncManager.getPlayer().getHeldItemMainhand().isEmpty()) {
                        player.setHeldItem(EnumHand.MAIN_HAND, this.getStack());
                    } else {
                        player.inventory.addItemStackToInventory(this.getStack());
                    }
                }
            });
        }
        ModularPanel panel = ModularPanel.defaultPanel("item_editor");
        return (ModularPanel)panel.bindPlayerInventory().child((IWidget)((Flow)((Flow)((Flow)((Flow)((Flow)new Column().crossAxisAlignment(Alignment.CrossAxis.START).sizeRel(1.0f)).margin(7)).child((IWidget)((TextWidget)IKey.str("Item Editor").asWidget().marginTop(7)).marginBottom(3))).child(new ItemSlot().slot(new ModularSlot((IItemHandler)this.stackHandler, 0)))).child((IWidget)((Flow)((Flow)((Flow)((Flow)((Flow)new Row().crossAxisAlignment(Alignment.CrossAxis.CENTER).height(16)).margin(0, 4)).child(IKey.str("Meta: ").asWidget())).child(((TextFieldWidget)new TextFieldWidget().size(50, 16)).value(new IntSyncValue(() -> this.getStack().getMetadata(), val -> {
            if (!syncManager.isClient()) {
                this.getStack().setItemDamage(val);
            }
        })).setNumbers(0, 32766))).child(IKey.str("  Amount: ").asWidget())).child(((TextFieldWidget)new TextFieldWidget().size(30, 16)).value(new IntSyncValue(() -> this.getStack().getCount(), value -> {
            if (!syncManager.isClient()) {
                this.getStack().setCount(value);
            }
        })).setNumbers(1, 127)))).child(((TextFieldWidget)((TextFieldWidget)new TextFieldWidget().height(20)).widthRel(1.0f)).value(new StringSyncValue(() -> this.getStack().hasTagCompound() ? this.getStack().getTagCompound().toString() : "", val -> {
            if (!syncManager.isClient()) {
                try {
                    this.getStack().setTagCompound(JsonToNBT.getTagFromJson((String)val));
                }
                catch (NBTException nBTException) {
                    // empty catch block
                }
            }
        })).setValidator(s -> s)));
    }

    public static class Command
    extends CommandBase {
        @NotNull
        public String getName() {
            return "itemEditor";
        }

        @NotNull
        public String getUsage(@NotNull ICommandSender sender) {
            return "/itemEditor";
        }

        public void execute(@NotNull MinecraftServer server, @NotNull ICommandSender sender, String @NotNull [] args) throws CommandException {
            EntityPlayerMP entityPlayerMP;
            if (!(sender instanceof EntityPlayerMP) || !(entityPlayerMP = (EntityPlayerMP)sender).isCreative()) {
                throw new CommandException("Player must be creative mode!", new Object[0]);
            }
            GUI.open((EntityPlayerMP)sender);
        }
    }
}

