/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.test;

import com.cleanroommc.modularui.api.IGuiHolder;
import com.cleanroommc.modularui.api.IPanelHandler;
import com.cleanroommc.modularui.api.drawable.IKey;
import com.cleanroommc.modularui.api.value.IIntValue;
import com.cleanroommc.modularui.api.widget.IWidget;
import com.cleanroommc.modularui.drawable.Circle;
import com.cleanroommc.modularui.drawable.GuiTextures;
import com.cleanroommc.modularui.drawable.ItemDrawable;
import com.cleanroommc.modularui.drawable.Rectangle;
import com.cleanroommc.modularui.drawable.text.AnimatedText;
import com.cleanroommc.modularui.factory.GuiData;
import com.cleanroommc.modularui.factory.PosGuiData;
import com.cleanroommc.modularui.network.NetworkUtils;
import com.cleanroommc.modularui.screen.ModularPanel;
import com.cleanroommc.modularui.screen.RichTooltip;
import com.cleanroommc.modularui.screen.UISettings;
import com.cleanroommc.modularui.screen.viewport.ModularGuiContext;
import com.cleanroommc.modularui.test.CraftingModularContainer;
import com.cleanroommc.modularui.theme.WidgetThemeEntry;
import com.cleanroommc.modularui.utils.Alignment;
import com.cleanroommc.modularui.utils.Color;
import com.cleanroommc.modularui.utils.Interpolation;
import com.cleanroommc.modularui.utils.fakeworld.ArraySchema;
import com.cleanroommc.modularui.utils.fakeworld.BlockHighlight;
import com.cleanroommc.modularui.utils.fakeworld.SchemaRenderer;
import com.cleanroommc.modularui.value.BoolValue;
import com.cleanroommc.modularui.value.IntValue;
import com.cleanroommc.modularui.value.StringValue;
import com.cleanroommc.modularui.value.sync.DynamicSyncHandler;
import com.cleanroommc.modularui.value.sync.GenericSyncValue;
import com.cleanroommc.modularui.value.sync.IntSyncValue;
import com.cleanroommc.modularui.value.sync.ItemSlotSH;
import com.cleanroommc.modularui.value.sync.PanelSyncManager;
import com.cleanroommc.modularui.value.sync.SyncHandler;
import com.cleanroommc.modularui.value.sync.SyncHandlers;
import com.cleanroommc.modularui.widget.EmptyWidget;
import com.cleanroommc.modularui.widget.ParentWidget;
import com.cleanroommc.modularui.widget.Widget;
import com.cleanroommc.modularui.widget.sizer.Flex;
import com.cleanroommc.modularui.widgets.ButtonWidget;
import com.cleanroommc.modularui.widgets.ColorPickerDialog;
import com.cleanroommc.modularui.widgets.CycleButtonWidget;
import com.cleanroommc.modularui.widgets.Dialog;
import com.cleanroommc.modularui.widgets.DynamicSyncedWidget;
import com.cleanroommc.modularui.widgets.Expandable;
import com.cleanroommc.modularui.widgets.ItemDisplayWidget;
import com.cleanroommc.modularui.widgets.ListWidget;
import com.cleanroommc.modularui.widgets.PageButton;
import com.cleanroommc.modularui.widgets.PagedWidget;
import com.cleanroommc.modularui.widgets.ProgressWidget;
import com.cleanroommc.modularui.widgets.SchemaWidget;
import com.cleanroommc.modularui.widgets.ScrollingTextWidget;
import com.cleanroommc.modularui.widgets.SliderWidget;
import com.cleanroommc.modularui.widgets.SlotGroupWidget;
import com.cleanroommc.modularui.widgets.SortButtons;
import com.cleanroommc.modularui.widgets.TextWidget;
import com.cleanroommc.modularui.widgets.ToggleButton;
import com.cleanroommc.modularui.widgets.layout.Column;
import com.cleanroommc.modularui.widgets.layout.Flow;
import com.cleanroommc.modularui.widgets.layout.Row;
import com.cleanroommc.modularui.widgets.slot.FluidSlot;
import com.cleanroommc.modularui.widgets.slot.ItemSlot;
import com.cleanroommc.modularui.widgets.slot.ModularCraftingSlot;
import com.cleanroommc.modularui.widgets.slot.ModularSlot;
import com.cleanroommc.modularui.widgets.slot.SlotGroup;
import com.cleanroommc.modularui.widgets.textfield.TextFieldWidget;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Collection;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;

public class TestTile
extends TileEntity
implements IGuiHolder<PosGuiData>,
ITickable {
    private static final Object2IntMap<Item> handlerSizeMap = new Object2IntOpenHashMap<Item>(){
        {
            this.put(Items.DIAMOND, 9);
            this.put(Items.EMERALD, 9);
            this.put(Items.GOLD_INGOT, 7);
            this.put(Items.IRON_INGOT, 6);
            this.put(Items.CLAY_BALL, 2);
            this.defaultReturnValue(3);
        }
    };
    private final FluidTank fluidTank = new FluidTank(10000);
    private final FluidTank fluidTankPhantom = new FluidTank(Integer.MAX_VALUE);
    private long time = 0L;
    private int val;
    private int val2 = 0;
    private String value = "";
    private double doubleValue = 1.0;
    private final int duration = 80;
    private int progress = 0;
    private int cycleState = 0;
    private ItemStack displayItem = new ItemStack(Items.DIAMOND);
    private final IItemHandlerModifiable inventory = new ItemStackHandler(2){

        public int getSlotLimit(int slot) {
            return slot == 0 ? Integer.MAX_VALUE : 64;
        }
    };
    private final ItemStackHandler bigInventory = new ItemStackHandler(9);
    private final ItemStackHandler mixerItems = new ItemStackHandler(4);
    private final ItemStackHandler smallInv = new ItemStackHandler(4);
    private final FluidTank mixerFluids1 = new FluidTank(16000);
    private final FluidTank mixerFluids2 = new FluidTank(16000);
    private final ItemStackHandler craftingInventory = new ItemStackHandler(10);
    private final ItemStackHandler storageInventory0 = new ItemStackHandler(1);
    private final Map<Item, ItemStackHandler> stackHandlerMap = new Object2ObjectOpenHashMap();
    private int num = 2;

    @Override
    public ModularPanel buildUI(PosGuiData guiData, PanelSyncManager syncManager, UISettings settings) {
        settings.customContainer(() -> new CraftingModularContainer(3, 3, (IItemHandlerModifiable)this.craftingInventory));
        syncManager.registerSlotGroup("item_inv", 3);
        syncManager.registerSlotGroup("mixer_items", 2);
        syncManager.syncValue("mixer_fluids", 0, SyncHandlers.fluidSlot((IFluidTank)this.mixerFluids1));
        syncManager.syncValue("mixer_fluids", 1, SyncHandlers.fluidSlot((IFluidTank)this.mixerFluids2));
        IntSyncValue cycleStateValue = new IntSyncValue(() -> this.cycleState, val -> {
            this.cycleState = val;
        });
        syncManager.syncValue("cycle_state", (SyncHandler)cycleStateValue);
        syncManager.syncValue("display_item", GenericSyncValue.forItem(() -> this.displayItem, null));
        syncManager.bindPlayerInventory(guiData.getPlayer());
        DynamicSyncHandler dynamicSyncHandler = new DynamicSyncHandler().widgetProvider((syncManager1, packet) -> {
            ItemStack itemStack = NetworkUtils.readItemStack(packet);
            if (itemStack.isEmpty()) {
                return new EmptyWidget();
            }
            Item item = itemStack.getItem();
            ItemStackHandler handler = this.stackHandlerMap.computeIfAbsent(item, k -> new ItemStackHandler(handlerSizeMap.getInt(k)));
            String name = item.getRegistryName().toString();
            Flow flow = Flow.row();
            for (int i = 0; i < handler.getSlots(); ++i) {
                int finalI = i;
                flow.child(new ItemSlot().syncHandler(syncManager1.getOrCreateSyncHandler(name, i, ItemSlotSH.class, () -> new ItemSlotSH(new ModularSlot((IItemHandler)handler, finalI)))));
            }
            return flow;
        });
        Rectangle colorPickerBackground = new Rectangle().setColor(Color.RED.main);
        ModularPanel panel = new ModularPanel("test_tile");
        IPanelHandler panelSyncHandler = syncManager.panel("other_panel", this::openSecondWindow, true);
        IPanelHandler colorPicker = IPanelHandler.simple(panel, (mainPanel, player) -> (ModularPanel)((ModularPanel)((ModularPanel)new ColorPickerDialog(colorPickerBackground::setColor, colorPickerBackground.getColor(), true).setDraggable(true).relative(panel)).top(0)).rightRel(1.0f), true);
        PagedWidget.Controller tabController = new PagedWidget.Controller();
        ((Flex)panel.flex().size(176, 220)).align(Alignment.Center);
        ((ModularPanel)((ModularPanel)panel.child((IWidget)((Flow)((Flow)((Flow)((Flow)((Flow)((Flow)((Flow)new Row().debugName("Tab row")).coverChildren()).topRel(0.0f, 4, 1.0f)).child(new PageButton(0, tabController).tab(GuiTextures.TAB_TOP, -1))).child(new PageButton(1, tabController).tab(GuiTextures.TAB_TOP, 0))).child(new PageButton(2, tabController).tab(GuiTextures.TAB_TOP, 0))).child(new PageButton(3, tabController).tab(GuiTextures.TAB_TOP, 0).overlay(new ItemDrawable((Block)Blocks.CHEST).asIcon()))).child(new PageButton(4, tabController).tab(GuiTextures.TAB_TOP, 0).overlay(new ItemDrawable(Items.ENDER_EYE).asIcon())))).child(((Expandable)((Expandable)((Expandable)((Expandable)((Expandable)new Expandable().debugName("expandable")).top(0)).leftRelOffset(1.0f, 1)).background(GuiTextures.MC_BACKGROUND)).excludeAreaInRecipeViewer()).stencilTransform((r, expanded) -> {
            r.width = Math.max(20, r.width - 5);
            r.height = Math.max(20, r.height - 5);
        }).animationDuration(500).interpolation(Interpolation.BOUNCE_OUT).collapsedView((IWidget)((Widget)new ItemDrawable(Blocks.CRAFTING_TABLE).asIcon().asWidget().size(20)).pos(0, 0)).expandedView((IWidget)((ParentWidget)((ParentWidget)((ParentWidget)new ParentWidget().debugName("crafting tab")).coverChildren()).child((IWidget)((Widget)new ItemDrawable(Blocks.CRAFTING_TABLE).asIcon().asWidget().size(20)).pos(0, 0))).child(((SlotGroupWidget)SlotGroupWidget.builder().row("III  D").row("III  O").row("III   ").key('I', i -> new ItemSlot().slot(new ModularSlot((IItemHandler)this.craftingInventory, i))).key('O', new ItemSlot().slot(new ModularCraftingSlot((IItemHandler)this.craftingInventory, 9))).key('D', ((ItemDisplayWidget)new ItemDisplayWidget().syncHandler("display_item")).displayAmount(true)).build().margin(5, 5, 20, 5)).debugName("crafting"))))).child((IWidget)((Flow)((Flow)((Flow)Flow.column().sizeRel(1.0f)).paddingBottom(7)).child((IWidget)((ParentWidget)((ParentWidget)new ParentWidget().expanded()).widthRel(1.0f)).child(((PagedWidget)((PagedWidget)((PagedWidget)((PagedWidget)((PagedWidget)((PagedWidget)((PagedWidget)new PagedWidget().debugName("root parent")).sizeRel(1.0f)).controller(tabController)).addPage((IWidget)((ParentWidget)((ParentWidget)((ParentWidget)new ParentWidget().debugName("page 1 parent")).sizeRel(1.0f, 1.0f)).padding(7, 0)).child((IWidget)((Flow)((Flow)((Flow)((Flow)((Flow)new Row().debugName("buttons, slots and more tests")).height(137)).coverChildrenWidth()).verticalCenter()).child((IWidget)((Flow)((Flow)((Flow)((Flow)((Flow)((Flow)((Flow)((Flow)new Column().debugName("buttons and slots test")).coverChildren()).marginRight(8)).crossAxisAlignment(Alignment.CrossAxis.CENTER).child(((ButtonWidget)new ButtonWidget().size(60, 18)).overlay(IKey.dynamic(() -> "Button " + this.val)))).child(((FluidSlot)new FluidSlot().margin(2)).syncHandler(SyncHandlers.fluidSlot((IFluidTank)this.fluidTank)))).child(((Widget)((ButtonWidget)((ButtonWidget)new ButtonWidget().size(60, 18)).tooltip(tooltip -> {
            tooltip.showUpTimer(10);
            tooltip.addLine(IKey.str("Test Line g"));
            tooltip.addLine(IKey.str("An image inside of a tooltip:"));
            tooltip.addLine(GuiTextures.MUI_LOGO.asIcon().size(50).alignment(Alignment.TopCenter));
            tooltip.addLine(IKey.str("And here a circle:"));
            ((RichTooltip)((RichTooltip)tooltip.addLine(new Circle().setColor(Color.RED.darker(2), Color.RED.brighter(2)).asIcon().size(20))).addLine(new ItemDrawable(new ItemStack(Items.DIAMOND)).asIcon())).pos(RichTooltip.Pos.LEFT);
        })).onMousePressed(mouseButton -> {
            panelSyncHandler.openPanel();
            return true;
        })).overlay(IKey.str("Button 2")))).child(((TextFieldWidget)((TextFieldWidget)((TextFieldWidget)new TextFieldWidget().size(60, 18)).setTextAlignment(Alignment.Center)).value(SyncHandlers.string(() -> this.value, val -> {
            this.value = val;
        })).margin(0, 2)).hintText("hint"))).child(((TextFieldWidget)((TextFieldWidget)new TextFieldWidget().size(60, 18)).paddingTop(1)).value(SyncHandlers.doubleNumber(() -> this.doubleValue, val -> {
            this.doubleValue = val;
        })).setNumbersDouble(Function.identity()).hintText("number"))).child((IWidget)((ScrollingTextWidget)new ScrollingTextWidget(IKey.str("Very very long test string")).widthRel(1.0f)).height(16)))).child((IWidget)((Flow)((Flow)((Flow)((Flow)((Flow)((Flow)new Column().debugName("button and slots test 2")).coverChildren()).crossAxisAlignment(Alignment.CrossAxis.CENTER).child(new ProgressWidget().progress(() -> (double)this.progress / (double)this.duration).texture(GuiTextures.PROGRESS_ARROW, 20))).child(new ProgressWidget().progress(() -> (double)this.progress / (double)this.duration).texture(GuiTextures.PROGRESS_CYCLE, 20).direction(ProgressWidget.Direction.CIRCULAR_CW))).child((IWidget)((Flow)((Flow)((Flow)((Flow)new Row().coverChildrenWidth()).height(18)).child(new ToggleButton().value(new BoolValue.Dynamic(() -> cycleStateValue.getIntValue() == 0, val -> cycleStateValue.setIntValue(0))).overlay(GuiTextures.CYCLE_BUTTON_DEMO.getSubArea(0.0f, 0.0f, 1.0f, 0.33333334f)))).child(new ToggleButton().value(new BoolValue.Dynamic(() -> cycleStateValue.getIntValue() == 1, val -> cycleStateValue.setIntValue(1))).overlay(GuiTextures.CYCLE_BUTTON_DEMO.getSubArea(0.0f, 0.33333334f, 1.0f, 0.6666667f)))).child(new ToggleButton().value(new BoolValue.Dynamic(() -> cycleStateValue.getIntValue() == 2, val -> cycleStateValue.setIntValue(2))).overlay(GuiTextures.CYCLE_BUTTON_DEMO.getSubArea(0.0f, 0.6666667f, 1.0f, 1.0f))))).child(new ItemSlot().slot(SyncHandlers.itemSlot(this.inventory, 0).ignoreMaxStackSize(true).singletonSlotGroup()))).child(((FluidSlot)((FluidSlot)new FluidSlot().margin(2)).width(30)).syncHandler(SyncHandlers.fluidSlot((IFluidTank)this.fluidTankPhantom).phantom(true))))))).addPage((IWidget)((Flow)((Flow)((Flow)((Flow)((Flow)((Flow)((Flow)new Column().debugName("Slots test page")).coverChildren()).padding(7)).alignX(0.5f)).mainAxisAlignment(Alignment.MainAxis.START).childPadding(2).child((IWidget)((SlotGroupWidget)SlotGroupWidget.builder().matrix("III", "III", "III").key('I', index -> {
            if (index == 4) {
                return new ItemSlot().slot(SyncHandlers.itemSlot((IItemHandlerModifiable)this.bigInventory, index).singletonSlotGroup(-100));
            }
            return new ItemSlot().slot(SyncHandlers.itemSlot((IItemHandlerModifiable)this.bigInventory, index).slotGroup("item_inv"));
        }).build().debugName("9 slot inv")).child((IWidget)((SortButtons)new SortButtons().slotGroup("item_inv").right(0)).top(-11)))).child(SlotGroupWidget.builder().row("FII").row("FII").key('F', index -> new FluidSlot().syncHandler("mixer_fluids", index)).key('I', index -> ItemSlot.create(index >= 2).slot(new ModularSlot((IItemHandler)this.mixerItems, index).slotGroup("mixer_items"))).build().debugName("mixer inv"))).child((IWidget)((Flow)((Flow)new Row().coverChildrenHeight()).child((IWidget)((CycleButtonWidget)((CycleButtonWidget)new CycleButtonWidget().size(14, 14)).stateCount(3).stateOverlay(GuiTextures.CYCLE_BUTTON_DEMO)).value((IIntValue)new IntSyncValue(() -> this.val2, val -> {
            this.val2 = val;
        })).margin(8, 0))).child((IWidget)IKey.str("Hello World").asWidget().height(18)))).child((IWidget)((SpecialButton)new SpecialButton(IKey.str("A very long string that looks cool when animated").withAnimation()).height(14)).widthRel(1.0f)))).addPage((IWidget)((ParentWidget)((ParentWidget)((ParentWidget)((ParentWidget)((ParentWidget)new ParentWidget().debugName("page 3 parent")).sizeRel(1.0f, 1.0f)).padding(7)).child(((SliderWidget)((SliderWidget)((SliderWidget)((SliderWidget)new SliderWidget().widthRel(1.0f)).bottom(50)).height(16)).top(7)).stopper(0.0, 10.0, 20.0, 30.0, 40.0, 50.0, 60.0, 70.0, 80.0, 90.0, 100.0).background(GuiTextures.SLOT_FLUID))).child(((ButtonWidget)((ButtonWidget)((ButtonWidget)((ButtonWidget)new ButtonWidget().debugName("color picker button")).top(25)).background(colorPickerBackground)).disableHoverBackground()).onMousePressed(mouseButton -> {
            colorPicker.openPanel();
            return true;
        }))).child((IWidget)((ListWidget)((ListWidget)((ListWidget)((ListWidget)((ListWidget)((ListWidget)((ListWidget)new ListWidget().debugName("test config list")).widthRel(1.0f)).top(50)).bottom(2)).child((IWidget)((Flow)((Flow)((Flow)((Flow)new Row().debugName("test config 1")).widthRel(1.0f)).coverChildrenHeight()).crossAxisAlignment(Alignment.CrossAxis.CENTER).childPadding(2).child((IWidget)((CycleButtonWidget)((CycleButtonWidget)new CycleButtonWidget().value((IIntValue)new BoolValue(false)).stateOverlay(GuiTextures.CHECK_BOX)).size(14, 14)).margin(8, 4))).child((IWidget)IKey.str("Boolean config").asWidget().height(14)))).child((IWidget)((Flow)((Flow)((Flow)((Flow)new Row().debugName("test config 2")).widthRel(1.0f)).height(14)).childPadding(2).child((IWidget)((TextFieldWidget)((TextFieldWidget)((TextFieldWidget)new TextFieldWidget().value(new IntValue.Dynamic(() -> this.num, val -> {
            this.num = val;
        })).setNumbers(1, Short.MAX_VALUE).setTextAlignment(Alignment.Center)).background(new Rectangle().setColor(-5131855))).setTextColor(-12566464)).size(20, 14))).child((IWidget)IKey.str("Number config").asWidget().height(14)))).child((IWidget)((TextWidget)((TextWidget)((TextWidget)((TextWidget)IKey.str("Config title").asWidget()).color(-12566464)).alignment(Alignment.CenterLeft).left(5)).height(14)).tooltip(tooltip -> tooltip.showUpTimer(10).addLine(IKey.str("Config title tooltip"))))).child((IWidget)((Flow)((Flow)((Flow)((Flow)new Row().debugName("test config 3")).widthRel(1.0f)).height(14)).childPadding(2).child((IWidget)((CycleButtonWidget)new CycleButtonWidget().value((IIntValue)new BoolValue(false)).stateOverlay(GuiTextures.CHECK_BOX)).size(14, 14))).child((IWidget)IKey.str("Boolean config 3").asWidget().height(14)))))).addPage((IWidget)((ParentWidget)((ParentWidget)new ParentWidget().debugName("page 4 storage")).sizeRel(1.0f)).child((IWidget)((Flow)((Flow)new Column().padding(7)).child(new ItemSlot().slot(new ModularSlot((IItemHandler)this.storageInventory0, 0).changeListener((newItem, onlyAmountChanged, client, init) -> {
            if (client && !onlyAmountChanged) {
                dynamicSyncHandler.notifyUpdate(packet -> NetworkUtils.writeItemStack(packet, newItem));
            }
        })))).child(((DynamicSyncedWidget)new DynamicSyncedWidget().widthRel(1.0f)).syncHandler(dynamicSyncHandler))))).addPage(this.createSchemaPage(guiData))))).child(SlotGroupWidget.playerInventory(false)));
        return panel;
    }

    private IWidget createSchemaPage(GuiData data) {
        ParentWidget page = new ParentWidget();
        page.debugName("page 5 schema");
        page.sizeRel(1.0f);
        page.child(IKey.str("schema").asWidget());
        if (this.world.isRemote) {
            page.child((IWidget)((SchemaWidget)new SchemaWidget(new SchemaRenderer(ArraySchema.of((Entity)data.getPlayer(), 5)).highlightRenderer(new BlockHighlight(Color.withAlpha(Color.GREEN.brighter(1), 0.9f), 0.03125f))).pos(20, 20)).size(100, 100));
        }
        return page;
    }

    public ModularPanel openSecondWindow(PanelSyncManager syncManager, IPanelHandler syncHandler) {
        ModularPanel panel = (ModularPanel)new Dialog("second_window", null).setDisablePanelsBelow(false).setCloseOnOutOfBoundsClick(false).setDraggable(true).size(100, 100);
        SlotGroup slotGroup = new SlotGroup("small_inv", 2);
        IntSyncValue timeSync = new IntSyncValue(() -> (int)System.currentTimeMillis());
        syncManager.syncValue(123456, (SyncHandler)timeSync);
        syncManager.registerSlotGroup(slotGroup);
        AtomicInteger number = new AtomicInteger(0);
        syncManager.syncValue("int_value", (SyncHandler)new IntSyncValue(number::get, number::set));
        IPanelHandler panelSyncHandler = syncManager.panel("other_panel_2", (syncManager1, syncHandler1) -> this.openThirdWindow(syncManager1, syncHandler1, number), true);
        ((ModularPanel)((ModularPanel)((ModularPanel)((ModularPanel)panel.child(ButtonWidget.panelCloseButton())).child(((ButtonWidget)((ButtonWidget)((ButtonWidget)((ButtonWidget)new ButtonWidget().size(10)).top(14)).right(4)).overlay(IKey.str("3"))).onMousePressed(mouseButton -> {
            panelSyncHandler.openPanel();
            return true;
        }))).child((IWidget)IKey.str("2nd Panel").asWidget().pos(5, 5))).child((IWidget)SlotGroupWidget.builder().row("II").row("II").key('I', i -> new ItemSlot().slot(new ModularSlot((IItemHandler)this.smallInv, i).slotGroup(slotGroup))).build().center())).child(((ButtonWidget)((ButtonWidget)((ButtonWidget)new ButtonWidget().bottom(5)).right(5)).tooltip(richTooltip -> ((RichTooltip)richTooltip.textColor(Color.RED.main)).add("WARNING! Very Dangerous"))).onMousePressed(mouseButton -> {
            if (!panelSyncHandler.isPanelOpen()) {
                panelSyncHandler.deleteCachedPanel();
                number.incrementAndGet();
            }
            return true;
        }));
        return panel;
    }

    public ModularPanel openThirdWindow(PanelSyncManager syncManager, IPanelHandler syncHandler, AtomicInteger integer) {
        ModularPanel panel = (ModularPanel)new Dialog("third_window", null).setDisablePanelsBelow(false).setCloseOnOutOfBoundsClick(false).setDraggable(true).size(50, 50);
        ((ModularPanel)panel.child(ButtonWidget.panelCloseButton())).child((IWidget)IKey.str("3rd Panel: " + integer.get()).asWidget().pos(5, 17));
        return panel;
    }

    public void buildDialog(Dialog<String> dialog) {
        AtomicReference<String> value = new AtomicReference<String>("");
        dialog.setDraggable(true);
        ((ModularPanel)dialog.child(((TextFieldWidget)new TextFieldWidget().flex(flex -> ((Flex)flex.size(100, 20)).align(Alignment.Center))).value(new StringValue.Dynamic(value::get, value::set)))).child(((ButtonWidget)((ButtonWidget)new ButtonWidget().flex(flex -> ((Flex)((Flex)flex.size(8, 8)).top(5)).right(5))).overlay(IKey.str("x"))).onMousePressed(mouseButton -> {
            dialog.closeWith((String)value.get());
            return true;
        }));
    }

    public void update() {
        if (this.world.isRemote) {
            if (this.time++ % 20L == 0L) {
                ++this.val;
            }
        } else if (this.time++ % 20L == 0L) {
            if (++this.val2 == 3) {
                this.val2 = 0;
            }
            Collection vals = ForgeRegistries.ITEMS.getValuesCollection();
            Item item = vals.stream().skip(new Random().nextInt(vals.size())).findFirst().orElse(Items.DIAMOND);
            this.displayItem = new ItemStack(item, 26735987);
        }
        if (++this.progress == this.duration) {
            this.progress = 0;
        }
    }

    @NotNull
    public NBTTagCompound writeToNBT(@NotNull NBTTagCompound compound) {
        compound = super.writeToNBT(compound);
        compound.setTag("item_inv", (NBTBase)this.bigInventory.serializeNBT());
        return compound;
    }

    public void readFromNBT(@NotNull NBTTagCompound compound) {
        super.readFromNBT(compound);
        this.bigInventory.deserializeNBT(compound.getCompoundTag("item_inv"));
    }

    private static class SpecialButton
    extends ButtonWidget<SpecialButton> {
        private final AnimatedText animatedKey;

        private SpecialButton(AnimatedText animatedKey) {
            this.animatedKey = animatedKey.stopAnimation().forward(true);
            this.animatedKey.reset();
        }

        @Override
        public void draw(ModularGuiContext context, WidgetThemeEntry<?> widgetTheme) {
            this.animatedKey.draw(context, 0, 0, this.getArea().w(), this.getArea().h(), this.getActiveWidgetTheme(widgetTheme, this.isHovering()));
        }

        @Override
        public void onMouseStartHover() {
            this.animatedKey.startAnimation().forward(true);
        }

        @Override
        public void onMouseEndHover() {
            this.animatedKey.forward(false);
        }
    }
}

