/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.theme;

import com.cleanroommc.modularui.theme.WidgetTheme;
import com.cleanroommc.modularui.theme.WidgetThemeKey;

public class WidgetThemeEntry<T extends WidgetTheme> {
    private final WidgetThemeKey<T> key;
    private final T theme;
    private final T hoverTheme;

    public WidgetThemeEntry(WidgetThemeKey<T> key, T theme) {
        this(key, theme, theme);
    }

    public WidgetThemeEntry(WidgetThemeKey<T> key, T theme, T hoverTheme) {
        this.key = key;
        this.theme = theme;
        this.hoverTheme = hoverTheme;
    }

    public WidgetThemeKey<T> getKey() {
        return this.key;
    }

    public T getTheme() {
        return this.theme;
    }

    public T getHoverTheme() {
        return this.hoverTheme;
    }

    public T getTheme(boolean hover) {
        return hover ? this.hoverTheme : this.theme;
    }

    public <F extends WidgetTheme> WidgetThemeEntry<F> expectType(Class<F> expectedType) {
        if (this.key.isOfType(expectedType)) {
            return this;
        }
        throw new IllegalStateException(String.format("Got widget theme with invalid type. Got type '%s', but expected type '%s'!", this.key.getWidgetThemeType().getSimpleName(), expectedType.getSimpleName()));
    }
}

