/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.utils;

import com.cleanroommc.modularui.utils.ObjectList;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.IResource;
import net.minecraft.util.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class AssetHelper {
    @Nullable
    public static IResource findAsset(ResourceLocation resourceLocation) {
        try {
            return Minecraft.getMinecraft().getResourceManager().getResource(resourceLocation);
        }
        catch (IOException e) {
            return null;
        }
    }

    public static List<IResource> findAssets(String domain, String file) {
        try {
            return Minecraft.getMinecraft().getResourceManager().getAllResources(new ResourceLocation(domain, file));
        }
        catch (IOException e) {
            return Collections.emptyList();
        }
    }

    public static List<IResource> findAssets(String file) {
        ObjectList.ObjectArrayList assets = ObjectList.create();
        for (String domain : Minecraft.getMinecraft().getResourceManager().getResourceDomains()) {
            assets.addAll(AssetHelper.findAssets(domain, file));
        }
        return assets;
    }
}

