/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.value.sync;

import com.cleanroommc.modularui.api.IPanelHandler;
import com.cleanroommc.modularui.api.widget.ISynced;
import com.cleanroommc.modularui.screen.ModularPanel;
import com.cleanroommc.modularui.screen.ModularScreen;
import com.cleanroommc.modularui.value.sync.ItemSlotSH;
import com.cleanroommc.modularui.value.sync.PanelSyncManager;
import com.cleanroommc.modularui.value.sync.SyncHandler;
import com.cleanroommc.modularui.widget.WidgetTree;
import java.io.IOException;
import java.util.Objects;
import net.minecraft.network.PacketBuffer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public final class PanelSyncHandler
extends SyncHandler
implements IPanelHandler {
    private final IPanelBuilder panelBuilder;
    private final boolean subPanel;
    private String panelName;
    private ModularPanel openedPanel;
    private PanelSyncManager syncManager;
    private boolean open = false;

    PanelSyncHandler(IPanelBuilder panelBuilder, boolean subPanel) {
        this.panelBuilder = panelBuilder;
        this.subPanel = subPanel;
    }

    public ModularPanel createUI(PanelSyncManager syncManager) {
        return this.panelBuilder.buildUI(syncManager, this);
    }

    @Override
    public void openPanel() {
        this.openPanel(true);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void openPanel(boolean syncToServer) {
        if (this.isPanelOpen()) {
            return;
        }
        boolean client = this.getSyncManager().isClient();
        if (syncToServer && client) {
            this.syncToServer(0);
            return;
        }
        if (this.syncManager != null && this.syncManager.getModularSyncManager() != this.getSyncManager().getModularSyncManager()) {
            throw new IllegalStateException("Can't reopen synced panel in another screen!");
        }
        if (this.syncManager == null) {
            this.syncManager = new PanelSyncManager(client);
            this.openedPanel = Objects.requireNonNull(this.createUI(this.syncManager));
            this.panelName = this.openedPanel.getName();
            this.openedPanel.setSyncHandler(this);
            WidgetTree.collectSyncValues(this.syncManager, this.openedPanel, false);
            if (!client) {
                this.openedPanel = null;
            }
        }
        if (client) {
            ModularScreen screen = this.getSyncManager().getContainer().getScreen();
            if (screen.isPanelOpen(this.openedPanel.getName())) {
                this.closePanelInternal();
                return;
            }
            this.openInModularSyncManager();
            screen.getPanelManager().openPanel(this.openedPanel, this);
        } else {
            this.openInModularSyncManager();
        }
        this.open = true;
    }

    private void openInModularSyncManager() {
        this.getSyncManager().getModularSyncManager().open(this.panelName, this.syncManager);
    }

    @Override
    public void closePanel() {
        if (this.getSyncManager().isClient()) {
            if (this.openedPanel != null) {
                this.openedPanel.closeIfOpen();
            }
        } else {
            this.syncToClient(2);
        }
    }

    @Override
    public void closeSubPanels() {
        this.syncManager.closeSubPanels();
    }

    @Override
    @ApiStatus.Internal
    public void closePanelInternal() {
        this.getSyncManager().getModularSyncManager().close(this.panelName);
        this.open = false;
        if (this.getSyncManager().isClient()) {
            this.syncToServer(2);
        }
    }

    @Override
    public void deleteCachedPanel() {
        if (this.openedPanel == null || this.isPanelOpen()) {
            return;
        }
        boolean canDispose = WidgetTree.foreachChild(this.openedPanel, iWidget -> {
            ISynced synced;
            if (!iWidget.isValid()) {
                return false;
            }
            if (iWidget instanceof ISynced && (synced = (ISynced)((Object)iWidget)).isSynced()) {
                return !(synced.getSyncHandler() instanceof ItemSlotSH);
            }
            return true;
        }, false);
        if (!canDispose) {
            throw new UnsupportedOperationException("Can't delete cached panel if it's still open or has ItemSlot Sync Handlers!");
        }
        this.disposePanel();
        this.sync(3);
    }

    private void disposePanel() {
        this.panelName = null;
        this.syncManager = null;
        this.openedPanel = null;
    }

    @Override
    public boolean isSubPanel() {
        return this.subPanel;
    }

    @Override
    public boolean isPanelOpen() {
        return this.open;
    }

    @Override
    public void readOnClient(int i, PacketBuffer packetBuffer) throws IOException {
        if (i == 1) {
            this.openPanel(false);
        } else if (i == 2) {
            this.closePanel();
        } else if (i == 3) {
            this.disposePanel();
        }
    }

    @Override
    public void readOnServer(int i, PacketBuffer packetBuffer) throws IOException {
        if (i == 0) {
            this.openPanel(false);
            this.syncToClient(1);
        } else if (i == 2) {
            this.closePanelInternal();
        } else if (i == 3) {
            this.disposePanel();
        }
    }

    public static interface IPanelBuilder {
        @NotNull
        public ModularPanel buildUI(@NotNull PanelSyncManager var1, @NotNull IPanelHandler var2);
    }
}

