/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.drawable;

import com.cleanroommc.modularui.drawable.ColorType;
import com.cleanroommc.modularui.drawable.GuiDraw;
import com.cleanroommc.modularui.drawable.UITexture;
import com.google.gson.JsonObject;
import net.minecraft.util.ResourceLocation;

public class TiledUITexture
extends UITexture {
    private final int imageWidth;
    private final int imageHeight;

    TiledUITexture(ResourceLocation location, float u0, float v0, float u1, float v1, int imageWidth, int imageHeight, ColorType colorType) {
        super(location, u0, v0, u1, v1, colorType);
        this.imageWidth = imageWidth;
        this.imageHeight = imageHeight;
    }

    @Override
    public void draw(float x, float y, float width, float height) {
        if (width == (float)this.imageWidth && height == (float)this.imageHeight) {
            super.draw(x, y, width, height);
            return;
        }
        GuiDraw.drawTiledTexture(this.location, x, y, width, height, this.u0, this.v0, this.u1, this.v1, this.imageWidth, this.imageHeight, 0.0f);
    }

    @Override
    public boolean saveToJson(JsonObject json) {
        super.saveToJson(json);
        if (json.entrySet().size() > 1) {
            json.addProperty("tiled", Boolean.valueOf(true));
        }
        return true;
    }
}

