/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.screen;

import com.cleanroommc.modularui.GuiErrorHandler;
import com.cleanroommc.modularui.ModularUI;
import com.cleanroommc.modularui.ModularUIConfig;
import com.cleanroommc.modularui.api.IMuiScreen;
import com.cleanroommc.modularui.api.MCHelper;
import com.cleanroommc.modularui.api.UpOrDown;
import com.cleanroommc.modularui.api.widget.IGuiElement;
import com.cleanroommc.modularui.api.widget.IVanillaSlot;
import com.cleanroommc.modularui.api.widget.IWidget;
import com.cleanroommc.modularui.core.mixins.early.minecraft.GuiAccessor;
import com.cleanroommc.modularui.core.mixins.early.minecraft.GuiContainerAccessor;
import com.cleanroommc.modularui.core.mixins.early.minecraft.GuiScreenAccessor;
import com.cleanroommc.modularui.drawable.GuiDraw;
import com.cleanroommc.modularui.drawable.Stencil;
import com.cleanroommc.modularui.overlay.OverlayManager;
import com.cleanroommc.modularui.overlay.OverlayStack;
import com.cleanroommc.modularui.screen.IClickableGuiContainer;
import com.cleanroommc.modularui.screen.ModularScreen;
import com.cleanroommc.modularui.screen.NEAAnimationHandler;
import com.cleanroommc.modularui.screen.viewport.GuiContext;
import com.cleanroommc.modularui.screen.viewport.LocatedWidget;
import com.cleanroommc.modularui.screen.viewport.ModularGuiContext;
import com.cleanroommc.modularui.utils.Color;
import com.cleanroommc.modularui.utils.FpsCounter;
import com.cleanroommc.modularui.utils.MathUtils;
import com.cleanroommc.modularui.utils.Platform;
import com.cleanroommc.modularui.widget.sizer.Area;
import com.cleanroommc.modularui.widgets.RichTextWidget;
import com.cleanroommc.modularui.widgets.slot.ItemSlot;
import com.cleanroommc.modularui.widgets.slot.ModularSlot;
import com.cleanroommc.modularui.widgets.slot.SlotGroup;
import com.cleanroommc.neverenoughanimations.animations.OpeningAnimation;
import java.awt.Rectangle;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiLabel;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.client.event.GuiContainerEvent;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
@ApiStatus.Internal
public class ClientScreenHandler {
    private static final GuiContext defaultContext = new GuiContext();
    private static ModularScreen currentScreen = null;
    private static Character lastChar = null;
    private static final FpsCounter fpsCounter = new FpsCounter();
    private static long ticks = 0L;
    private static IMuiScreen lastMui;
    public static boolean guiIsClosing;

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onGuiOpen(GuiOpenEvent event) {
        GuiScreen newGui = event.getGui();
        guiIsClosing = newGui == null;
        defaultContext.reset();
        if (lastMui != null && newGui == null) {
            if (lastMui.getScreen().getPanelManager().isOpen()) {
                lastMui.getScreen().getPanelManager().closeAll();
            }
            lastMui.getScreen().getPanelManager().dispose();
            lastMui = null;
        } else if (newGui instanceof IMuiScreen) {
            IMuiScreen screenWrapper = (IMuiScreen)newGui;
            if (lastMui == null) {
                lastMui = screenWrapper;
            } else if (lastMui == newGui) {
                lastMui.getScreen().getPanelManager().reopen();
            } else {
                if (lastMui.getScreen().getPanelManager().isOpen()) {
                    lastMui.getScreen().getPanelManager().closeAll();
                }
                lastMui.getScreen().getPanelManager().dispose();
                lastMui = screenWrapper;
            }
        }
        if (newGui instanceof IMuiScreen) {
            IMuiScreen muiScreen = (IMuiScreen)newGui;
            Objects.requireNonNull(muiScreen.getScreen(), "ModularScreen must not be null!");
            if (currentScreen != muiScreen.getScreen()) {
                if (ClientScreenHandler.hasScreen()) {
                    currentScreen.onCloseParent();
                    currentScreen = null;
                    lastChar = null;
                }
                currentScreen = muiScreen.getScreen();
                currentScreen.getContext().setParentScreen(Minecraft.func_71410_x().field_71462_r);
                fpsCounter.reset();
            }
        } else if (ClientScreenHandler.hasScreen() && ClientScreenHandler.getMCScreen() != null && newGui != ClientScreenHandler.getMCScreen()) {
            currentScreen.onCloseParent();
            currentScreen = null;
            lastChar = null;
        }
        GuiErrorHandler.INSTANCE.clear();
        OverlayManager.onGuiOpen(event);
    }

    @SubscribeEvent
    public void onGuiInit(GuiScreenEvent.InitGuiEvent.Post event) {
        defaultContext.updateScreenArea(event.getGui().field_146294_l, event.getGui().field_146295_m);
        if (ClientScreenHandler.checkGui(event.getGui())) {
            currentScreen.onResize(event.getGui().field_146294_l, event.getGui().field_146295_m);
        }
        OverlayStack.foreach(ms -> ms.onResize(event.getGui().field_146294_l, event.getGui().field_146295_m), false);
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onGuiInputHigh(GuiScreenEvent.KeyboardInputEvent.Pre event) throws IOException {
        defaultContext.updateEventState();
        ClientScreenHandler.inputEvent(event, InputPhase.EARLY);
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onGuiInputLow(GuiScreenEvent.KeyboardInputEvent.Pre event) throws IOException {
        ClientScreenHandler.inputEvent(event, InputPhase.LATE);
    }

    private static void inputEvent(GuiScreenEvent.KeyboardInputEvent.Pre event, InputPhase phase) throws IOException {
        if (ClientScreenHandler.checkGui(event.getGui())) {
            currentScreen.getContext().updateEventState();
        }
        if (ClientScreenHandler.handleKeyboardInput(currentScreen, event.getGui(), phase)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onGuiInputHigh(GuiScreenEvent.MouseInputEvent.Pre event) throws IOException {
        defaultContext.updateEventState();
        if (ClientScreenHandler.checkGui(event.getGui())) {
            currentScreen.getContext().updateEventState();
        }
        if (ClientScreenHandler.handleMouseInput(Mouse.getEventButton(), currentScreen, event.getGui())) {
            Platform.unFocusRecipeViewer();
            event.setCanceled(true);
            return;
        }
        int w = Mouse.getEventDWheel();
        if (w == 0) {
            return;
        }
        UpOrDown upOrDown = w > 0 ? UpOrDown.UP : UpOrDown.DOWN;
        ClientScreenHandler.checkGui(event.getGui());
        if (ClientScreenHandler.doAction(currentScreen, ms -> ms.onMouseScroll(upOrDown, Math.abs(w)))) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onGuiDraw(GuiScreenEvent.DrawScreenEvent.Pre event) {
        int mx = event.getMouseX();
        int my = event.getMouseY();
        float pt = event.getRenderPartialTicks();
        defaultContext.updateState(mx, my, pt);
        defaultContext.reset();
        if (ClientScreenHandler.checkGui(event.getGui())) {
            currentScreen.getContext().updateState(mx, my, pt);
            ClientScreenHandler.drawScreen(currentScreen, currentScreen.getScreenWrapper().getGuiScreen(), mx, my, pt);
            event.setCanceled(true);
        }
        Platform.setupDrawTex();
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onGuiDraw(GuiScreenEvent.DrawScreenEvent.Post event) {
        OverlayStack.draw(event.getMouseX(), event.getMouseY(), event.getRenderPartialTicks());
        Platform.setupDrawTex();
    }

    @SubscribeEvent
    public void onTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            OverlayStack.onTick();
            defaultContext.tick();
            if (ClientScreenHandler.checkGui()) {
                currentScreen.onUpdate();
            }
            ++ticks;
        }
    }

    @SubscribeEvent
    public void preDraw(TickEvent.RenderTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            GL11.glEnable((int)2960);
        }
        Stencil.reset();
    }

    public static long getTicks() {
        return ticks;
    }

    public static void onFrameUpdate() {
        OverlayStack.foreach(ModularScreen::onFrameUpdate, true);
        if (currentScreen != null) {
            currentScreen.onFrameUpdate();
        }
    }

    private static boolean doAction(@Nullable ModularScreen muiScreen, Predicate<ModularScreen> action) {
        return OverlayStack.interact(action, true) || muiScreen != null && action.test(muiScreen);
    }

    private static boolean handleMouseInput(int button, @Nullable ModularScreen muiScreen, GuiScreen mcScreen) throws IOException {
        GameSettings gameSettings = Minecraft.func_71410_x().field_71474_y;
        GuiScreenAccessor acc = (GuiScreenAccessor)mcScreen;
        if (Mouse.getEventButtonState()) {
            int val;
            if (gameSettings.field_85185_A && (val = acc.getTouchValue()) > 0) {
                acc.setTouchValue(val + 1);
                return true;
            }
            acc.setEventButton(button);
            acc.setLastMouseEvent(Minecraft.func_71386_F());
            if (muiScreen != null && muiScreen.onMouseInputPre(button, true)) {
                return true;
            }
            return ClientScreenHandler.doAction(muiScreen, ms -> ms.onMousePressed(button));
        }
        if (button != -1) {
            int val;
            if (gameSettings.field_85185_A && (val = acc.getTouchValue()) - 1 > 0) {
                acc.setTouchValue(val - 1);
                return true;
            }
            acc.setEventButton(-1);
            if (muiScreen != null && muiScreen.onMouseInputPre(button, false)) {
                return true;
            }
            return ClientScreenHandler.doAction(muiScreen, ms -> ms.onMouseRelease(button));
        }
        if (acc.getEventButton() != -1 && acc.getLastMouseEvent() > 0L) {
            long l = Minecraft.func_71386_F() - acc.getLastMouseEvent();
            return ClientScreenHandler.doAction(muiScreen, ms -> ms.onMouseDrag(acc.getEventButton(), l));
        }
        return false;
    }

    private static boolean handleKeyboardInput(@Nullable ModularScreen muiScreen, GuiScreen mcScreen, InputPhase inputPhase) throws IOException {
        char c0 = Keyboard.getEventCharacter();
        int key = Keyboard.getEventKey();
        boolean state = Keyboard.getEventKeyState();
        if (state) {
            lastChar = Character.valueOf(c0);
            return inputPhase.isEarly() ? ClientScreenHandler.doAction(muiScreen, ms -> ms.onKeyPressed(c0, key)) : ClientScreenHandler.keyTyped(mcScreen, c0, key);
        }
        if (lastChar == null) {
            return false;
        }
        if (inputPhase.isEarly() && ClientScreenHandler.doAction(muiScreen, ms -> ms.onKeyRelease(lastChar.charValue(), key))) {
            return true;
        }
        if (inputPhase.isLate() && key == 0 && c0 >= ' ') {
            return ClientScreenHandler.keyTyped(mcScreen, c0, key);
        }
        return false;
    }

    private static boolean keyTyped(GuiScreen screen, char typedChar, int keyCode) throws IOException {
        if (currentScreen == null) {
            return false;
        }
        if (keyCode == 46 && GuiScreen.func_146271_m() && GuiScreen.func_146272_n() && GuiScreen.func_175283_s()) {
            ModularUIConfig.guiDebugMode = !ModularUIConfig.guiDebugMode;
            return true;
        }
        if (keyCode == 1 || Minecraft.func_71410_x().field_71474_y.field_151445_Q.isActiveAndMatches(keyCode)) {
            if (currentScreen.getContext().hasDraggable()) {
                currentScreen.getContext().dropDraggable();
            } else {
                currentScreen.getPanelManager().closeTopPanel();
            }
            return true;
        }
        return false;
    }

    public static void dragSlot(long timeSinceLastClick) {
        GuiScreen guiScreen;
        if (ClientScreenHandler.hasScreen() && (guiScreen = ClientScreenHandler.getMCScreen()) instanceof GuiScreenAccessor) {
            GuiScreenAccessor container = (GuiScreenAccessor)guiScreen;
            ModularGuiContext ctx = currentScreen.getContext();
            container.invokeMouseClickMove(ctx.getAbsMouseX(), ctx.getAbsMouseY(), ctx.getMouseButton(), timeSinceLastClick);
        }
    }

    public static void clickSlot(ModularScreen ms, Slot slot) {
        GuiScreen screen = ms.getScreenWrapper().getGuiScreen();
        if (screen instanceof GuiScreenAccessor) {
            GuiScreenAccessor acc = (GuiScreenAccessor)screen;
            if (screen instanceof IClickableGuiContainer) {
                IClickableGuiContainer clickableGuiContainer = (IClickableGuiContainer)screen;
                if (ClientScreenHandler.checkGui(screen)) {
                    ModularGuiContext ctx = ms.getContext();
                    List<GuiButton> buttonList = acc.getButtonList();
                    try {
                        acc.setButtonList(Collections.emptyList());
                        clickableGuiContainer.modularUI$setClickedSlot(slot);
                        acc.invokeMouseClicked(ctx.getAbsMouseX(), ctx.getAbsMouseY(), ctx.getMouseButton());
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                    finally {
                        clickableGuiContainer.modularUI$setClickedSlot(null);
                        acc.setButtonList(buttonList);
                    }
                }
            }
        }
    }

    public static void releaseSlot() {
        GuiScreen guiScreen;
        if (ClientScreenHandler.hasScreen() && (guiScreen = ClientScreenHandler.getMCScreen()) instanceof GuiScreenAccessor) {
            GuiScreenAccessor screen = (GuiScreenAccessor)guiScreen;
            ModularGuiContext ctx = currentScreen.getContext();
            screen.invokeMouseReleased(ctx.getAbsMouseX(), ctx.getAbsMouseY(), ctx.getMouseButton());
        }
    }

    public static boolean shouldDrawWorldBackground() {
        return ModularUI.Mods.BLUR.isLoaded() || Minecraft.func_71410_x().field_71441_e == null;
    }

    public static void drawDarkBackground(GuiScreen screen, int tint) {
        if (ClientScreenHandler.hasScreen()) {
            float alpha = ModularUI.Mods.NEA.isLoaded() ? OpeningAnimation.getValue((GuiScreen)screen) : 1.0f;
            int color = 0x101010;
            int start = (int)(192.0f * alpha);
            int end = (int)(208.0f * alpha);
            start = Color.withAlpha(color, start);
            end = Color.withAlpha(color, end);
            GuiDraw.drawVerticalGradientRect(0.0f, 0.0f, screen.field_146294_l, screen.field_146295_m, start, end);
        }
    }

    public static void drawScreen(ModularScreen muiScreen, GuiScreen mcScreen, int mouseX, int mouseY, float partialTicks) {
        if (mcScreen instanceof GuiContainer) {
            GuiContainer container = (GuiContainer)mcScreen;
            ClientScreenHandler.drawContainer(muiScreen, container, mouseX, mouseY, partialTicks);
        } else {
            ClientScreenHandler.drawScreenInternal(muiScreen, mcScreen, mouseX, mouseY, partialTicks);
        }
    }

    public static void drawScreenInternal(ModularScreen muiScreen, GuiScreen mcScreen, int mouseX, int mouseY, float partialTicks) {
        GlStateManager.func_179094_E();
        Stencil.reset();
        Stencil.apply(muiScreen.getScreenArea(), null);
        Platform.setupDrawTex();
        GlStateManager.func_179145_e();
        GlStateManager.func_179126_j();
        GlStateManager.func_179091_B();
        RenderHelper.func_74519_b();
        ClientScreenHandler.handleAnimationScale(mcScreen);
        muiScreen.drawScreen();
        GlStateManager.func_179140_f();
        GlStateManager.func_179097_i();
        ClientScreenHandler.drawVanillaElements(mcScreen, mouseX, mouseY, partialTicks);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179091_B();
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
        RenderHelper.func_74518_a();
        muiScreen.drawForeground();
        GlStateManager.func_179145_e();
        GlStateManager.func_179126_j();
        GlStateManager.func_179091_B();
        RenderHelper.func_74519_b();
        Stencil.remove();
        GlStateManager.func_179121_F();
    }

    public static void drawContainer(ModularScreen muiScreen, GuiContainer mcScreen, int mouseX, int mouseY, float partialTicks) {
        IVanillaSlot vanillaSlot;
        GuiContainerAccessor acc = (GuiContainerAccessor)mcScreen;
        Stencil.reset();
        Stencil.apply(muiScreen.getScreenArea(), null);
        Platform.setupDrawTex();
        mcScreen.func_146276_q_();
        int x = mcScreen.getGuiLeft();
        int y = mcScreen.getGuiTop();
        acc.invokeDrawGuiContainerBackgroundLayer(partialTicks, mouseX, mouseY);
        muiScreen.drawScreen();
        GlStateManager.func_179140_f();
        GlStateManager.func_179097_i();
        ClientScreenHandler.drawVanillaElements((GuiScreen)mcScreen, mouseX, mouseY, partialTicks);
        GlStateManager.func_179094_E();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179091_B();
        acc.setHoveredSlot(null);
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
        GlStateManager.func_179091_B();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderHelper.func_74518_a();
        acc.invokeDrawGuiContainerForegroundLayer(mouseX, mouseY);
        muiScreen.drawForeground();
        RenderHelper.func_74520_c();
        acc.setHoveredSlot(null);
        IWidget hovered = muiScreen.getContext().getHovered();
        if (hovered instanceof IVanillaSlot && (vanillaSlot = (IVanillaSlot)((Object)hovered)).handleAsVanillaSlot()) {
            acc.setHoveredSlot(vanillaSlot.getVanillaSlot());
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)x, (float)y, (float)0.0f);
        MinecraftForge.EVENT_BUS.post((Event)new GuiContainerEvent.DrawForeground(mcScreen, mouseX, mouseY));
        GlStateManager.func_179121_F();
        InventoryPlayer inventoryplayer = Platform.getClientPlayer().field_71071_by;
        ItemStack itemstack = acc.getDraggedStack().func_190926_b() ? inventoryplayer.func_70445_o() : acc.getDraggedStack();
        GlStateManager.func_179109_b((float)x, (float)y, (float)0.0f);
        if (!itemstack.func_190926_b()) {
            int k2 = acc.getDraggedStack().func_190926_b() ? 8 : 16;
            String s = null;
            if (!acc.getDraggedStack().func_190926_b() && acc.getIsRightMouseClick()) {
                itemstack = itemstack.func_77946_l();
                itemstack.func_190920_e(MathUtils.ceil((float)itemstack.func_190916_E() / 2.0f));
            } else if (acc.getDragSplitting() && acc.getDragSplittingSlots().size() > 1) {
                itemstack = itemstack.func_77946_l();
                itemstack.func_190920_e(acc.getDragSplittingRemnant());
                if (itemstack.func_190926_b()) {
                    s = TextFormatting.YELLOW + "0";
                }
            }
            ClientScreenHandler.drawItemStack(mcScreen, NEAAnimationHandler.injectVirtualCursorStack(mcScreen, itemstack), mouseX - x - 8, mouseY - y - k2, s);
        }
        if (!acc.getReturningStack().func_190926_b()) {
            float f = (float)(Minecraft.func_71386_F() - acc.getReturningStackTime()) / 100.0f;
            if (f >= 1.0f) {
                f = 1.0f;
                acc.setReturningStack(ItemStack.field_190927_a);
            }
            int l2 = acc.getReturningStackDestSlot().field_75223_e - acc.getTouchUpX();
            int i3 = acc.getReturningStackDestSlot().field_75221_f - acc.getTouchUpY();
            int l1 = acc.getTouchUpX() + (int)((float)l2 * f);
            int i2 = acc.getTouchUpY() + (int)((float)i3 * f);
            ClientScreenHandler.drawItemStack(mcScreen, acc.getReturningStack(), l1, i2, null);
        }
        NEAAnimationHandler.drawItemAnimation(mcScreen);
        GlStateManager.func_179121_F();
        GlStateManager.func_179145_e();
        GlStateManager.func_179126_j();
        GlStateManager.func_179091_B();
        RenderHelper.func_74519_b();
        Stencil.remove();
    }

    private static void drawItemStack(GuiContainer mcScreen, ItemStack stack, int x, int y, String altText) {
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)32.0f);
        ((GuiAccessor)mcScreen).setZLevel(200.0f);
        ((GuiScreenAccessor)mcScreen).getItemRender().field_77023_b = 200.0f;
        FontRenderer font = stack.func_77973_b().getFontRenderer(stack);
        if (font == null) {
            font = ((GuiScreenAccessor)mcScreen).getFontRenderer();
        }
        Platform.setupDrawItem();
        ((GuiScreenAccessor)mcScreen).getItemRender().func_180450_b(stack, x, y);
        ((GuiScreenAccessor)mcScreen).getItemRender().func_180453_a(font, stack, x, y - (((GuiContainerAccessor)mcScreen).getDraggedStack().func_190926_b() ? 0 : 8), altText);
        GlStateManager.func_179097_i();
        ((GuiAccessor)mcScreen).setZLevel(0.0f);
        ((GuiScreenAccessor)mcScreen).getItemRender().field_77023_b = 0.0f;
    }

    private static void drawVanillaElements(GuiScreen mcScreen, int mouseX, int mouseY, float partialTicks) {
        for (GuiButton guiButton : ((GuiScreenAccessor)mcScreen).getButtonList()) {
            guiButton.func_191745_a(Minecraft.func_71410_x(), mouseX, mouseY, partialTicks);
        }
        for (GuiLabel guiLabel : ((GuiScreenAccessor)mcScreen).getLabelList()) {
            guiLabel.func_146159_a(Minecraft.func_71410_x(), mouseX, mouseY);
        }
    }

    public static void drawDebugScreen(@Nullable ModularScreen muiScreen, @Nullable ModularScreen fallback) {
        fpsCounter.onDraw();
        if (!ModularUIConfig.guiDebugMode) {
            return;
        }
        if (muiScreen == null) {
            if (ClientScreenHandler.checkGui()) {
                muiScreen = currentScreen;
            } else {
                if (fallback == null) {
                    return;
                }
                muiScreen = fallback;
            }
        }
        GlStateManager.func_179097_i();
        GlStateManager.func_179140_f();
        GlStateManager.func_179147_l();
        ModularGuiContext context = muiScreen.getContext();
        int mouseX = context.getAbsMouseX();
        int mouseY = context.getAbsMouseY();
        int screenH = muiScreen.getScreenArea().height;
        int color = Color.argb(180, 40, 115, 220);
        float scale = 0.8f;
        int shift = (int)(11.0f * scale + 0.5f);
        int lineY = screenH - shift - 2;
        GuiDraw.drawText("Mouse Pos: " + mouseX + ", " + mouseY, 5.0f, lineY, scale, color, true);
        GuiDraw.drawText("FPS: " + fpsCounter.getFps(), 5.0f, lineY -= shift, scale, color, true);
        GuiDraw.drawText("Theme ID: " + context.getTheme().getId(), 5.0f, lineY -= shift, scale, color, true);
        LocatedWidget locatedHovered = muiScreen.getPanelManager().getTopWidgetLocated(true);
        if (locatedHovered != null) {
            ClientScreenHandler.drawSegmentLine(lineY -= 4, scale, color);
            lineY -= 10;
            IGuiElement hovered = (IGuiElement)locatedHovered.getElement();
            locatedHovered.applyMatrix(context);
            GlStateManager.func_179094_E();
            context.applyToOpenGl();
            Area area = hovered.getArea();
            IGuiElement parent = hovered.getParent();
            GuiDraw.drawBorder(0.0f, 0.0f, area.width, area.height, color, scale);
            if (hovered.hasParent()) {
                GuiDraw.drawBorder(-area.rx, -area.ry, parent.getArea().width, parent.getArea().height, Color.withAlpha(color, 0.3f), scale);
            }
            GlStateManager.func_179121_F();
            locatedHovered.unapplyMatrix(context);
            GuiDraw.drawText("Pos: " + area.x + ", " + area.y + "  Rel: " + area.rx + ", " + area.ry, 5.0f, lineY, scale, color, true);
            GuiDraw.drawText("Size: " + area.width + ", " + area.height, 5.0f, lineY -= shift, scale, color, true);
            GuiDraw.drawText("Class: " + hovered, 5.0f, lineY -= shift, scale, color, true);
            if (hovered.hasParent()) {
                ClientScreenHandler.drawSegmentLine(lineY -= 4, scale, color);
                area = parent.getArea();
                GuiDraw.drawText("Parent size: " + area.width + ", " + area.height, 5.0f, lineY -= 10, scale, color, true);
                GuiDraw.drawText("Parent: " + parent, 5.0f, lineY -= shift, scale, color, true);
            }
            if (hovered instanceof ItemSlot) {
                ItemSlot slotWidget = (ItemSlot)hovered;
                ClientScreenHandler.drawSegmentLine(lineY -= 4, scale, color);
                ModularSlot slot = slotWidget.getSlot();
                GuiDraw.drawText("Slot Index: " + slot.getSlotIndex(), 5.0f, lineY -= 10, scale, color, false);
                GuiDraw.drawText("Slot Number: " + slot.field_75222_d, 5.0f, lineY -= shift, scale, color, false);
                lineY -= shift;
                if (slotWidget.isSynced()) {
                    SlotGroup slotGroup = slot.getSlotGroup();
                    boolean allowShiftTransfer = slotGroup != null && slotGroup.allowShiftTransfer();
                    GuiDraw.drawText("Shift-Click Priority: " + (allowShiftTransfer ? Integer.valueOf(slotGroup.getShiftClickPriority()) : "DISABLED"), 5.0f, lineY, scale, color, true);
                }
            } else if (hovered instanceof RichTextWidget) {
                RichTextWidget richTextWidget = (RichTextWidget)hovered;
                ClientScreenHandler.drawSegmentLine(lineY -= 4, scale, color);
                Object hoveredElement = richTextWidget.getHoveredElement();
                GuiDraw.drawText("Hovered: " + hoveredElement, 5.0f, lineY -= 10, scale, color, true);
            }
        }
        GuiDraw.drawRect(mouseX, mouseY, 1.0f, 1.0f, Color.withAlpha(Color.GREEN.main, 0.8f));
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private static void drawSegmentLine(int y, float scale, int color) {
        GuiDraw.drawRect(5.0f, y, 140.0f * scale, 1.0f * scale, color);
    }

    public static void updateGuiArea(GuiContainer container, Rectangle area) {
        GuiContainerAccessor acc = (GuiContainerAccessor)container;
        acc.setGuiLeft(area.x);
        acc.setGuiTop(area.y);
        acc.setXSize(area.width);
        acc.setYSize(area.height);
    }

    public static boolean hasScreen() {
        return currentScreen != null;
    }

    @Nullable
    public static GuiScreen getMCScreen() {
        return MCHelper.getCurrentScreen();
    }

    @Nullable
    public static ModularScreen getMuiScreen() {
        return currentScreen;
    }

    private static boolean checkGui() {
        return MCHelper.hasMc() && ClientScreenHandler.checkGui(Minecraft.func_71410_x().field_71462_r);
    }

    private static boolean checkGui(GuiScreen screen) {
        if (!MCHelper.hasMc() || currentScreen == null || !(screen instanceof IMuiScreen)) {
            return false;
        }
        IMuiScreen muiScreen = (IMuiScreen)screen;
        if (screen != Minecraft.func_71410_x().field_71462_r || muiScreen.getScreen() != currentScreen) {
            defaultContext.reset();
            currentScreen = null;
            lastChar = null;
            return false;
        }
        return true;
    }

    public static GuiContext getDefaultContext() {
        return defaultContext;
    }

    public static GuiContext getBestContext() {
        if (ClientScreenHandler.checkGui()) {
            return currentScreen.getContext();
        }
        return defaultContext;
    }

    public static void handleAnimationScale(GuiScreen screen) {
        if (ModularUI.Mods.NEA.isLoaded()) {
            OpeningAnimation.handleScale((GuiScreen)screen, (boolean)true);
        }
    }

    private static enum InputPhase {
        EARLY,
        LATE;


        public boolean isEarly() {
            return this == EARLY;
        }

        public boolean isLate() {
            return this == LATE;
        }
    }
}

