/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.utils;

import com.cleanroommc.modularui.ModularUI;
import com.cleanroommc.modularui.integration.jei.ModularUIJeiPlugin;
import java.util.function.Consumer;
import mezz.jei.gui.overlay.IngredientListOverlay;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;

public class Platform {
    public static final ItemStack EMPTY_STACK = ItemStack.field_190927_a;

    @SideOnly(value=Side.CLIENT)
    @NotNull
    public static EntityPlayerSP getClientPlayer() {
        return Minecraft.func_71410_x().field_71439_g;
    }

    @SideOnly(value=Side.CLIENT)
    public static String getKeyDisplay(KeyBinding keyBinding) {
        return keyBinding.func_151464_g();
    }

    public static boolean isStackEmpty(ItemStack stack) {
        return stack == null || stack.func_190926_b();
    }

    public static ItemStack copyStack(ItemStack stack) {
        return Platform.isStackEmpty(stack) ? EMPTY_STACK : stack.func_77946_l();
    }

    public static void unFocusRecipeViewer() {
        if (ModularUI.Mods.JEI.isLoaded()) {
            ((IngredientListOverlay)ModularUIJeiPlugin.getRuntime().getIngredientListOverlay()).setKeyboardFocus(false);
        }
    }

    public static void startDrawing(DrawMode drawMode, VertexFormat format, Consumer<BufferBuilder> bufferBuilder) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(drawMode.mode, format.format);
        bufferBuilder.accept(buffer);
        tessellator.func_78381_a();
    }

    public static void setupDrawColor() {
        GlStateManager.func_179090_x();
        GlStateManager.func_179147_l();
        GlStateManager.func_179118_c();
    }

    public static void setupDrawTex(ResourceLocation texture) {
        Platform.setupDrawTex();
        Minecraft.func_71410_x().field_71446_o.func_110577_a(texture);
    }

    public static void setupDrawTex(int textureId) {
        Platform.setupDrawTex();
        GlStateManager.func_179144_i((int)textureId);
    }

    public static void setupDrawTex() {
        GlStateManager.func_179098_w();
        GlStateManager.func_179141_d();
        GlStateManager.func_179084_k();
    }

    public static void setupDrawGradient() {
        Platform.setupDrawGradient(GlStateManager.SourceFactor.SRC_ALPHA, GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, GlStateManager.SourceFactor.ONE, GlStateManager.DestFactor.ZERO);
    }

    public static void setupDrawGradient(GlStateManager.SourceFactor srcFactor, GlStateManager.DestFactor destFactor, GlStateManager.SourceFactor srcFactorAlpha, GlStateManager.DestFactor destFactorAlpha) {
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)srcFactor, (GlStateManager.DestFactor)destFactor, (GlStateManager.SourceFactor)srcFactorAlpha, (GlStateManager.DestFactor)destFactorAlpha);
        GlStateManager.func_179103_j((int)7425);
    }

    public static void endDrawGradient() {
        GlStateManager.func_179103_j((int)7424);
    }

    public static void setupDrawItem() {
        Platform.setupDrawTex();
        GlStateManager.func_179091_B();
        RenderHelper.func_74520_c();
        GlStateManager.func_179126_j();
    }

    public static void endDrawItem() {
        RenderHelper.func_74518_a();
        GlStateManager.func_179097_i();
    }

    public static void setupDrawFont() {
        Platform.setupDrawTex();
    }

    public static void setupDrawEntity(Entity entity, float x, float y, float w, float h, float z) {
        float scale;
        float size;
        if (h / entity.field_70131_O < w / entity.field_70130_N) {
            size = entity.field_70131_O;
            scale = h / size;
        } else {
            size = entity.field_70130_N;
            scale = w / size;
        }
        GlStateManager.func_179142_g();
        GlStateManager.func_179126_j();
        GlStateManager.func_179109_b((float)(x + w / 2.0f), (float)(y + h / 2.0f), (float)(z + 50.0f));
        GlStateManager.func_179152_a((float)(-scale), (float)scale, (float)scale);
        GlStateManager.func_179109_b((float)0.0f, (float)(size / 2.0f), (float)0.0f);
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179114_b((float)135.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        RenderHelper.func_74519_b();
        GlStateManager.func_179114_b((float)-135.0f, (float)0.0f, (float)1.0f, (float)0.0f);
    }

    public static void endDrawEntity() {
        RenderHelper.func_74518_a();
        GlStateManager.func_179101_C();
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77476_b);
        GlStateManager.func_179090_x();
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77478_a);
        GlStateManager.func_179097_i();
    }

    public static enum DrawMode {
        QUADS(7),
        POINTS(0),
        LINES(1),
        LINE_STRIP(3),
        LINE_LOOP(2),
        TRIANGLES(4),
        TRIANGLE_STRIP(5),
        TRIANGLE_FAN(6);

        public final int mode;

        private DrawMode(int mode) {
            this.mode = mode;
        }
    }

    public static enum VertexFormat {
        POS(DefaultVertexFormats.field_181705_e),
        POS_TEX(DefaultVertexFormats.field_181707_g),
        POS_COLOR(DefaultVertexFormats.field_181706_f),
        POS_TEX_COLOR(DefaultVertexFormats.field_181709_i),
        POS_NORMAL(DefaultVertexFormats.field_181708_h),
        POS_TEX_NORMAL(DefaultVertexFormats.field_181710_j),
        POS_TEX_COLOR_NORMAL(DefaultVertexFormats.field_181712_l),
        POS_TEX_LMAP_COLOR(DefaultVertexFormats.field_181711_k);

        public final net.minecraft.client.renderer.vertex.VertexFormat format;

        private VertexFormat(net.minecraft.client.renderer.vertex.VertexFormat format) {
            this.format = format;
        }
    }
}

