/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.utils.fakeworld;

import com.cleanroommc.modularui.utils.fakeworld.BlockInfo;
import it.unimi.dsi.fastutil.chars.Char2ObjectMap;
import it.unimi.dsi.fastutil.chars.Char2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.chars.CharArrayList;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.util.math.BlockPos;

public class Structure {
    private Structure() {
    }

    public static StaticBuilder staticBuilder() {
        return new StaticBuilder();
    }

    public static class StaticBuilder {
        private final List<String[]> matrix = new ObjectArrayList();
        private final Char2ObjectMap<BlockInfo> map = new Char2ObjectOpenHashMap();

        private StaticBuilder() {
            this.map.put(' ', (Object)StaticBuilder.air());
        }

        public StaticBuilder aisle(String ... aisle) {
            this.matrix.add(aisle);
            return this;
        }

        public StaticBuilder where(char c, BlockInfo blockInfo) {
            this.map.put(c, (Object)blockInfo);
            return this;
        }

        public static BlockInfo air() {
            return BlockInfo.EMPTY;
        }

        public Map<BlockPos, BlockInfo> buildPosMap() {
            this.checkMissingPredicates();
            Object2ObjectOpenHashMap posMap = new Object2ObjectOpenHashMap();
            for (int y = 0; y < this.matrix.size(); ++y) {
                String[] aisle = this.matrix.get(y);
                for (int x = 0; x < aisle.length; ++x) {
                    char[] aisleX = aisle[x].toCharArray();
                    for (int z = 0; z < aisleX.length; ++z) {
                        char aisleZ = aisleX[z];
                        posMap.put(new BlockPos(x, y, z), (BlockInfo)this.map.get(aisleZ));
                    }
                }
            }
            return posMap;
        }

        private void checkMissingPredicates() {
            CharArrayList list = new CharArrayList();
            for (Char2ObjectMap.Entry entry : this.map.char2ObjectEntrySet()) {
                if (!Objects.isNull(entry.getValue())) continue;
                list.add(entry.getCharKey());
            }
            if (!list.isEmpty()) {
                throw new IllegalStateException(list.stream().map(Object::toString).collect(Collectors.joining(",", "Predicates for character(s) ", " are missing")));
            }
        }
    }
}

