/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.widget;

import com.cleanroommc.modularui.ModularUI;
import com.cleanroommc.modularui.api.GuiAxis;
import com.cleanroommc.modularui.api.layout.ILayoutWidget;
import com.cleanroommc.modularui.api.layout.IResizeable;
import com.cleanroommc.modularui.api.layout.IViewport;
import com.cleanroommc.modularui.api.widget.IGuiElement;
import com.cleanroommc.modularui.api.widget.ISynced;
import com.cleanroommc.modularui.api.widget.IWidget;
import com.cleanroommc.modularui.screen.ModularPanel;
import com.cleanroommc.modularui.screen.viewport.ModularGuiContext;
import com.cleanroommc.modularui.theme.WidgetThemeEntry;
import com.cleanroommc.modularui.utils.ObjectList;
import com.cleanroommc.modularui.value.sync.PanelSyncManager;
import com.cleanroommc.modularui.widget.sizer.Area;
import com.cleanroommc.modularui.widgets.layout.IExpander;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import net.minecraft.client.renderer.GlStateManager;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.ApiStatus;

public class WidgetTree {
    private WidgetTree() {
    }

    public static List<IWidget> getAllChildrenByLayer(IWidget parent) {
        return WidgetTree.getAllChildrenByLayer(parent, false);
    }

    public static List<IWidget> getAllChildrenByLayer(IWidget parent, boolean includeSelf) {
        ArrayList<IWidget> children = new ArrayList<IWidget>();
        if (includeSelf) {
            children.add(parent);
        }
        ObjectList.ObjectArrayList parents = ObjectList.create();
        parents.add(parent);
        while (!parents.isEmpty()) {
            for (IWidget child : ((IWidget)parents.removeFirst()).getChildren()) {
                if (!child.getChildren().isEmpty()) {
                    parents.add(child);
                }
                children.add(child);
            }
        }
        return children;
    }

    public static boolean foreachChildBFS(IWidget parent, Predicate<IWidget> consumer) {
        return WidgetTree.foreachChildBFS(parent, consumer, false);
    }

    public static boolean foreachChildBFS(IWidget parent, Predicate<IWidget> consumer, boolean includeSelf) {
        if (includeSelf && !consumer.test(parent)) {
            return false;
        }
        ObjectList.ObjectArrayList parents = ObjectList.create();
        parents.add(parent);
        while (!parents.isEmpty()) {
            for (IWidget child : ((IWidget)parents.removeFirst()).getChildren()) {
                if (child.hasChildren()) {
                    parents.addLast(child);
                }
                if (consumer.test(child)) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean foreachChildByLayer2(IWidget parent, Predicate<IWidget> consumer, boolean includeSelf) {
        if (includeSelf && !consumer.test(parent)) {
            return false;
        }
        ObjectList.ObjectArrayList parents = ObjectList.create();
        parents.add(parent);
        while (!parents.isEmpty()) {
            for (IWidget child : ((IWidget)parents.removeFirst()).getChildren()) {
                if (!consumer.test(child)) {
                    return false;
                }
                if (!child.hasChildren()) continue;
                parents.addLast(child);
            }
        }
        return true;
    }

    public static boolean foreachChild(IWidget parent, Predicate<IWidget> consumer, boolean includeSelf) {
        if (includeSelf && !consumer.test(parent)) {
            return false;
        }
        if (parent.getChildren().isEmpty()) {
            return true;
        }
        for (IWidget widget : parent.getChildren()) {
            if (!consumer.test(widget)) {
                return false;
            }
            if (widget.getChildren().isEmpty() || !WidgetTree.foreachChild(widget, consumer, false)) continue;
            return false;
        }
        return true;
    }

    public static boolean foreachChildReverse(IWidget parent, Predicate<IWidget> consumer, boolean includeSelf) {
        if (parent.getChildren().isEmpty()) {
            return !includeSelf || consumer.test(parent);
        }
        for (IWidget widget : parent.getChildren()) {
            if (!widget.getChildren().isEmpty() && WidgetTree.foreachChildReverse(widget, consumer, false)) {
                return false;
            }
            if (consumer.test(widget)) continue;
            return false;
        }
        return !includeSelf || consumer.test(parent);
    }

    public static void drawTree(IWidget parent, ModularGuiContext context) {
        WidgetTree.drawTree(parent, context, false, true);
    }

    public static void drawTree(IWidget parent, ModularGuiContext context, boolean ignoreEnabled, boolean drawBackground) {
        if (!parent.isEnabled() && !ignoreEnabled) {
            return;
        }
        if (parent.requiresResize()) {
            WidgetTree.resizeInternal(parent, false);
        }
        float alpha = parent.getPanel().getAlpha();
        IViewport viewport = parent instanceof IViewport ? (IViewport)parent : null;
        context.pushMatrix();
        parent.transform(context);
        boolean canBeSeen = parent.canBeSeen(context);
        GlStateManager.func_179094_E();
        context.applyToOpenGl();
        if (canBeSeen) {
            GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)true);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
            GlStateManager.func_179147_l();
            WidgetThemeEntry<?> widgetTheme = parent.getWidgetTheme(context.getTheme());
            if (drawBackground) {
                parent.drawBackground(context, widgetTheme);
            }
            parent.draw(context, widgetTheme);
            parent.drawOverlay(context, widgetTheme);
        }
        if (viewport != null) {
            if (canBeSeen) {
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
                GlStateManager.func_179147_l();
                viewport.preDraw(context, false);
                GlStateManager.func_179121_F();
                context.pushViewport(viewport, parent.getArea());
                viewport.transformChildren(context);
                GlStateManager.func_179094_E();
                context.applyToOpenGl();
                viewport.preDraw(context, true);
            } else {
                context.pushViewport(viewport, parent.getArea());
                viewport.transformChildren(context);
            }
        }
        GlStateManager.func_179121_F();
        List<IWidget> children = parent.getChildren();
        if (!children.isEmpty()) {
            boolean backgroundSeparate;
            boolean bl = backgroundSeparate = children.size() > 1;
            if (backgroundSeparate) {
                children.forEach(widget -> WidgetTree.drawBackground(widget, context, ignoreEnabled));
            }
            children.forEach(widget -> WidgetTree.drawTree(widget, context, false, !backgroundSeparate));
        }
        if (viewport != null) {
            if (canBeSeen) {
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
                GlStateManager.func_179147_l();
                GlStateManager.func_179094_E();
                context.applyToOpenGl();
                viewport.postDraw(context, true);
                context.popViewport(viewport);
                GlStateManager.func_179121_F();
                GlStateManager.func_179094_E();
                context.applyToOpenGl();
                viewport.postDraw(context, false);
                GlStateManager.func_179121_F();
            } else {
                context.popViewport(viewport);
            }
        }
        context.popMatrix();
    }

    public static void drawBackground(IWidget parent, ModularGuiContext context, boolean ignoreEnabled) {
        if (!parent.isEnabled() && !ignoreEnabled) {
            return;
        }
        float alpha = parent.getPanel().getAlpha();
        context.pushMatrix();
        parent.transform(context);
        boolean canBeSeen = parent.canBeSeen(context);
        if (!canBeSeen) {
            context.popMatrix();
            return;
        }
        GlStateManager.func_179094_E();
        context.applyToOpenGl();
        GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        GlStateManager.func_179147_l();
        WidgetThemeEntry<?> widgetTheme = parent.getWidgetTheme(context.getTheme());
        parent.drawBackground(context, widgetTheme);
        GlStateManager.func_179121_F();
        context.popMatrix();
    }

    public static void drawTreeForeground(IWidget parent, ModularGuiContext context) {
        IViewport viewport1;
        IViewport viewport = parent instanceof IViewport ? (viewport1 = (IViewport)parent) : null;
        context.pushMatrix();
        parent.transform(context);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179147_l();
        parent.drawForeground(context);
        List<IWidget> children = parent.getChildren();
        if (!children.isEmpty()) {
            if (viewport != null) {
                context.pushViewport(viewport, parent.getArea());
                viewport.transformChildren(context);
            }
            children.forEach(widget -> WidgetTree.drawTreeForeground(widget, context));
            if (viewport != null) {
                context.popViewport(viewport);
            }
        }
        context.popMatrix();
    }

    @ApiStatus.Internal
    public static void onUpdate(IWidget parent) {
        WidgetTree.foreachChildBFS(parent, widget -> {
            widget.onUpdate();
            return true;
        }, true);
    }

    @Deprecated
    public static void resize(IWidget parent) {
        parent.scheduleResize();
    }

    @ApiStatus.Internal
    public static void resizeInternal(IWidget parent, boolean onOpen) {
        while (!(parent instanceof ModularPanel) && (parent.getParent() instanceof ILayoutWidget || parent.getParent().flex().dependsOnChildren())) {
            parent = parent.getParent();
        }
        if (!WidgetTree.resizeWidget(parent, true, onOpen) && !WidgetTree.resizeWidget(parent, false, onOpen)) {
            throw new IllegalStateException("Failed to resize widgets");
        }
        WidgetTree.applyPos(parent);
        WidgetTree.foreachChildBFS(parent, child -> {
            child.postResize();
            return true;
        }, true);
    }

    private static boolean resizeWidget(IWidget widget, boolean init, boolean onOpen) {
        GuiAxis guiAxis;
        boolean result;
        boolean alreadyCalculated = false;
        IResizeable resizer = widget.resizer();
        if (init) {
            widget.beforeResize(onOpen);
            resizer.initResizing();
        } else {
            alreadyCalculated = resizer.isFullyCalculated();
        }
        boolean bl = result = alreadyCalculated || resizer.resize(widget);
        if (widget instanceof IExpander) {
            IExpander expander = (IExpander)((Object)widget);
            guiAxis = expander.getExpandAxis();
        } else {
            guiAxis = null;
        }
        GuiAxis expandAxis = guiAxis;
        List anotherResize = Collections.emptyList();
        if (widget.hasChildren()) {
            anotherResize = new ArrayList();
            for (IWidget child : widget.getChildren()) {
                if (init && expandAxis != null) {
                    child.flex().checkExpanded(expandAxis);
                }
                if (WidgetTree.resizeWidget(child, init, onOpen)) continue;
                anotherResize.add(child);
            }
        }
        if (!alreadyCalculated) {
            ILayoutWidget layoutWidget;
            if (widget instanceof ILayoutWidget) {
                layoutWidget = (ILayoutWidget)((Object)widget);
                layoutWidget.layoutWidgets();
            }
            if (!result) {
                result = resizer.postResize(widget);
            }
            if (widget instanceof ILayoutWidget) {
                layoutWidget = (ILayoutWidget)((Object)widget);
                layoutWidget.postLayoutWidgets();
            }
        }
        if (!anotherResize.isEmpty()) {
            anotherResize.removeIf(iWidget -> WidgetTree.resizeWidget(iWidget, false, onOpen));
        }
        if (result && !alreadyCalculated) {
            widget.onResized();
        }
        return result && anotherResize.isEmpty();
    }

    public static void applyPos(IWidget parent) {
        WidgetTree.foreachChildBFS(parent, child -> {
            child.resizer().applyPos((IGuiElement)child);
            return true;
        }, true);
    }

    public static IGuiElement findParent(IGuiElement parent, Predicate<IGuiElement> filter) {
        if (parent == null) {
            return null;
        }
        while (!(parent instanceof ModularPanel)) {
            if (filter.test(parent)) {
                return parent;
            }
            parent = parent.getParent();
        }
        return filter.test(parent) ? parent : null;
    }

    public static IWidget findParent(IWidget parent, Predicate<IWidget> filter) {
        if (parent == null) {
            return null;
        }
        while (!(parent instanceof ModularPanel)) {
            if (filter.test(parent)) {
                return parent;
            }
            parent = parent.getParent();
        }
        return filter.test(parent) ? parent : null;
    }

    public static <T extends IWidget> T findParent(IWidget parent, Class<T> type) {
        if (parent == null) {
            return null;
        }
        while (!(parent instanceof ModularPanel)) {
            if (type.isAssignableFrom(parent.getClass())) {
                return (T)parent;
            }
            parent = parent.getParent();
        }
        return (T)(type.isAssignableFrom(parent.getClass()) ? parent : null);
    }

    @ApiStatus.Internal
    public static void collectSyncValues(PanelSyncManager syncManager, ModularPanel panel) {
        WidgetTree.collectSyncValues(syncManager, panel, true);
    }

    @ApiStatus.Internal
    public static void collectSyncValues(PanelSyncManager syncManager, ModularPanel panel, boolean includePanel) {
        WidgetTree.collectSyncValues(syncManager, panel.getName(), panel, includePanel);
    }

    @ApiStatus.Internal
    public static void collectSyncValues(PanelSyncManager syncManager, String panelName, IWidget panel, boolean includePanel) {
        AtomicInteger id = new AtomicInteger(0);
        String syncKey = "auto_sync:" + panelName;
        WidgetTree.foreachChildBFS(panel, widget -> {
            ISynced synced;
            if (widget instanceof ISynced && (synced = (ISynced)((Object)widget)).isSynced() && !syncManager.hasSyncHandler(synced.getSyncHandler())) {
                syncManager.syncValue(syncKey, id.getAndIncrement(), synced.getSyncHandler());
            }
            return true;
        }, includePanel);
    }

    public static boolean hasSyncedValues(ModularPanel panel) {
        return !WidgetTree.foreachChildBFS(panel, widget -> {
            ISynced synced;
            return !(widget instanceof ISynced) || !(synced = (ISynced)((Object)widget)).isSynced();
        }, true);
    }

    public static void print(IWidget parent, Predicate<IWidget> test) {
        StringBuilder builder = new StringBuilder("Widget tree of ").append(parent).append('\n');
        WidgetTree.getTree(parent.getArea(), parent, test, builder, 0);
        ModularUI.LOGGER.info(builder.toString());
    }

    private static void getTree(Area root, IWidget parent, Predicate<IWidget> test, StringBuilder builder, int indent) {
        if (indent >= 2) {
            builder.append(StringUtils.repeat((char)' ', (int)(indent - 2))).append("- ");
        }
        builder.append(parent).append(" {").append(parent.getArea().x - root.x).append(", ").append(parent.getArea().y - root.y).append(" | ").append(parent.getArea().width).append(", ").append(parent.getArea().height).append("}\n");
        if (parent.hasChildren()) {
            for (IWidget child : parent.getChildren()) {
                if (!test.test(child)) continue;
                WidgetTree.getTree(root, child, test, builder, indent + 2);
            }
        }
    }
}

