/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.widgets;

import com.cleanroommc.modularui.api.UpOrDown;
import com.cleanroommc.modularui.api.drawable.IKey;
import com.cleanroommc.modularui.api.widget.Interactable;
import com.cleanroommc.modularui.drawable.GuiTextures;
import com.cleanroommc.modularui.screen.viewport.ModularGuiContext;
import com.cleanroommc.modularui.theme.WidgetTheme;
import com.cleanroommc.modularui.theme.WidgetThemeEntry;
import com.cleanroommc.modularui.utils.MathUtils;
import com.cleanroommc.modularui.utils.Vector3f;
import com.cleanroommc.modularui.utils.fakeworld.BaseSchemaRenderer;
import com.cleanroommc.modularui.utils.fakeworld.ISchema;
import com.cleanroommc.modularui.widget.Widget;
import com.cleanroommc.modularui.widgets.ButtonWidget;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import org.jetbrains.annotations.NotNull;

public class SchemaWidget
extends Widget<SchemaWidget>
implements Interactable {
    public static final float PI = (float)Math.PI;
    public static final float PI2 = (float)Math.PI * 2;
    public static final float PI_HALF = 1.5707964f;
    public static final float PI_QUART = 0.7853982f;
    private final BaseSchemaRenderer schema;
    private boolean enableRotation = true;
    private boolean enableTranslation = true;
    private boolean enableScaling = true;
    private int lastMouseX;
    private int lastMouseY;
    private float scale = 10.0f;
    private float pitch = 0.7853982f;
    private float yaw = 0.0f;
    private final Vector3f offset = new Vector3f();

    public SchemaWidget(ISchema schema) {
        this(new BaseSchemaRenderer(schema));
    }

    public SchemaWidget(BaseSchemaRenderer schema) {
        this.schema = schema;
    }

    @Override
    public void draw(ModularGuiContext context, WidgetThemeEntry<?> widgetTheme) {
        Vec3d f = this.schema.getSchema().getFocus();
        this.schema.getCamera().setLookAtAndAngle((float)(f.field_72450_a + (double)this.offset.x), (float)(f.field_72448_b + (double)this.offset.y), (float)(f.field_72449_c + (double)this.offset.z), this.scale, this.yaw, this.pitch);
        this.schema.drawAtZero(context, this.getArea(), (WidgetTheme)widgetTheme.getTheme());
    }

    @Override
    public boolean onMouseScroll(UpOrDown scrollDirection, int amount) {
        if (this.enableScaling) {
            this.incrementScale((float)(-scrollDirection.modifier * amount) / 120.0f);
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    public Interactable.Result onMousePressed(int mouseButton) {
        this.lastMouseX = this.getContext().getAbsMouseX();
        this.lastMouseY = this.getContext().getAbsMouseY();
        return Interactable.Result.SUCCESS;
    }

    @Override
    public void onMouseDrag(int mouseButton, long timeSinceClick) {
        int mouseX = this.getContext().getAbsMouseX();
        int mouseY = this.getContext().getAbsMouseY();
        int dx = mouseX - this.lastMouseX;
        int dy = mouseY - this.lastMouseY;
        if (mouseButton == 0 && this.enableRotation) {
            float moveScale = 0.03f;
            this.yaw(this.yaw + (float)dx * moveScale);
            this.pitch(this.pitch + (float)dy * moveScale);
        } else if (mouseButton == 2 && this.enableTranslation) {
            float moveScale = 0.09f;
            Vector3f.resetUnitVectors();
            Vector3f look = this.schema.getCamera().getLookVec().normalise();
            Vector3f right = Vector3f.cross(look, Vector3f.UNIT_Y, null).normalise();
            Vector3f up = Vector3f.cross(right, look, null);
            this.offset.add(right.scale((float)(-dx) * moveScale)).add(up.scale((float)dy * moveScale));
        }
        this.lastMouseX = mouseX;
        this.lastMouseY = mouseY;
    }

    public void incrementScale(float amount) {
        this.scale += amount;
    }

    public SchemaWidget scale(float scale) {
        this.scale = scale;
        return this;
    }

    public SchemaWidget pitch(float pitch) {
        this.pitch = MathUtils.clamp(pitch, -1.5697963f, 1.5697963f);
        return this;
    }

    public SchemaWidget yaw(float yaw) {
        this.yaw = (yaw + (float)Math.PI * 2) % ((float)Math.PI * 2);
        return this;
    }

    public SchemaWidget offset(float x, float y, float z) {
        this.offset.set(x, y, z);
        return this;
    }

    public SchemaWidget enableDragRotation(boolean enable) {
        this.enableRotation = enable;
        return this;
    }

    public SchemaWidget enableDragTranslation(boolean enable) {
        this.enableTranslation = enable;
        return this;
    }

    public SchemaWidget enableScrollScaling(boolean enable) {
        this.enableScaling = enable;
        return this;
    }

    public SchemaWidget enableInteraction(boolean rotation, boolean translation, boolean scaling) {
        return this.enableDragRotation(rotation).enableDragTranslation(translation).enableScrollScaling(scaling);
    }

    public SchemaWidget enableAllInteraction(boolean enable) {
        return this.enableInteraction(enable, enable, enable);
    }

    public RayTraceResult getBlockUnderMouse() {
        return this.schema.getLastRayTrace();
    }

    public static class LayerButton
    extends ButtonWidget<LayerButton> {
        private final int minLayer;
        private final int maxLayer;
        private int currentLayer = Integer.MIN_VALUE;

        public LayerButton(ISchema schema, int minLayer, int maxLayer) {
            this.minLayer = minLayer;
            this.maxLayer = maxLayer;
            this.background(GuiTextures.MC_BACKGROUND);
            this.overlay(IKey.dynamic(() -> this.currentLayer > Integer.MIN_VALUE ? Integer.toString(this.currentLayer) : "ALL").scale(0.5f));
            this.onMousePressed(mouseButton -> {
                if (mouseButton == 0 || mouseButton == 1) {
                    this.currentLayer = mouseButton == 0 ? (this.currentLayer == Integer.MIN_VALUE ? minLayer : ++this.currentLayer) : (this.currentLayer == Integer.MIN_VALUE ? maxLayer : --this.currentLayer);
                    if (this.currentLayer > maxLayer || this.currentLayer < minLayer) {
                        this.currentLayer = Integer.MIN_VALUE;
                    }
                    return true;
                }
                return false;
            });
            schema.setRenderFilter((blockPos, blockInfo) -> this.currentLayer == Integer.MIN_VALUE || this.currentLayer >= blockPos.func_177956_o());
        }

        public LayerButton startLayer(int start) {
            this.currentLayer = start;
            return this;
        }
    }
}

