/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.widgets;

import com.cleanroommc.modularui.api.ITheme;
import com.cleanroommc.modularui.api.drawable.IDrawable;
import com.cleanroommc.modularui.api.value.IBoolValue;
import com.cleanroommc.modularui.screen.RichTooltip;
import com.cleanroommc.modularui.theme.SelectableTheme;
import com.cleanroommc.modularui.theme.WidgetTheme;
import com.cleanroommc.modularui.theme.WidgetThemeEntry;
import com.cleanroommc.modularui.widgets.AbstractCycleButtonWidget;
import java.util.function.Consumer;

public class ToggleButton
extends AbstractCycleButtonWidget<ToggleButton> {
    private boolean invert = false;

    public ToggleButton() {
        this.stateCount(2);
    }

    @Override
    public WidgetThemeEntry<?> getWidgetThemeInternal(ITheme theme) {
        return theme.getToggleButtonTheme();
    }

    @Override
    protected WidgetTheme getActiveWidgetTheme(WidgetThemeEntry<?> widgetTheme, boolean hover) {
        SelectableTheme selectableTheme = widgetTheme.expectType(SelectableTheme.class).getTheme(hover);
        return this.isValueSelected() ^ this.invertSelected() ? selectableTheme.getSelected() : selectableTheme;
    }

    public boolean isValueSelected() {
        return this.getState() == 1;
    }

    @Override
    public ToggleButton value(IBoolValue<?> boolValue) {
        return (ToggleButton)super.value(boolValue);
    }

    public ToggleButton selectedBackground(IDrawable ... selectedBackground) {
        return this.background(true, selectedBackground);
    }

    public ToggleButton selectedHoverBackground(IDrawable ... selectedHoverBackground) {
        return this.hoverBackground(true, selectedHoverBackground);
    }

    @Override
    public ToggleButton background(IDrawable ... selectedBackground) {
        return this.background(false, selectedBackground);
    }

    @Override
    public ToggleButton hoverBackground(IDrawable ... selectedHoverBackground) {
        return this.hoverBackground(false, selectedHoverBackground);
    }

    public ToggleButton background(boolean selected, IDrawable ... background) {
        this.background = this.addToArray(this.background, background, selected ? 1 : 0);
        return this;
    }

    public ToggleButton overlay(boolean selected, IDrawable ... overlay) {
        this.overlay = this.addToArray(this.overlay, overlay, selected ? 1 : 0);
        return this;
    }

    public ToggleButton hoverBackground(boolean selected, IDrawable ... background) {
        this.hoverBackground = this.addToArray(this.hoverBackground, background, selected ? 1 : 0);
        return this;
    }

    public ToggleButton hoverOverlay(boolean selected, IDrawable ... overlay) {
        this.hoverOverlay = this.addToArray(this.hoverOverlay, overlay, selected ? 1 : 0);
        return this;
    }

    public ToggleButton addTooltip(boolean selected, String tooltip) {
        return (ToggleButton)super.addTooltip(selected ? 1 : 0, tooltip);
    }

    public ToggleButton addTooltip(boolean selected, IDrawable tooltip) {
        return (ToggleButton)super.addTooltip(selected ? 1 : 0, tooltip);
    }

    public ToggleButton tooltip(boolean selected, Consumer<RichTooltip> builder) {
        return (ToggleButton)super.tooltip(selected ? 1 : 0, builder);
    }

    public ToggleButton tooltipBuilder(boolean selected, Consumer<RichTooltip> builder) {
        return (ToggleButton)super.tooltipBuilder(selected ? 1 : 0, builder);
    }

    public ToggleButton invertSelected(boolean invert) {
        this.invert = invert;
        return (ToggleButton)this.getThis();
    }

    public boolean invertSelected() {
        return this.invert;
    }
}

