/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.api.drawable;

import com.cleanroommc.modularui.api.GuiAxis;
import com.cleanroommc.modularui.api.drawable.IDrawable;
import com.cleanroommc.modularui.drawable.HoverableIcon;
import com.cleanroommc.modularui.drawable.InteractableIcon;
import com.cleanroommc.modularui.widget.sizer.Box;
import org.jetbrains.annotations.Nullable;

public interface IIcon
extends IDrawable {
    public static final IIcon EMPTY_2PX = EMPTY.asIcon().height(2);

    @Nullable
    public IDrawable getWrappedDrawable();

    public int getWidth();

    public int getHeight();

    default public int getSize(GuiAxis axis) {
        return axis.isHorizontal() ? this.getWidth() : this.getHeight();
    }

    @Override
    default public int getDefaultWidth() {
        return this.getWrappedDrawable() != null ? this.getWrappedDrawable().getDefaultWidth() : 0;
    }

    @Override
    default public int getDefaultHeight() {
        return this.getWrappedDrawable() != null ? this.getWrappedDrawable().getDefaultHeight() : 0;
    }

    public Box getMargin();

    default public IDrawable getRootDrawable() {
        IDrawable drawable = this;
        while (drawable instanceof IIcon) {
            IIcon icon = drawable;
            if ((drawable = icon.getWrappedDrawable()) != null) continue;
            return icon;
        }
        return drawable;
    }

    default public HoverableIcon asHoverable() {
        return new HoverableIcon(this);
    }

    default public InteractableIcon asInteractable() {
        return new InteractableIcon(this);
    }
}

