/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.factory;

import com.cleanroommc.modularui.api.MCHelper;
import com.cleanroommc.modularui.factory.GuiManager;
import com.cleanroommc.modularui.screen.ModularContainer;
import com.cleanroommc.modularui.screen.ModularScreen;
import com.cleanroommc.modularui.screen.RecipeViewerSettingsImpl;
import com.cleanroommc.modularui.screen.UISettings;
import java.util.function.Supplier;
import net.minecraft.client.gui.GuiScreen;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SideOnly(value=Side.CLIENT)
public class ClientGUI {
    private ClientGUI() {
    }

    public static void open(@NotNull ModularScreen screen) {
        ClientGUI.open(screen, new UISettings());
    }

    public static void open(@NotNull ModularScreen screen, @NotNull RecipeViewerSettingsImpl recipeViewerSettings) {
        GuiManager.openScreen(screen, new UISettings(recipeViewerSettings));
    }

    public static void open(@NotNull ModularScreen screen, @Nullable Supplier<ModularContainer> container) {
        UISettings settings = new UISettings();
        settings.customContainer(container);
        GuiManager.openScreen(screen, settings);
    }

    public static void open(@NotNull ModularScreen screen, @NotNull RecipeViewerSettingsImpl recipeViewerSettings, @Nullable Supplier<ModularContainer> container) {
        UISettings settings = new UISettings(recipeViewerSettings);
        settings.customContainer(container);
        GuiManager.openScreen(screen, settings);
    }

    public static void open(@NotNull ModularScreen screen, @NotNull UISettings settings) {
        GuiManager.openScreen(screen, settings);
    }

    public static void open(GuiScreen screen) {
        MCHelper.displayScreen(screen);
    }

    public static void close() {
        MCHelper.displayScreen(null);
    }
}

