/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.network;

import com.cleanroommc.modularui.network.IPacket;
import com.cleanroommc.modularui.network.packets.OpenGuiPacket;
import com.cleanroommc.modularui.network.packets.PacketSyncHandler;
import com.cleanroommc.modularui.network.packets.SClipboard;
import com.cleanroommc.modularui.network.packets.SyncConfig;
import net.minecraft.client.network.NetHandlerPlayClient;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.INetHandler;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.util.IThreadListener;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.relauncher.Side;

public class NetworkHandler {
    public static final SimpleNetworkWrapper CHANNEL = NetworkRegistry.INSTANCE.newSimpleChannel("modularui");
    private static int packetId = 0;
    static final IMessageHandler<IPacket, IPacket> S2CHandler = (message, ctx) -> {
        NetHandlerPlayClient handler = ctx.getClientHandler();
        IThreadListener threadListener = FMLCommonHandler.instance().getWorldThread((INetHandler)handler);
        if (threadListener.isCallingFromMinecraftThread()) {
            return message.executeClient(handler);
        }
        threadListener.addScheduledTask(() -> message.executeClient(handler));
        return null;
    };
    static final IMessageHandler<IPacket, IPacket> C2SHandler = (message, ctx) -> {
        NetHandlerPlayServer handler = ctx.getServerHandler();
        IThreadListener threadListener = FMLCommonHandler.instance().getWorldThread((INetHandler)handler);
        if (threadListener.isCallingFromMinecraftThread()) {
            return message.executeServer(handler);
        }
        threadListener.addScheduledTask(() -> message.executeServer(handler));
        return null;
    };

    public static void init() {
        NetworkHandler.registerS2C(SClipboard.class);
        NetworkHandler.registerS2C(PacketSyncHandler.class);
        NetworkHandler.registerC2S(PacketSyncHandler.class);
        NetworkHandler.registerC2S(SyncConfig.class);
        NetworkHandler.registerS2C(OpenGuiPacket.class);
        NetworkHandler.registerC2S(OpenGuiPacket.class);
    }

    private static void registerC2S(Class<? extends IPacket> clazz) {
        CHANNEL.registerMessage(C2SHandler, clazz, packetId++, Side.SERVER);
    }

    private static void registerS2C(Class<? extends IPacket> clazz) {
        CHANNEL.registerMessage(S2CHandler, clazz, packetId++, Side.CLIENT);
    }

    public static void sendToServer(IPacket packet) {
        CHANNEL.sendToServer((IMessage)packet);
    }

    public static void sendToWorld(IPacket packet, World world) {
        CHANNEL.sendToDimension((IMessage)packet, world.provider.getDimension());
    }

    public static void sendToPlayer(IPacket packet, EntityPlayerMP player) {
        CHANNEL.sendTo((IMessage)packet, player);
    }
}

