/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.screen;

import com.cleanroommc.modularui.ModularUI;
import com.cleanroommc.modularui.api.IPanelHandler;
import com.cleanroommc.modularui.api.widget.IWidget;
import com.cleanroommc.modularui.screen.ModularPanel;
import com.cleanroommc.modularui.screen.ModularScreen;
import com.cleanroommc.modularui.screen.SecondaryPanel;
import com.cleanroommc.modularui.screen.viewport.LocatedWidget;
import com.cleanroommc.modularui.utils.ObjectList;
import com.cleanroommc.modularui.utils.ReverseIterable;
import com.cleanroommc.modularui.widget.WidgetTree;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectListIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnmodifiableView;

public class PanelManager {
    private static final int DISPOSAL_CAPACITY = 16;
    private final ModularScreen screen;
    private final ModularPanel mainPanel;
    private final ObjectList<ModularPanel> panels = ObjectList.create();
    private final List<ModularPanel> panelsClone = new ArrayList<ModularPanel>();
    private final List<ModularPanel> panelsView = Collections.unmodifiableList(this.panelsClone);
    private final ReverseIterable<ModularPanel> reversePanels = new ReverseIterable<ModularPanel>(this.panelsView);
    private final ObjectList<ModularPanel> disposal = ObjectList.create(16);
    private final Map<String, IPanelHandler> panelHandlerMap = new Object2ObjectOpenHashMap();
    private boolean cantDisposeNow = false;
    private boolean dirty = false;
    private State state = State.INIT;

    public PanelManager(ModularScreen screen, ModularPanel panel) {
        this.screen = screen;
        this.mainPanel = Objects.requireNonNull(panel, "Main panel must not be null!");
    }

    boolean tryInit() {
        boolean bl;
        switch (this.state) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case WAIT_DISPOSAL: {
                throw new IllegalStateException("Tried to open panel while its waiting to be disposed. This shouldn't happen.");
            }
            case OPEN: 
            case REOPENED: {
                bl = false;
                break;
            }
            case CLOSED: {
                if (this.panels.isEmpty()) {
                    throw new IllegalStateException("Tried to reopen closed screen, but all panels are disposed!");
                }
                this.panels.forEach(ModularPanel::reopen);
                this.disposal.removeIf(arg_0 -> this.panels.contains(arg_0));
                this.setState(State.REOPENED);
                bl = true;
                break;
            }
            case INIT: 
            case DISPOSED: {
                this.setState(State.OPEN);
                this.openPanel(this.mainPanel, false);
                this.checkDirty();
                bl = true;
            }
        }
        return bl;
    }

    public boolean isMainPanel(ModularPanel panel) {
        return this.mainPanel == panel;
    }

    void checkDirty() {
        if (this.dirty) {
            this.panelsClone.clear();
            this.panelsClone.addAll((Collection<ModularPanel>)((Object)this.panels));
            this.dirty = false;
        }
    }

    private void openPanel(ModularPanel panel, boolean resize) {
        if (this.panels.size() == 127) {
            throw new IllegalStateException("Too many panels are open!");
        }
        if (this.panels.contains(panel) || this.isPanelOpen(panel.getName())) {
            throw new IllegalStateException("Panel " + panel.getName() + " is already open.");
        }
        this.disposal.remove(panel);
        panel.setPanelGuiContext(this.screen.getContext());
        this.panels.addFirst(panel);
        this.dirty = true;
        panel.onOpen(this.screen);
        if (resize) {
            WidgetTree.resizeInternal(panel, true);
        }
    }

    public boolean isPanelOpen(String name) {
        ObjectListIterator objectListIterator = this.panels.iterator();
        while (objectListIterator.hasNext()) {
            ModularPanel panel = (ModularPanel)objectListIterator.next();
            if (!panel.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public ModularScreen getScreen() {
        return this.screen;
    }

    @NotNull
    public ModularPanel getMainPanel() {
        if (this.isDisposed()) {
            throw new IllegalStateException("Screen has been disposed");
        }
        return this.mainPanel;
    }

    @NotNull
    public ModularPanel getTopMostPanel() {
        return this.panels.getFirst();
    }

    @Nullable
    public IWidget getTopWidget() {
        ObjectListIterator objectListIterator = this.panels.iterator();
        while (objectListIterator.hasNext()) {
            ModularPanel panel = (ModularPanel)objectListIterator.next();
            IWidget widget = panel.getTopHovering();
            if (widget == null) continue;
            return widget;
        }
        return null;
    }

    @Nullable
    public LocatedWidget getTopWidgetLocated(boolean debug) {
        ObjectListIterator objectListIterator = this.panels.iterator();
        while (objectListIterator.hasNext()) {
            ModularPanel panel = (ModularPanel)objectListIterator.next();
            LocatedWidget widget = panel.getTopHoveringLocated(debug);
            if (widget == null) continue;
            return widget;
        }
        return null;
    }

    @NotNull
    public List<LocatedWidget> getAllHoveredWidgetsList(boolean debug) {
        ObjectListIterator objectListIterator = this.panels.iterator();
        while (objectListIterator.hasNext()) {
            ModularPanel panel = (ModularPanel)objectListIterator.next();
            if (!panel.isAnyHovered()) continue;
            return panel.getAllHoveringList(debug);
        }
        return Collections.emptyList();
    }

    @Nullable
    public ModularPanel getTopHoveredPanel() {
        ObjectListIterator objectListIterator = this.panels.iterator();
        while (objectListIterator.hasNext()) {
            ModularPanel panel = (ModularPanel)objectListIterator.next();
            if (!panel.isAnyHovered()) continue;
            return panel;
        }
        return null;
    }

    public boolean isBelowMouseInTopPanel(IWidget widget) {
        ObjectListIterator objectListIterator = this.panels.iterator();
        while (objectListIterator.hasNext()) {
            ModularPanel panel = (ModularPanel)objectListIterator.next();
            if (!panel.isAnyHovered()) continue;
            return panel.isBelowMouse(widget);
        }
        return false;
    }

    @ApiStatus.Internal
    public void openPanel(@NotNull ModularPanel panel, @NotNull IPanelHandler panelHandler) {
        IPanelHandler existing = this.panelHandlerMap.get(panel.getName());
        if (existing == null) {
            this.panelHandlerMap.put(panel.getName(), panelHandler);
        } else if (existing != panelHandler) {
            ModularUI.LOGGER.error("Tried to open a panel, but a panel handler that opens the same panel already exists. Using existing panel handler!");
            existing.openPanel();
            return;
        }
        this.openPanel(panel, true);
    }

    public void closePanel(@NotNull ModularPanel panel) {
        if (!this.hasOpenPanel(panel)) {
            throw new IllegalArgumentException("Panel '" + panel.getName() + "' is open in this screen!");
        }
        if (panel == this.getMainPanel()) {
            this.closeAll();
            this.screen.close(true);
            return;
        }
        if (this.panels.remove(panel)) {
            this.finalizePanel(panel);
            this.dirty = true;
        }
    }

    public void closeTopPanel() {
        this.getTopMostPanel().closeIfOpen();
    }

    public boolean closeAll() {
        if (this.state.isOpen) {
            this.panels.forEach(this::finalizePanel);
            this.setState(State.CLOSED);
            this.screen.onClose();
            return true;
        }
        return false;
    }

    void closeScreen() {
        if (this.state.isOpen) {
            this.setState(State.CLOSED);
            this.screen.onClose();
        }
    }

    private void finalizePanel(ModularPanel panel) {
        if (panel.isOpen()) {
            panel.onClose();
        }
        if (!this.disposal.contains(panel)) {
            if (this.disposal.size() == 16) {
                this.disposal.removeFirst().dispose();
            }
            this.disposal.addLast(panel);
        }
    }

    public <T> T doSafe(Supplier<T> runnable) {
        if (this.isDisposed()) {
            return null;
        }
        this.cantDisposeNow = true;
        T t = runnable.get();
        this.cantDisposeNow = false;
        if (this.state == State.WAIT_DISPOSAL) {
            this.setState(State.CLOSED);
            this.dispose();
        }
        return t;
    }

    @ApiStatus.Internal
    public void dispose() {
        if (this.isDisposed()) {
            return;
        }
        if (this.state != State.CLOSED && this.state != State.WAIT_DISPOSAL) {
            throw new IllegalStateException("Must close screen first before disposing!");
        }
        if (this.cantDisposeNow) {
            this.setState(State.WAIT_DISPOSAL);
            return;
        }
        this.panels.forEach(this::finalizePanel);
        this.setState(State.CLOSED);
        this.disposal.forEach(ModularPanel::dispose);
        this.disposal.clear();
        this.panels.clear();
        this.panelsClone.clear();
        this.dirty = false;
        this.setState(State.DISPOSED);
    }

    public boolean hasOpenPanel(ModularPanel panel) {
        return this.panels.contains(panel);
    }

    public boolean hasPanelOpen(String name) {
        return this.getOpenPanel(name) != null;
    }

    @Nullable
    public ModularPanel getOpenPanel(String name) {
        ObjectListIterator objectListIterator = this.panels.iterator();
        while (objectListIterator.hasNext()) {
            ModularPanel panel = (ModularPanel)objectListIterator.next();
            if (!panel.getName().equals(name)) continue;
            return panel;
        }
        return null;
    }

    public int getOpenPanelCount() {
        return this.panels.size();
    }

    public int getPanelIndex(ModularPanel panel) {
        return this.panels.indexOf(panel);
    }

    public int getPanelIndexOrFail(ModularPanel panel, String action) {
        int index = this.getPanelIndex(panel);
        if (index < 0) {
            throw new IllegalArgumentException("Failed to perform action '" + action + "' on panel '" + panel + "', because it is not open in this screen.");
        }
        return index;
    }

    public void pushUp(@NotNull ModularPanel panel) {
        int index = this.getPanelIndexOrFail(panel, "push up");
        if (index == 0) {
            return;
        }
        this.movePanel(index, index - 1);
    }

    public void pushDown(@NotNull ModularPanel panel) {
        int index = this.getPanelIndexOrFail(panel, "push down");
        if (index == this.panels.size() - 1) {
            return;
        }
        this.movePanel(index, index + 1);
    }

    public void pushToTop(@NotNull ModularPanel panel) {
        int index = this.getPanelIndexOrFail(panel, "push to top");
        if (index == 0) {
            return;
        }
        this.movePanel(index, 0);
    }

    public void pushToBottom(@NotNull ModularPanel panel) {
        int index = this.getPanelIndexOrFail(panel, "push to bottom");
        if (index == this.panels.size() - 1) {
            return;
        }
        this.movePanel(index, -1);
    }

    public void movePanelAbove(ModularPanel panelToMove, ModularPanel target) {
        int index = this.getPanelIndexOrFail(panelToMove, "move panel after");
        if (index == 0) {
            return;
        }
        int targetIndex = this.getTopSubPanelIndexOf(target);
        if (targetIndex < 0) {
            throw new IllegalArgumentException("Could not find target or a sub panel of '" + target + "'.");
        }
        this.movePanel(index, targetIndex);
    }

    public void movePanelBelow(ModularPanel panelToMove, ModularPanel target) {
        int index = this.getPanelIndexOrFail(panelToMove, "move panel after");
        if (index == this.panels.size() - 1) {
            return;
        }
        int targetIndex = this.getBottomSubPanelIndexOf(target);
        if (targetIndex < 0) {
            throw new IllegalArgumentException("Could not find target or a sub panel of '" + target + "'.");
        }
        this.movePanel(index, targetIndex + 1);
    }

    private void movePanel(int panelIndex, int target) {
        if (target < 0) {
            target += this.panels.size();
        } else if (panelIndex < target) {
            --target;
        }
        ModularPanel panel = (ModularPanel)this.panels.remove(panelIndex);
        this.panels.add(target, panel);
        this.dirty = true;
    }

    private int getTopSubPanelIndexOf(ModularPanel target) {
        ModularPanel panel;
        int targetIndex = -1;
        int i = this.panels.size() - 1;
        while (i >= 0 && this.isSubPanelOf(panel = (ModularPanel)this.panels.get(i), target)) {
            targetIndex = i--;
        }
        return targetIndex;
    }

    private int getBottomSubPanelIndexOf(ModularPanel target) {
        ModularPanel panel;
        int targetIndex = -1;
        int i = 0;
        while (i < this.panels.size() && this.isSubPanelOf(panel = (ModularPanel)this.panels.get(i), target)) {
            targetIndex = i++;
        }
        return targetIndex;
    }

    public boolean isSubPanelOf(ModularPanel panel, ModularPanel target) {
        if (panel == target) {
            return true;
        }
        IPanelHandler panelHandler = this.panelHandlerMap.get(panel.getName());
        while (panelHandler != null && panelHandler instanceof SecondaryPanel) {
            SecondaryPanel secPanel = (SecondaryPanel)panelHandler;
            if (secPanel.getParent() == target) {
                return true;
            }
            panelHandler = this.panelHandlerMap.get(secPanel.getParent().getName());
        }
        return false;
    }

    @NotNull
    public @UnmodifiableView List<ModularPanel> getOpenPanels() {
        this.checkDirty();
        return this.panelsView;
    }

    @NotNull
    public @UnmodifiableView Iterable<ModularPanel> getReverseOpenPanels() {
        this.checkDirty();
        return this.reversePanels;
    }

    private void setState(State state) {
        this.state = Objects.requireNonNull(state);
    }

    public boolean isClosed() {
        return this.state == State.CLOSED || this.state == State.DISPOSED;
    }

    public boolean isDisposed() {
        return this.state == State.DISPOSED;
    }

    public boolean isOpen() {
        return this.state.isOpen;
    }

    public boolean isReopened() {
        return this.state == State.REOPENED;
    }

    private void checkDisposed() {
        if (this.isDisposed()) {
            throw new IllegalStateException("Screen is disposed!");
        }
    }

    public static enum State {
        INIT(false),
        OPEN(true),
        REOPENED(true),
        CLOSED(false),
        WAIT_DISPOSAL(false),
        DISPOSED(false);

        public final boolean isOpen;

        private State(boolean isOpen) {
            this.isOpen = isOpen;
        }
    }
}

