/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.screen.viewport;

import com.cleanroommc.modularui.api.layout.IViewport;
import com.cleanroommc.modularui.api.layout.IViewportStack;
import com.cleanroommc.modularui.screen.viewport.TransformationMatrix;
import com.cleanroommc.modularui.utils.GuiUtils;
import com.cleanroommc.modularui.widget.sizer.Area;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Vector3f;

public class GuiViewportStack
implements IViewportStack {
    private static final Vector3f sharedVec = new Vector3f();
    private final ObjectArrayList<TransformationMatrix> matrixPool = new ObjectArrayList(256);
    private final ObjectArrayList<TransformationMatrix> viewportStack = new ObjectArrayList();
    private final List<Area> viewportAreas = new ArrayList<Area>();
    private TransformationMatrix top;
    private TransformationMatrix topViewport;

    @Override
    public void reset() {
        this.viewportStack.clear();
        this.top = null;
        this.topViewport = null;
    }

    @Override
    public Area getViewport() {
        return this.topViewport.getArea();
    }

    @Override
    public void pushViewport(IViewport viewport, Area area) {
        Matrix4f parent = this.top == null ? null : this.top.getMatrix();
        Area child = this.getCurrentViewportArea();
        child.set(area);
        if (this.topViewport != null) {
            if (!this.topViewport.isViewportMatrix()) {
                throw new IllegalStateException(this.topViewport.toString());
            }
            if (this.topViewport.getArea() == null) {
                throw new NullPointerException(this.topViewport.toString());
            }
            this.topViewport.getArea().clamp(child);
        }
        this.viewportStack.push((Object)this.newMatrix().construct(viewport, child, parent));
        this.updateViewport(false);
        this.topViewport = (TransformationMatrix)this.viewportStack.top();
    }

    @Override
    public void pushMatrix() {
        this.viewportStack.push((Object)this.newMatrix().construct(this.top == null ? null : this.top.getMatrix()));
        this.updateViewport(false);
    }

    private TransformationMatrix newMatrix() {
        return !this.matrixPool.isEmpty() ? (TransformationMatrix)this.matrixPool.pop() : new TransformationMatrix();
    }

    private void pop() {
        TransformationMatrix matrix = (TransformationMatrix)this.viewportStack.pop();
        matrix.dispose();
        if (this.matrixPool.size() < 256) {
            this.matrixPool.add((Object)matrix);
        }
    }

    private Area getCurrentViewportArea() {
        while (this.viewportAreas.size() < this.viewportStack.size() + 1) {
            this.viewportAreas.add(new Area());
        }
        return this.viewportAreas.get(this.viewportStack.size());
    }

    @Override
    public void popViewport(IViewport viewport) {
        if (this.top == null || !this.top.isViewportMatrix() || this.top.getViewport() != viewport) {
            String name = this.top == null ? "none" : (this.top.isViewportMatrix() ? GuiViewportStack.asString(this.top.getViewport()) : "not a viewport");
            throw new IllegalStateException("Viewports must be popped in reverse order they were pushed. Tried to pop '" + GuiViewportStack.asString(viewport) + "', but last pushed is '" + name + "'.");
        }
        this.pop();
        this.updateViewport(true);
    }

    private static String asString(IViewport viewport) {
        return viewport == null ? "screen viewport" : viewport.toString();
    }

    @Override
    public void popMatrix() {
        if (this.top.isViewportMatrix()) {
            throw new IllegalStateException("Tried to pop viewport matrix, but at the top is a normal matrix.");
        }
        this.pop();
        this.updateViewport(false);
    }

    public void push(TransformationMatrix transformationMatrix) {
        this.viewportStack.push((Object)this.newMatrix().construct(transformationMatrix, this.top == null ? null : this.top.getMatrix()));
        this.updateViewport(false);
        if (this.top.isViewportMatrix()) {
            this.topViewport = this.top;
        }
    }

    public void pop(TransformationMatrix transformationMatrix) {
        if (this.top.getWrapped() != transformationMatrix) {
            throw new IllegalArgumentException();
        }
        boolean isViewport = this.top.isViewportMatrix();
        this.pop();
        this.updateViewport(isViewport);
    }

    @Override
    public int getStackSize() {
        return this.viewportStack.size();
    }

    @Override
    public void popUntilIndex(int index) {
        for (int i = this.viewportStack.size() - 1; i > index; --i) {
            this.pop();
        }
        this.updateViewport(true);
    }

    @Override
    public void popUntilViewport(IViewport viewport) {
        int i = this.viewportStack.size();
        while (--i >= 0 && ((TransformationMatrix)this.viewportStack.top()).getViewport() != viewport) {
            this.pop();
        }
        this.updateViewport(true);
    }

    @Override
    public void translate(float x, float y) {
        this.checkViewport();
        this.top.getMatrix().translate(x, y, 0.0f);
        this.top.markDirty();
    }

    @Override
    public void translate(float x, float y, float z) {
        this.checkViewport();
        this.top.getMatrix().translate(x, y, z);
        this.top.markDirty();
    }

    @Override
    public void rotate(float angle, float x, float y, float z) {
        this.checkViewport();
        this.top.getMatrix().rotate(angle, GuiViewportStack.vec(x, y, z));
        this.top.markDirty();
    }

    @Override
    public void rotateZ(float angle) {
        this.rotate(angle, 0.0f, 0.0f, 1.0f);
    }

    @Override
    public void scale(float x, float y) {
        this.checkViewport();
        this.top.getMatrix().scale(GuiViewportStack.vec(x, y, 1.0f));
        this.top.markDirty();
    }

    @Override
    public void multiply(Matrix4f matrix) {
        this.checkViewport();
        this.top.getMatrix().mul(matrix);
        this.top.markDirty();
    }

    @Override
    public void resetCurrent() {
        this.checkViewport();
        if (this.viewportStack.size() > 1) {
            this.top.getMatrix().set(((TransformationMatrix)this.viewportStack.get(this.viewportStack.size() - 2)).getMatrix());
        } else {
            this.top.getMatrix().identity();
        }
        this.top.markDirty();
    }

    private void checkViewport() {
        if (this.top == null) {
            throw new IllegalStateException("Tried to transform viewport, but there is no viewport!");
        }
    }

    private void updateViewport(boolean findTopViewport) {
        TransformationMatrix transformationMatrix = this.top = this.viewportStack.isEmpty() ? null : (TransformationMatrix)this.viewportStack.top();
        if (!findTopViewport) {
            return;
        }
        this.topViewport = null;
        if (this.viewportStack.isEmpty()) {
            return;
        }
        for (int i = this.viewportStack.size() - 1; i >= 0; --i) {
            TransformationMatrix matrix = (TransformationMatrix)this.viewportStack.get(i);
            if (!matrix.isViewportMatrix()) continue;
            this.topViewport = matrix;
        }
    }

    @Override
    public int transformX(float x, float y) {
        return this.top == null ? (int)x : this.top.transformX(x, y);
    }

    @Override
    public int transformY(float x, float y) {
        return this.top == null ? (int)y : this.top.transformY(x, y);
    }

    @Override
    public int unTransformX(float x, float y) {
        return this.top == null ? (int)x : this.top.unTransformX(x, y);
    }

    @Override
    public int unTransformY(float x, float y) {
        return this.top == null ? (int)y : this.top.unTransformY(x, y);
    }

    @Override
    public Vector3f transform(Vector3f vec, Vector3f dest) {
        return this.top == null ? dest.set(vec) : this.top.transform(vec, dest);
    }

    @Override
    public Vector3f unTransform(Vector3f vec, Vector3f dest) {
        return this.top == null ? dest.set(vec) : this.top.unTransform(vec, dest);
    }

    @Override
    public void applyToOpenGl() {
        if (this.top == null) {
            return;
        }
        GuiUtils.applyTransformationMatrix(this.top.getMatrix());
    }

    @Override
    @Nullable
    public TransformationMatrix peek() {
        return this.top;
    }

    private static Vector3f vec(float x, float y, float z) {
        sharedVec.set(x, y, z);
        return sharedVec;
    }
}

