/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.screen.viewport;

import com.cleanroommc.modularui.ClientProxy;
import com.cleanroommc.modularui.api.ITheme;
import com.cleanroommc.modularui.api.MCHelper;
import com.cleanroommc.modularui.api.widget.IDraggable;
import com.cleanroommc.modularui.api.widget.IFocusedWidget;
import com.cleanroommc.modularui.api.widget.IGuiElement;
import com.cleanroommc.modularui.api.widget.IVanillaSlot;
import com.cleanroommc.modularui.api.widget.IWidget;
import com.cleanroommc.modularui.api.widget.ResizeDragArea;
import com.cleanroommc.modularui.screen.DraggablePanelWrapper;
import com.cleanroommc.modularui.screen.ModularPanel;
import com.cleanroommc.modularui.screen.ModularScreen;
import com.cleanroommc.modularui.screen.PanelManager;
import com.cleanroommc.modularui.screen.RecipeViewerSettingsImpl;
import com.cleanroommc.modularui.screen.UISettings;
import com.cleanroommc.modularui.screen.viewport.GuiContext;
import com.cleanroommc.modularui.screen.viewport.LocatedElement;
import com.cleanroommc.modularui.screen.viewport.LocatedWidget;
import com.cleanroommc.modularui.screen.viewport.TransformationMatrix;
import com.google.common.collect.AbstractIterator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Slot;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnmodifiableView;

public class ModularGuiContext
extends GuiContext {
    private final ModularScreen screen;
    @Nullable
    private GuiScreen parent;
    private LocatedWidget focusedWidget = LocatedWidget.EMPTY;
    private List<LocatedWidget> belowMouse = Collections.emptyList();
    private List<LocatedWidget> hovered = Collections.emptyList();
    private LocatedWidget resizeable = null;
    private final HoveredIterable hoveredWidgets;
    private LocatedElement<IDraggable> draggable;
    private int dragStartX = 0;
    private int dragStartY = 0;
    private int lastButton = -1;
    private long lastClickTime = 0L;
    private int lastDragX;
    private int lastDragY;
    public List<Consumer<ModularGuiContext>> postRenderCallbacks = new ArrayList<Consumer<ModularGuiContext>>();
    private UISettings settings;
    private final Iterable<IWidget> hoveredIterable = () -> new AbstractIterator<IWidget>(){
        private final List<LocatedWidget> currentHovered;
        private final Iterator<LocatedWidget> it;
        {
            this.currentHovered = ModularGuiContext.this.hovered;
            this.it = this.currentHovered.iterator();
        }

        protected IWidget computeNext() {
            if (ModularGuiContext.this.hovered != this.currentHovered) {
                throw new ConcurrentModificationException("Tried to use hovered iterable over multiple ticks, where hovered list changed. This is not allowed!");
            }
            return this.it.hasNext() ? (IWidget)this.it.next().getElement() : this.computeNext();
        }
    };

    public ModularGuiContext(ModularScreen screen) {
        this.screen = screen;
        this.hoveredWidgets = new HoveredIterable(this.screen.getPanelManager());
    }

    public ModularScreen getScreen() {
        return this.screen;
    }

    @Nullable
    public GuiScreen getParentScreen() {
        return this.parent;
    }

    @ApiStatus.Internal
    public void setParentScreen(@Nullable GuiScreen parent) {
        this.parent = parent;
    }

    public boolean isHovered() {
        return !this.hovered.isEmpty();
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="3.2.0")
    public boolean isHovered(IGuiElement guiElement) {
        return guiElement.isHovering();
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="3.2.0")
    public boolean isHoveredFor(IGuiElement guiElement, int ticks) {
        return guiElement.isHoveringFor(ticks);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="3.2.0")
    @Nullable
    public IWidget getHovered() {
        return this.getTopHovered();
    }

    @Nullable
    public IWidget getTopHovered() {
        return this.hovered.isEmpty() ? null : (IWidget)this.hovered.get(0).getElement();
    }

    public @UnmodifiableView Iterable<IWidget> getAllHovered() {
        return this.hoveredIterable;
    }

    public Iterable<IGuiElement> getAllBelowMouse() {
        return this.hoveredWidgets;
    }

    public boolean isFocused() {
        return this.focusedWidget.getElement() != null;
    }

    public boolean isFocused(IFocusedWidget widget) {
        return this.focusedWidget.getElement() == widget;
    }

    public LocatedWidget getFocusedWidget() {
        return this.focusedWidget;
    }

    public void focus(IFocusedWidget widget) {
        this.focus(LocatedWidget.of((IWidget)((Object)widget)));
    }

    public void focus(@NotNull LocatedWidget widget) {
        IFocusedWidget focusedWidget;
        if (this.focusedWidget.getElement() == widget.getElement()) {
            return;
        }
        if (widget.getElement() != null && !(widget.getElement() instanceof IFocusedWidget)) {
            throw new IllegalArgumentException();
        }
        if (this.focusedWidget.getElement() != null) {
            focusedWidget = (IFocusedWidget)this.focusedWidget.getElement();
            focusedWidget.onRemoveFocus(this);
            this.screen.setFocused(false);
        }
        this.focusedWidget = widget;
        if (this.focusedWidget.getElement() != null) {
            focusedWidget = (IFocusedWidget)this.focusedWidget.getElement();
            focusedWidget.onFocus(this);
            this.screen.setFocused(true);
        }
    }

    public void removeFocus() {
        this.focus(LocatedWidget.EMPTY);
    }

    public boolean focusNext(IWidget parent) {
        return this.focus(parent, -1, 1);
    }

    public boolean focusPrevious(IWidget parent) {
        return this.focus(parent, -1, -1);
    }

    public boolean focus(IWidget parent, int index, int factor) {
        return this.focus(parent, index, factor, false);
    }

    public boolean focus(IWidget widget, int index, int factor, boolean stop) {
        List<IWidget> children = widget.getChildren();
        factor = factor >= 0 ? 1 : -1;
        index += factor;
        while (index >= 0 && index < children.size()) {
            IWidget child = children.get(index);
            if (child.isEnabled()) {
                int start;
                if (child instanceof IFocusedWidget) {
                    IFocusedWidget focusedWidget1 = (IFocusedWidget)((Object)child);
                    this.focus(focusedWidget1);
                    return true;
                }
                int n = start = factor > 0 ? -1 : child.getChildren().size();
                if (this.focus(child, start, factor, true)) {
                    return true;
                }
            }
            index += factor;
        }
        IWidget grandparent = widget.getParent();
        boolean isRoot = grandparent instanceof ModularPanel;
        if (!stop && (isRoot || grandparent.canBeSeen(this))) {
            List<IWidget> siblings = grandparent.getChildren();
            if (this.focus(grandparent, siblings.indexOf(widget), factor)) {
                return true;
            }
            if (isRoot) {
                return this.focus(grandparent, factor > 0 ? -1 : siblings.size() - 1, factor);
            }
        }
        return false;
    }

    public boolean hasDraggable() {
        return this.draggable != null;
    }

    public boolean isMouseItemEmpty() {
        EntityPlayer player = MCHelper.getPlayer();
        return player == null || player.inventory.getItemStack().isEmpty();
    }

    @ApiStatus.Internal
    public boolean onMousePressed(int button) {
        if ((button == 0 || button == 1) && this.isMouseItemEmpty() && this.hasDraggable()) {
            this.dropDraggable(true);
            return true;
        }
        return false;
    }

    @ApiStatus.Internal
    public boolean onMouseReleased(int button) {
        if (button == this.lastButton && this.isMouseItemEmpty() && this.hasDraggable()) {
            long time = Minecraft.getSystemTime();
            this.dropDraggable(this.dragStartX == this.getAbsMouseX() && this.dragStartY == this.getAbsMouseY() || time - this.lastClickTime < 100L);
            return true;
        }
        return false;
    }

    @ApiStatus.Internal
    public void dropDraggable(boolean shouldCancel) {
        this.draggable.applyMatrix(this);
        this.draggable.getElement().onDragEnd(!shouldCancel && this.draggable.getElement().canDropHere(this.getAbsMouseX(), this.getAbsMouseY(), this.getTopHovered()));
        this.draggable.getElement().setMoving(false);
        this.draggable.unapplyMatrix(this);
        this.draggable = null;
        this.lastButton = -1;
        this.lastClickTime = 0L;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @ApiStatus.Internal
    public boolean onHoveredClick(int button, LocatedWidget hovered) {
        LocatedElement<IDraggable> draggable;
        if (button != 0 && button != 1 || !this.isMouseItemEmpty() || this.hasDraggable()) return false;
        IWidget widget = (IWidget)hovered.getElement();
        if (widget instanceof IDraggable) {
            IDraggable iDraggable = (IDraggable)((Object)widget);
            draggable = new LocatedElement<IDraggable>(iDraggable, hovered.getTransformationMatrix());
        } else {
            if (!(widget instanceof ModularPanel)) return false;
            ModularPanel panel = (ModularPanel)widget;
            if (!panel.isDraggable()) return false;
            if (!panel.flex().hasFixedSize()) {
                throw new IllegalStateException("Panel must have a fixed size. It can't specify left AND right or top AND bottom!");
            }
            draggable = new LocatedElement<DraggablePanelWrapper>(new DraggablePanelWrapper(panel), TransformationMatrix.EMPTY);
        }
        if (!draggable.getElement().onDragStart(button)) return false;
        draggable.getElement().setMoving(true);
        this.draggable = draggable;
        this.dragStartX = this.getAbsMouseX();
        this.dragStartY = this.getAbsMouseY();
        this.lastButton = button;
        this.lastClickTime = Minecraft.getSystemTime();
        return true;
    }

    @ApiStatus.Internal
    public void drawDraggable() {
        if (this.hasDraggable()) {
            this.draggable.applyMatrix(this);
            this.draggable.getElement().drawMovingState(this, this.getPartialTicks());
            this.draggable.unapplyMatrix(this);
        }
    }

    private static boolean isStillHovered(List<LocatedWidget> newHovered, LocatedWidget lw) {
        if (newHovered == null) {
            return false;
        }
        for (LocatedWidget hovered : newHovered) {
            if (hovered.getElement() != lw.getElement()) continue;
            return true;
        }
        return false;
    }

    @ApiStatus.Internal
    public void onFrameUpdate() {
        List<LocatedWidget> newBelowMouse;
        if (this.hasDraggable() && (this.lastDragX != this.getAbsMouseX() || this.lastDragY != this.getAbsMouseY())) {
            this.lastDragX = this.getAbsMouseX();
            this.lastDragY = this.getAbsMouseY();
            this.draggable.applyMatrix(this);
            this.draggable.getElement().onDrag(this.lastButton, this.lastClickTime);
            this.draggable.unapplyMatrix(this);
        }
        if (!(newBelowMouse = this.screen.getPanelManager().getAllHoveredWidgetsList(false)).isEmpty()) {
            List<LocatedWidget> oldBelowMouse = this.belowMouse;
            this.belowMouse = newBelowMouse;
            for (LocatedWidget lw : this.belowMouse) {
                if (!((IWidget)lw.getElement()).isValid() || ((IWidget)lw.getElement()).isBelowMouse()) continue;
                ((IWidget)lw.getElement()).onMouseEnterArea();
            }
            List<LocatedWidget> newHovered = this.getHoveredWidgets(newBelowMouse);
            List<LocatedWidget> oldHovered = this.hovered;
            this.hovered = newHovered;
            this.checkHoverEnd(newHovered, oldHovered, IGuiElement::onMouseEndHover);
            this.checkHoverEnd(newBelowMouse, oldBelowMouse, IGuiElement::onMouseLeaveArea);
        } else {
            this.checkHoverEnd(null, this.hovered, IGuiElement::onMouseEndHover);
            this.checkHoverEnd(null, this.belowMouse, IGuiElement::onMouseLeaveArea);
            this.hovered = Collections.emptyList();
            this.belowMouse = Collections.emptyList();
            this.resizeable = null;
            ClientProxy.resetCursorIcon();
        }
    }

    private List<LocatedWidget> getHoveredWidgets(List<LocatedWidget> belowMouse) {
        ResizeDragArea oldResizeDragArea;
        Slot slot = null;
        LocatedWidget resizeable = null;
        ResizeDragArea newResizeDragArea = null;
        ArrayList newHovered = new ArrayList();
        for (LocatedWidget lw : belowMouse) {
            IVanillaSlot vanillaSlot;
            Object object;
            if (!((IWidget)lw.getElement()).isValid() || !((IWidget)lw.getElement()).canHover()) continue;
            newHovered.add(lw);
            if (!((IWidget)lw.getElement()).isHovering()) {
                ((IWidget)lw.getElement()).onMouseStartHover();
            }
            if (slot == null && (object = lw.getElement()) instanceof IVanillaSlot && (vanillaSlot = (IVanillaSlot)object).handleAsVanillaSlot()) {
                slot = vanillaSlot.getVanillaSlot();
            }
            if ((object = lw.getAdditionalHoverInfo()) instanceof ResizeDragArea) {
                ResizeDragArea resizeDragArea = (ResizeDragArea)((Object)object);
                resizeable = lw;
                newResizeDragArea = resizeDragArea;
            }
            if (((IWidget)lw.getElement()).canHoverThrough()) continue;
            break;
        }
        ResizeDragArea resizeDragArea = oldResizeDragArea = this.resizeable != null ? (ResizeDragArea)((Object)this.resizeable.getAdditionalHoverInfo()) : null;
        if (newResizeDragArea != oldResizeDragArea) {
            ClientProxy.setCursorResizeIcon(newResizeDragArea);
            this.resizeable = resizeable;
        }
        this.screen.getScreenWrapper().setHoveredSlot(slot);
        return newHovered.isEmpty() ? Collections.emptyList() : newHovered;
    }

    private void checkHoverEnd(List<LocatedWidget> newList, List<LocatedWidget> oldList, Consumer<IWidget> onHoverEnd) {
        if (!oldList.isEmpty()) {
            for (LocatedWidget lw : oldList) {
                if (ModularGuiContext.isStillHovered(newList, lw)) continue;
                onHoverEnd.accept((IWidget)lw.getElement());
            }
        }
    }

    public ITheme getTheme() {
        return this.screen.getCurrentTheme();
    }

    @Override
    public boolean isMuiContext() {
        return true;
    }

    @Override
    public ModularGuiContext getMuiContext() {
        return this;
    }

    public UISettings getUISettings() {
        if (this.settings == null) {
            throw new IllegalStateException("The screen is not yet initialised!");
        }
        return this.settings;
    }

    public RecipeViewerSettingsImpl getRecipeViewerSettings() {
        if (this.screen.isOverlay()) {
            throw new IllegalStateException("Overlays don't have recipe viewer settings!");
        }
        return (RecipeViewerSettingsImpl)this.getUISettings().getRecipeViewerSettings();
    }

    @ApiStatus.Internal
    public void setSettings(UISettings settings) {
        if (this.settings != null) {
            throw new IllegalStateException("Tried to set settings twice");
        }
        this.settings = settings;
        if (this.settings.getTheme() != null) {
            this.screen.useTheme(this.settings.getTheme());
        }
    }

    private static class HoveredIterable
    implements Iterable<IGuiElement> {
        private final PanelManager panelManager;

        private HoveredIterable(PanelManager panelManager) {
            this.panelManager = panelManager;
        }

        @Override
        @NotNull
        public Iterator<IGuiElement> iterator() {
            return new Iterator<IGuiElement>(){
                private final Iterator<ModularPanel> panelIt;
                private Iterator<LocatedWidget> widgetIt;
                {
                    this.panelIt = panelManager.getOpenPanels().iterator();
                }

                @Override
                public boolean hasNext() {
                    if (this.widgetIt == null) {
                        if (!this.panelIt.hasNext()) {
                            return false;
                        }
                        this.widgetIt = this.panelIt.next().getHovering().iterator();
                    }
                    return this.widgetIt.hasNext();
                }

                @Override
                public IGuiElement next() {
                    if (this.widgetIt == null || !this.widgetIt.hasNext()) {
                        this.widgetIt = this.panelIt.next().getHovering().iterator();
                    }
                    return (IGuiElement)this.widgetIt.next().getElement();
                }
            };
        }
    }
}

