/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.utils;

import com.cleanroommc.modularui.ModularUI;
import com.cleanroommc.modularui.api.drawable.IInterpolation;
import com.cleanroommc.modularui.utils.ColorShade;
import com.cleanroommc.modularui.utils.Interpolation;
import com.cleanroommc.modularui.utils.JsonHelper;
import com.cleanroommc.modularui.utils.MathUtils;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.Locale;
import java.util.function.ToIntFunction;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.ApiStatus;

public class Color {
    public static final int TEXT_COLOR_DARK = -12566464;
    public static final ColorShade WHITE = ColorShade.builder("white", -1).addDarker(-526345, -1052689, -1579033, -2105377, -2631721, -3158065, -3684409, -4210753).build();
    public static final ColorShade BLACK = ColorShade.builder("black", -16777216).addBrighter(-16250872, -15724528, -15198184, -14671840, -14145496, -13619152, -13092808, -12566464).build();
    public static final ColorShade RED = ColorShade.builder("red", -769226).addBrighter(-1092784, -1739917, -1074534, -12846, -5138).addDarker(-1754827, -2937041, -3790808, -4776932).build();
    public static final ColorShade RED_ACCENT = ColorShade.builder("red_accent", -44462).addBrighter(-30080).addDarker(-59580, -2818048).build();
    public static final ColorShade PINK = ColorShade.builder("pink", -1499549).addBrighter(-1294214, -1023342, -749647, -476208, -203540).addDarker(-2614432, -4056997, -5434281, -7860657).build();
    public static final ColorShade PINK_ACCENT = ColorShade.builder("pink_accent", -49023).addBrighter(-32597).addDarker(-720809, -3862174).build();
    public static final ColorShade PURPLE = ColorShade.builder("purple", -6543440).addBrighter(-5552196, -4560696, -3238952, -1982745, -793099).addDarker(-7461718, -8708190, -9823334, -11922292).build();
    public static final ColorShade PURPLE_ACCENT = ColorShade.builder("purple_accent", -2080517).addBrighter(-1408772).addDarker(-2817799, -5635841).build();
    public static final ColorShade DEEP_PURPLE = ColorShade.builder("deep_purple", -10011977).addBrighter(-8497214, -6982195, -5005861, -3029783, -1185802).addDarker(-10603087, -11457112, -12245088, -13558894).build();
    public static final ColorShade DEEP_PURPLE_ACCENT = ColorShade.builder("deep_purple_accent", -8630785).addBrighter(-5011201).addDarker(-10149889, -10149889).build();
    public static final ColorShade INDIGO = ColorShade.builder("indigo", -12627531).addBrighter(-10720320, -8812853, -6313766, -3814679, -1512714).addDarker(-13022805, -13615201, -14142061, -15064194).build();
    public static final ColorShade INDIGO_ACCENT = ColorShade.builder("indigo_accent", -11309570).addBrighter(-7561473).addDarker(-12756226, -13611010).build();
    public static final ColorShade BLUE = ColorShade.builder("blue", -14575885).addBrighter(-12409355, -10177034, -7288071, -4464901, -1838339).addDarker(-14776091, -15108398, -15374912, -15906911).build();
    public static final ColorShade BLUE_ACCENT = ColorShade.builder("blue_accent", -12285185).addBrighter(-8211969).addDarker(-14059009, -14064897).build();
    public static final ColorShade LIGHT_BLUE = ColorShade.builder("light_blue", -16537100).addBrighter(-14043402, -11549705, -8268550, -4987396, -1968642).addDarker(-16540699, -16611119, -16615491, -16689253).build();
    public static final ColorShade LIGHT_BLUE_ACCENT = ColorShade.builder("light_blue_accent", -12532481).addBrighter(-8333057).addDarker(-16731905, -16739862).build();
    public static final ColorShade CYAN = ColorShade.builder("cyan", -16728876).addBrighter(-14235942, -11677471, -8331542, -5051406, -2033670).addDarker(-16732991, -16738393, -16743537, -16752540).build();
    public static final ColorShade CYAN_ACCENT = ColorShade.builder("cyan_accent", -15138817).addBrighter(-8060929).addDarker(-16718337, -16729900).build();
    public static final ColorShade TEAL = ColorShade.builder("teal", -16738680).addBrighter(-14244198, -11684180, -8336444, -5054501, -2034959).addDarker(-16742021, -16746133, -16750244, -16757440).build();
    public static final ColorShade TEAL_ACCENT = ColorShade.builder("teal_accent", -10158118).addBrighter(-5767189).addDarker(-14816842, -16728155).build();
    public static final ColorShade GREEN = ColorShade.builder("green", -11751600).addBrighter(-10044566, -8271996, -5908825, -3610935, -1509911).addDarker(-12345273, -13070788, -13730510, -14983648).build();
    public static final ColorShade GREEN_ACCENT = ColorShade.builder("green_accent", -9834322).addBrighter(-4589878).addDarker(-16718218, -16725933).build();
    public static final ColorShade LIGHT_GREEN = ColorShade.builder("light_green", -7617718).addBrighter(-6501275, -5319295, -3808859, -2298424, -919319).addDarker(-8604862, -9920712, -11171025, -13407970).build();
    public static final ColorShade LIGHT_GREEN_ACCENT = ColorShade.builder("light_green_accent", -5046439).addBrighter(-3342448).addDarker(-8978685, -10167017).build();
    public static final ColorShade LIME = ColorShade.builder("lime", -3285959).addBrighter(-2825897, -2300043, -1642852, -985917, -394265).addDarker(-4142541, -5262293, -6382300, -8227049).build();
    public static final ColorShade LIME_ACCENT = ColorShade.builder("lime_accent", -1114303).addBrighter(-721023).addDarker(-3735808, -5314048).build();
    public static final ColorShade YELLOW = ColorShade.builder("yellow", -5317).addBrighter(-4520, -3722, -2659, -1596, -537).addDarker(-141259, -278483, -415707, -688361).build();
    public static final ColorShade YELLOW_ACCENT = ColorShade.builder("yellow_accent", -256).addBrighter(-115).addDarker(-5632, -10752).build();
    public static final ColorShade AMBER = ColorShade.builder("amber", -16121).addBrighter(-13784, -10929, -8062, -4941, -1823).addDarker(-19712, -24576, -28928, -37120).build();
    public static final ColorShade AMBER_ACCENT = ColorShade.builder("amber_accent", -10432).addBrighter(-6785).addDarker(-15360, -21760).build();
    public static final ColorShade ORANGE = ColorShade.builder("orange", -26624).addBrighter(-22746, -18611, -13184, -8014, -3104).addDarker(-291840, -689152, -1086464, -1683200).build();
    public static final ColorShade ORANGE_ACCENT = ColorShade.builder("orange_accent", -21696).addBrighter(-11904).addDarker(-28416, -37632).build();
    public static final ColorShade DEEP_ORANGE = ColorShade.builder("deep_orange", -43230).addBrighter(-36797, -30107, -21615, -13124, -267801).addDarker(-765666, -1684967, -2604267, -4246004).build();
    public static final ColorShade DEEP_ORANGE_ACCENT = ColorShade.builder("deep_orange_accent", -37312).addBrighter(-24960).addDarker(-49920, -2282496).build();
    public static final ColorShade BROWN = ColorShade.builder("brown", -8825528).addBrighter(-7508381, -6190977, -4412764, -2634552, -1053719).addDarker(-9614271, -10665929, -11652050, -12703965).build();
    public static final ColorShade GREY = ColorShade.builder("grey", -6381922).addBrighter(-4342339, -2039584, -1118482, -657931, -328966).addDarker(-9079435, -10395295, -12434878, -14606047).build();
    public static final ColorShade BLUE_GREY = ColorShade.builder("blue_grey", -10453621).addBrighter(-8875876, -7297874, -5194043, -3155748, -1249295).addDarker(-11243910, -12232092, -13154481, -14273992).build();

    public static int rgb(int red, int green, int blue) {
        return Color.argb(red, green, blue, 255);
    }

    public static int argb(int red, int green, int blue, int alpha) {
        return (alpha & 0xFF) << 24 | (red & 0xFF) << 16 | (green & 0xFF) << 8 | blue & 0xFF;
    }

    public static int argb(float red, float green, float blue, float alpha) {
        return Color.argb((int)(red * 255.0f), (int)(green * 255.0f), (int)(blue * 255.0f), (int)(alpha * 255.0f));
    }

    public static int rgb(float red, float green, float blue) {
        return Color.argb(red, green, blue, 1.0f);
    }

    public static int ofHSV(float hue, float saturation, float value) {
        return Color.ofHSV(hue, saturation, value, 1.0f);
    }

    public static int ofHSV(float hue, float saturation, float value, float alpha) {
        if ((hue %= 360.0f) < 0.0f) {
            hue += 360.0f;
        }
        saturation = MathUtils.clamp(saturation, 0.0f, 1.0f);
        value = MathUtils.clamp(value, 0.0f, 1.0f);
        alpha = MathUtils.clamp(alpha, 0.0f, 1.0f);
        float c = value * saturation;
        float x = c * (1.0f - Math.abs(hue / 60.0f % 2.0f - 1.0f));
        float m = value - c;
        return Color.ofHxcm(hue, c, x, m, alpha);
    }

    public static int ofHSL(float hue, float saturation, float lightness) {
        return Color.ofHSL(hue, saturation, lightness, 1.0f);
    }

    public static int ofHSL(float hue, float saturation, float lightness, float alpha) {
        if ((hue %= 360.0f) < 0.0f) {
            hue += 360.0f;
        }
        saturation = MathUtils.clamp(saturation, 0.0f, 1.0f);
        lightness = MathUtils.clamp(lightness, 0.0f, 1.0f);
        alpha = MathUtils.clamp(alpha, 0.0f, 1.0f);
        float c = (1.0f - Math.abs(2.0f * lightness - 1.0f)) * saturation;
        float x = c * (1.0f - Math.abs(hue / 60.0f % 2.0f - 1.0f));
        float m = lightness - c / 2.0f;
        return Color.ofHxcm(hue, c, x, m, alpha);
    }

    private static int ofHxcm(float hue, float c, float x, float m, float alpha) {
        if (hue < 60.0f) {
            return Color.argb(c + m, x + m, m, alpha);
        }
        if (hue < 120.0f) {
            return Color.argb(x + m, c + m, m, alpha);
        }
        if (hue < 180.0f) {
            return Color.argb(m, c + m, x + m, alpha);
        }
        if (hue < 240.0f) {
            return Color.argb(m, x + m, c + m, alpha);
        }
        if (hue < 300.0f) {
            return Color.argb(x + m, m, c + m, alpha);
        }
        return Color.argb(c + m, m, x + m, alpha);
    }

    public static int ofCMYK(float cyan, float magenta, float yellow, float black) {
        return Color.ofCMYK(cyan, magenta, yellow, black, 1.0f);
    }

    public static int ofCMYK(float cyan, float magenta, float yellow, float black, float alpha) {
        float oneMinusBlack = 1.0f - black;
        return Color.argb((1.0f - cyan) * oneMinusBlack, (1.0f - magenta) * oneMinusBlack, (1.0f - yellow) * oneMinusBlack, alpha);
    }

    public static int getRed(int argb) {
        return argb >> 16 & 0xFF;
    }

    public static int getGreen(int argb) {
        return argb >> 8 & 0xFF;
    }

    public static int getBlue(int argb) {
        return argb & 0xFF;
    }

    public static int getAlpha(int argb) {
        return argb >> 24 & 0xFF;
    }

    public static float getRedF(int argb) {
        return (float)Color.getRed(argb) / 255.0f;
    }

    public static float getGreenF(int argb) {
        return (float)Color.getGreen(argb) / 255.0f;
    }

    public static float getBlueF(int argb) {
        return (float)Color.getBlue(argb) / 255.0f;
    }

    public static float getAlphaF(int argb) {
        return (float)Color.getAlpha(argb) / 255.0f;
    }

    public static int getRedSq(int argb) {
        int v = Color.getRed(argb);
        return v * v;
    }

    public static int getGreenSq(int argb) {
        int v = Color.getGreen(argb);
        return v * v;
    }

    public static int getBlueSq(int argb) {
        int v = Color.getBlue(argb);
        return v * v;
    }

    public static int withRed(int argb, int red) {
        return (argb &= 0xFF00FFFF) | red << 16;
    }

    public static int withGreen(int argb, int green) {
        return (argb &= 0xFFFF00FF) | green << 8;
    }

    public static int withBlue(int argb, int blue) {
        return (argb &= 0xFFFFFF00) | blue;
    }

    public static int withAlpha(int argb, int alpha) {
        return (argb &= 0xFFFFFF) | alpha << 24;
    }

    public static int withRed(int argb, float red) {
        return Color.withRed(argb, (int)(red * 255.0f));
    }

    public static int withGreen(int argb, float green) {
        return Color.withGreen(argb, (int)(green * 255.0f));
    }

    public static int withBlue(int argb, float blue) {
        return Color.withBlue(argb, (int)(blue * 255.0f));
    }

    public static int withAlpha(int argb, float alpha) {
        return Color.withAlpha(argb, (int)(alpha * 255.0f));
    }

    public static float getHue(int argb) {
        float r = Color.getRedF(argb);
        float g = Color.getGreenF(argb);
        float b = Color.getBlueF(argb);
        if (r == g && r == b) {
            return 0.0f;
        }
        float min = Math.min(r, Math.min(g, b));
        float hue = 0.0f;
        if (r >= g && r >= b) {
            hue = (g - b) / (r - min) % 6.0f;
        } else if (g >= r && g >= b) {
            hue = (b - r) / (g - min) + 2.0f;
        } else if (b >= r && b >= g) {
            hue = (r - g) / (b - min) + 4.0f;
        }
        hue *= 60.0f;
        if (hue < 0.0f) {
            hue += 360.0f;
        }
        return hue;
    }

    public static float getHSVSaturation(int argb) {
        float r = Color.getRedF(argb);
        float g = Color.getGreenF(argb);
        float b = Color.getBlueF(argb);
        float min = Math.min(r, Math.min(g, b));
        float max = Math.max(r, Math.max(g, b));
        return max == 0.0f ? 0.0f : (max - min) / max;
    }

    public static float getHSLSaturation(int argb) {
        float r = Color.getRedF(argb);
        float g = Color.getGreenF(argb);
        float b = Color.getBlueF(argb);
        float min = Math.min(r, Math.min(g, b));
        float max = Math.max(r, Math.max(g, b));
        return (max - min) / (1.0f - Math.abs(max + min - 1.0f));
    }

    public static float getValue(int argb) {
        float r = Color.getRedF(argb);
        float g = Color.getGreenF(argb);
        float b = Color.getBlueF(argb);
        return Math.max(r, Math.max(g, b));
    }

    public static float getLightness(int argb) {
        float r = Color.getRedF(argb);
        float g = Color.getGreenF(argb);
        float b = Color.getBlueF(argb);
        float min = Math.min(r, Math.min(g, b));
        float max = Math.max(r, Math.max(g, b));
        return (max + min) / 2.0f;
    }

    public static int withHSVHue(int argb, float hue) {
        return Color.ofHSV(hue, Color.getHSVSaturation(argb), Color.getValue(argb), Color.getAlphaF(argb));
    }

    public static int withHSVSaturation(int argb, float saturation) {
        return Color.ofHSV(Color.getHue(argb), saturation, Color.getValue(argb), Color.getAlphaF(argb));
    }

    public static int withValue(int argb, float value) {
        return Color.ofHSV(Color.getHue(argb), Color.getHSVSaturation(argb), value, Color.getAlphaF(argb));
    }

    public static int withHSLHue(int argb, float hue) {
        return Color.ofHSL(hue, Color.getHSLSaturation(argb), Color.getLightness(argb), Color.getAlphaF(argb));
    }

    public static int withHSLSaturation(int argb, float saturation) {
        return Color.ofHSL(Color.getHue(argb), saturation, Color.getLightness(argb), Color.getAlphaF(argb));
    }

    public static int withLightness(int argb, float lightness) {
        return Color.ofHSL(Color.getHue(argb), Color.getHSLSaturation(argb), lightness, Color.getAlphaF(argb));
    }

    public static float getCyan(int argb) {
        float b;
        float g;
        float r = Color.getRedF(argb);
        float oneMinusBlack = Math.max(r, Math.max(g = Color.getGreenF(argb), b = Color.getBlueF(argb)));
        return oneMinusBlack == 0.0f ? 0.0f : 1.0f - r / oneMinusBlack;
    }

    public static float getMagenta(int argb) {
        float b;
        float g;
        float r = Color.getRedF(argb);
        float oneMinusBlack = Math.max(r, Math.max(g = Color.getGreenF(argb), b = Color.getBlueF(argb)));
        return oneMinusBlack == 0.0f ? 0.0f : 1.0f - g / oneMinusBlack;
    }

    public static float getYellow(int argb) {
        float b;
        float g;
        float r = Color.getRedF(argb);
        float oneMinusBlack = Math.max(r, Math.max(g = Color.getGreenF(argb), b = Color.getBlueF(argb)));
        return oneMinusBlack == 0.0f ? 0.0f : 1.0f - b / oneMinusBlack;
    }

    public static float getBlack(int argb) {
        float r = Color.getRedF(argb);
        float g = Color.getGreenF(argb);
        float b = Color.getBlueF(argb);
        return 1.0f - Math.max(r, Math.max(g, b));
    }

    public static int withCyan(int argb, float cyan) {
        return Color.ofCMYK(cyan, Color.getMagenta(argb), Color.getYellow(argb), Color.getBlack(argb), Color.getAlphaF(argb));
    }

    public static int withMagenta(int argb, float magenta) {
        return Color.ofCMYK(Color.getCyan(argb), magenta, Color.getYellow(argb), Color.getBlack(argb), Color.getAlphaF(argb));
    }

    public static int withYellow(int argb, float yellow) {
        return Color.ofCMYK(Color.getCyan(argb), Color.getMagenta(argb), yellow, Color.getBlack(argb), Color.getAlphaF(argb));
    }

    public static int withBlack(int argb, float black) {
        return Color.ofCMYK(Color.getCyan(argb), Color.getMagenta(argb), Color.getYellow(argb), black, Color.getAlphaF(argb));
    }

    public static int[] getRGBValues(int argb) {
        return new int[]{Color.getRed(argb), Color.getGreen(argb), Color.getBlue(argb)};
    }

    public static int[] getARGBValues(int argb) {
        return new int[]{Color.getRed(argb), Color.getGreen(argb), Color.getBlue(argb), Color.getAlpha(argb)};
    }

    public static float[] getHSVValues(int argb) {
        return new float[]{Color.getHue(argb), Color.getHSVSaturation(argb), Color.getValue(argb)};
    }

    public static float[] getHSLValues(int argb) {
        return new float[]{Color.getHue(argb), Color.getHSLSaturation(argb), Color.getLightness(argb)};
    }

    public static float[] getCMYKValues(int argb) {
        return new float[]{Color.getCyan(argb), Color.getMagenta(argb), Color.getYellow(argb), Color.getBlack(argb)};
    }

    public static float getLuminance(int argb) {
        float r = Color.getRedF(argb);
        float g = Color.getGreenF(argb);
        float b = Color.getBlueF(argb);
        return MathUtils.sqrt(0.299f * r * r + 0.587f * g * g + 0.114f * b * b);
    }

    public static int rgbaToArgb(int rgba) {
        return Color.argb(Color.getAlpha(rgba), Color.getRed(rgba), Color.getGreen(rgba), Color.getBlue(rgba));
    }

    public static int argbToRgba(int argb) {
        return Color.argb(Color.getGreen(argb), Color.getBlue(argb), Color.getAlpha(argb), Color.getRed(argb));
    }

    public static int invert(int argb) {
        return Color.argb(255 - Color.getRed(argb), 255 - Color.getGreen(argb), 255 - Color.getBlue(argb), Color.getAlpha(argb));
    }

    public static int multiply(int argb, float factor, boolean multiplyAlpha) {
        return Color.argb(Color.getRedF(argb) * factor, Color.getGreenF(argb) * factor, Color.getBlueF(argb) * factor, multiplyAlpha ? Color.getAlphaF(argb) * factor : Color.getAlphaF(argb));
    }

    public static int mix(int argb1, int argb2) {
        return Color.argb(Color.getRedF(argb1) * Color.getRedF(argb2), Color.getGreenF(argb1) * Color.getGreenF(argb2), Color.getBlueF(argb1) * Color.getBlueF(argb2), Color.getAlphaF(argb1) * Color.getAlphaF(argb2));
    }

    public static int average(int ... colors) {
        float r = 0.0f;
        float g = 0.0f;
        float b = 0.0f;
        int a = 0;
        for (int color : colors) {
            r += (float)Color.getRedSq(color);
            g += (float)Color.getGreenSq(color);
            b += (float)Color.getBlueSq(color);
            a += Color.getAlpha(color);
        }
        return Color.argb((int)MathUtils.sqrt(r / (float)colors.length), (int)MathUtils.sqrt(g / (float)colors.length), (int)MathUtils.sqrt(b / (float)colors.length), a / colors.length);
    }

    @SafeVarargs
    public static <T> int average(ToIntFunction<T> colorFunction, T ... colorHolders) {
        float r = 0.0f;
        float g = 0.0f;
        float b = 0.0f;
        float a = 0.0f;
        for (T colorHolder : colorHolders) {
            int color = colorFunction.applyAsInt(colorHolder);
            r += (float)Color.getRedSq(color);
            g += (float)Color.getGreenSq(color);
            b += (float)Color.getBlueSq(color);
            a += (float)Color.getAlpha(color);
        }
        return Color.argb((float)((int)MathUtils.sqrt(r / (float)colorHolders.length)), (float)((int)MathUtils.sqrt(g / (float)colorHolders.length)), (float)((int)MathUtils.sqrt(b / (float)colorHolders.length)), a / (float)colorHolders.length);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="3.2.0")
    public static int interpolate(int color1, int color2, float value) {
        return Color.lerp(color1, color2, value);
    }

    public static int average(int argb1, int argb2) {
        return Color.lerp(argb1, argb2, 0.5f);
    }

    public static int lerp(int argb1, int argb2, float value) {
        return Color.interpolate(Interpolation.LINEAR, argb1, argb2, value);
    }

    public static int interpolate(IInterpolation curve, int color1, int color2, float value) {
        value = MathUtils.clamp(value, 0.0f, 1.0f);
        int r = (int)Color.lerpComp(curve, Color.getRed(color1), Color.getRed(color2), value);
        int g = (int)Color.lerpComp(curve, Color.getGreen(color1), Color.getGreen(color2), value);
        int b = (int)Color.lerpComp(curve, Color.getBlue(color1), Color.getBlue(color2), value);
        int a = (int)Color.lerpComp(curve, Color.getAlpha(color1), Color.getAlpha(color2), value);
        return Color.argb(r, g, b, a);
    }

    public static float lerpComp(IInterpolation curve, float a, float b, float v) {
        return MathUtils.sqrt(curve.interpolate(a * a, b * b, v));
    }

    @SideOnly(value=Side.CLIENT)
    public static void setGlColor(int color) {
        if (color == 0) {
            GlStateManager.color((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
            return;
        }
        float a = Color.getAlphaF(color);
        if (a == 0.0f) {
            a = 1.0f;
        }
        GlStateManager.color((float)Color.getRedF(color), (float)Color.getGreenF(color), (float)Color.getBlueF(color), (float)a);
    }

    @SideOnly(value=Side.CLIENT)
    public static void setGlColorOpaque(int color) {
        if (color == 0) {
            GlStateManager.color((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
            return;
        }
        GlStateManager.color((float)Color.getRedF(color), (float)Color.getGreenF(color), (float)Color.getBlueF(color), (float)1.0f);
    }

    @SideOnly(value=Side.CLIENT)
    public static void resetGlColor() {
        GlStateManager.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        Color.setGlColorOpaque(Color.WHITE.main);
    }

    public static String rgbToFullHexString(int rgb) {
        return Color.toFullHexString(Color.getRed(rgb), Color.getGreen(rgb), Color.getBlue(rgb));
    }

    public static String argbToFullHexString(int argb) {
        return Color.toFullHexString(Color.getRed(argb), Color.getGreen(argb), Color.getBlue(argb), Color.getAlpha(argb));
    }

    public static String toFullHexString(int r, int g, int b) {
        return Color.componentToFullHexString(r) + Color.componentToFullHexString(g) + Color.componentToFullHexString(b);
    }

    public static String toFullHexString(int r, int g, int b, int a) {
        return Color.componentToFullHexString(a) + Color.toFullHexString(r, g, b);
    }

    public static String componentToFullHexString(int component) {
        if ((component &= 0xFF) == 0) {
            return "00";
        }
        if (component == 255) {
            return "FF";
        }
        String s = Integer.toHexString(component).toUpperCase(Locale.ENGLISH);
        if (s.length() == 1) {
            s = "0" + s;
        }
        return s;
    }

    public static int ofJson(JsonElement jsonElement) {
        if (jsonElement.isJsonPrimitive()) {
            ColorShade colorShade;
            String colorString = jsonElement.getAsString();
            if (colorString.isEmpty()) {
                return Color.WHITE.main;
            }
            char c = colorString.charAt(0);
            if (Character.isDigit(c) || c == '-' || c == '#') {
                int color = (int)Long.decode(colorString).longValue();
                if (color != 0 && Color.getAlpha(color) == 0) {
                    return Color.withAlpha(color, 255);
                }
                return color;
            }
            if ("invisible".equals(jsonElement.getAsString())) {
                return Color.withAlpha(Color.WHITE.main, 0);
            }
            int i = colorString.indexOf(58);
            int index = 0;
            if (i > 0) {
                try {
                    index = Integer.parseInt(colorString.substring(i + 1));
                }
                catch (NumberFormatException e) {
                    ModularUI.LOGGER.error("[THEME] If the color is a word, then after the : must come a negative or positive integer, but got '{}'", (Object)colorString.substring(i + 1));
                }
                colorString = colorString.substring(0, i);
            }
            if ((colorShade = ColorShade.getFromName(colorString)) != null) {
                if (index == 0) {
                    return colorShade.main;
                }
                if (index > 0) {
                    return colorShade.brighterSafe(index - 1);
                }
                return colorShade.darkerSafe(-index - 1);
            }
            ModularUI.LOGGER.error("[THEME] No color shade for name '{}' was found", (Object)colorString);
            return Color.WHITE.main;
        }
        if (jsonElement.isJsonObject()) {
            int alpha;
            float alphaF;
            JsonObject json = jsonElement.getAsJsonObject();
            String alphaS = JsonHelper.getString(json, "1f", "a", "alpha");
            if (alphaS.contains(".") || alphaS.endsWith("f") || alphaS.endsWith("F") || alphaS.endsWith("d") || alphaS.endsWith("D")) {
                try {
                    alphaF = MathUtils.clamp(Float.parseFloat(alphaS), 0.0f, 1.0f);
                    alpha = (int)(alphaF * 255.0f);
                }
                catch (NumberFormatException e) {
                    throw new JsonParseException("Failed to parse alpha value", (Throwable)e);
                }
            }
            try {
                alpha = MathUtils.clamp(Integer.parseInt(alphaS), 0, 255);
                alphaF = (float)alpha / 255.0f;
            }
            catch (NumberFormatException e) {
                throw new JsonParseException("Failed to parse alpha value", (Throwable)e);
            }
            if (Color.hasRGB(json)) {
                int blue;
                int green;
                if (Color.hasHS(json) || Color.hasV(json) || Color.hasL(json)) {
                    throw new JsonParseException("Found RGB values, but also HSV or HSL values!");
                }
                if (Color.hasCMYK(json)) {
                    throw new JsonParseException("Found RGB values, but also CMYK values!");
                }
                int red = JsonHelper.getInt(json, 255, "r", "red");
                if ((red | (green = JsonHelper.getInt(json, 255, "g", "green")) | (blue = JsonHelper.getInt(json, 255, "b", "blue"))) != 0 && alpha == 0) {
                    alpha = 255;
                }
                return Color.argb(red, green, blue, alpha);
            }
            if (Color.hasHS(json)) {
                if (Color.hasCMYK(json)) {
                    throw new JsonParseException("Found HSV or HSL values, but also CMYK values!");
                }
                int hue = JsonHelper.getInt(json, 0, "h", "hue");
                float saturation = JsonHelper.getFloat(json, 0.0f, "s", "saturation");
                if (Color.hasV(json)) {
                    if (Color.hasL(json)) {
                        throw new JsonParseException("Found HSV values, but also HSL values!");
                    }
                    float value = JsonHelper.getFloat(json, 1.0f, "v", "value");
                    return Color.ofHSV(hue, saturation, value, alphaF);
                }
                float lightness = JsonHelper.getFloat(json, 0.5f, "l", "lightness");
                return Color.ofHSL(hue, saturation, lightness, alphaF);
            }
            if (Color.hasCMYK(json)) {
                float c = JsonHelper.getFloat(json, 1.0f, "c", "cyan");
                float m = JsonHelper.getFloat(json, 1.0f, "m", "magenta");
                float y = JsonHelper.getFloat(json, 1.0f, "y", "yellow");
                float k = JsonHelper.getFloat(json, 1.0f, "k", "black");
                return Color.ofCMYK(c, m, y, k, alphaF);
            }
            throw new JsonParseException("Empty color declaration");
        }
        throw new JsonParseException("Color must be a primitive or an object!");
    }

    private static boolean hasRGB(JsonObject json) {
        return json.has("r") || json.has("red") || json.has("g") || json.has("green") || json.has("b") || json.has("blue");
    }

    private static boolean hasHS(JsonObject json) {
        return json.has("h") || json.has("hue") || json.has("s") || json.has("saturation");
    }

    private static boolean hasV(JsonObject json) {
        return json.has("v") || json.has("value");
    }

    private static boolean hasL(JsonObject json) {
        return json.has("l") || json.has("lightness");
    }

    private static boolean hasCMYK(JsonObject json) {
        return json.has("c") || json.has("cyan") || json.has("m") || json.has("magenta") || json.has("y") || json.has("yellow") || json.has("k") || json.has("black");
    }
}

