/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.utils;

public enum SIPrefix {
    Quetta('Q', 30),
    Ronna('R', 27),
    Yotta('Y', 24),
    Zetta('Z', 21),
    Exa('E', 18),
    Peta('P', 15),
    Tera('T', 12),
    Giga('G', 9),
    Mega('M', 6),
    Kilo('k', 3),
    One('\u0000', 0),
    Milli('m', -3),
    Micro('\u00b5', -6),
    Nano('n', -9),
    Pico('p', -12),
    Femto('f', -15),
    Atto('a', -18),
    Zepto('z', -21),
    Yocto('y', -24),
    Ronto('r', -27),
    Quecto('q', -30);

    public final char symbol;
    public final String stringSymbol;
    public final double factor;
    public final double oneOverFactor;
    public static final SIPrefix[] HIGH;
    public static final SIPrefix[] LOW;

    private SIPrefix(char symbol, int powerOfTen) {
        this.symbol = symbol;
        this.stringSymbol = symbol != '\u0000' ? Character.toString(symbol) : "";
        this.factor = Math.pow(10.0, powerOfTen);
        this.oneOverFactor = 1.0 / this.factor;
    }

    public boolean isOne() {
        return this == One;
    }

    static {
        HIGH = new SIPrefix[SIPrefix.values().length / 2];
        LOW = new SIPrefix[SIPrefix.values().length / 2];
        SIPrefix[] values = SIPrefix.values();
        for (int i = 0; i < HIGH.length; ++i) {
            SIPrefix.HIGH[i] = values[HIGH.length - 1 - i];
            SIPrefix.LOW[i] = values[HIGH.length + 1 + i];
        }
    }
}

