/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.value;

import com.cleanroommc.modularui.api.value.IValue;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jetbrains.annotations.ApiStatus;

public class ObjectValue<T>
implements IValue<T> {
    private final Class<T> type;
    private T value;

    public static <T> Dynamic<T> wrap(IValue<T> val) {
        return new Dynamic<Object>(val::getValue, val::setValue);
    }

    public static <T> Dynamic<T> wrapAtomic(AtomicReference<T> val) {
        return new Dynamic<Object>(val::get, val::set);
    }

    public ObjectValue(Class<T> type, T value) {
        this.type = type;
        this.value = value;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="3.2.0")
    public ObjectValue(T value) {
        this.type = value != null ? value.getClass() : null;
        this.value = value;
    }

    @Override
    public T getValue() {
        return this.value;
    }

    @Override
    public void setValue(T value) {
        this.value = value;
    }

    @Override
    public Class<T> getValueType() {
        return this.type != null ? this.type : this.value.getClass();
    }

    public static class Dynamic<T>
    implements IValue<T> {
        private final Class<T> type;
        private final Supplier<T> getter;
        private final Consumer<T> setter;

        public Dynamic(Class<T> type, Supplier<T> getter, Consumer<T> setter) {
            this.type = type;
            this.getter = getter;
            this.setter = setter;
        }

        @Deprecated
        @ApiStatus.ScheduledForRemoval(inVersion="3.2.0")
        public Dynamic(Supplier<T> getter, Consumer<T> setter) {
            this.getter = getter;
            this.setter = setter;
            T value = getter.get();
            this.type = value != null ? value.getClass() : null;
        }

        @Override
        public T getValue() {
            return this.getter.get();
        }

        @Override
        public void setValue(T value) {
            this.setter.accept(value);
        }

        @Override
        public Class<T> getValueType() {
            return this.type != null ? this.type : this.getter.get().getClass();
        }
    }
}

