/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.value.sync;

import com.cleanroommc.modularui.utils.ICopy;
import com.cleanroommc.modularui.utils.serialization.ByteBufAdapters;
import com.cleanroommc.modularui.utils.serialization.IByteBufAdapter;
import com.cleanroommc.modularui.utils.serialization.IByteBufDeserializer;
import com.cleanroommc.modularui.utils.serialization.IByteBufSerializer;
import com.cleanroommc.modularui.utils.serialization.IEquals;
import com.cleanroommc.modularui.value.sync.AbstractGenericSyncValue;
import java.io.IOException;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GenericSyncValue<T>
extends AbstractGenericSyncValue<T> {
    private final IByteBufDeserializer<T> deserializer;
    private final IByteBufSerializer<T> serializer;
    private final IEquals<T> equals;
    private final ICopy<T> copy;

    public static GenericSyncValue<ItemStack> forItem(@NotNull Supplier<ItemStack> getter, @Nullable Consumer<ItemStack> setter) {
        return new GenericSyncValue<ItemStack>(getter, setter, ByteBufAdapters.ITEM_STACK);
    }

    public static GenericSyncValue<FluidStack> forFluid(@NotNull Supplier<FluidStack> getter, @Nullable Consumer<FluidStack> setter) {
        return new GenericSyncValue<FluidStack>(getter, setter, ByteBufAdapters.FLUID_STACK);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="3.2.0")
    public GenericSyncValue(@NotNull Supplier<T> getter, @Nullable Consumer<T> setter, @NotNull IByteBufAdapter<T> adapter) {
        this(getter, setter, adapter, adapter, adapter, null);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="3.2.0")
    public GenericSyncValue(@NotNull Supplier<T> getter, @Nullable Consumer<T> setter, @NotNull IByteBufAdapter<T> adapter, @Nullable ICopy<T> copy) {
        this(getter, setter, adapter, adapter, adapter, copy);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="3.2.0")
    public GenericSyncValue(@NotNull Supplier<T> getter, @Nullable Consumer<T> setter, @NotNull IByteBufDeserializer<T> deserializer, @NotNull IByteBufSerializer<T> serializer) {
        this(getter, setter, deserializer, serializer, null, null);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="3.2.0")
    public GenericSyncValue(@NotNull Supplier<T> getter, @Nullable Consumer<T> setter, @NotNull IByteBufDeserializer<T> deserializer, @NotNull IByteBufSerializer<T> serializer, @Nullable ICopy<T> copy) {
        this(getter, setter, deserializer, serializer, null, copy);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="3.2.0")
    public GenericSyncValue(@NotNull Supplier<T> getter, @NotNull IByteBufAdapter<T> adapter) {
        this(getter, null, adapter, adapter, adapter, null);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="3.2.0")
    public GenericSyncValue(@NotNull Supplier<T> getter, @NotNull IByteBufAdapter<T> adapter, @Nullable ICopy<T> copy) {
        this(getter, null, adapter, adapter, adapter, copy);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="3.2.0")
    public GenericSyncValue(@NotNull Supplier<T> getter, @NotNull IByteBufDeserializer<T> deserializer, @NotNull IByteBufSerializer<T> serializer) {
        this(getter, null, deserializer, serializer, null, null);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="3.2.0")
    public GenericSyncValue(@NotNull Supplier<T> getter, @NotNull IByteBufDeserializer<T> deserializer, @NotNull IByteBufSerializer<T> serializer, @Nullable ICopy<T> copy) {
        this(getter, null, deserializer, serializer, null, copy);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="3.2.0")
    public GenericSyncValue(@NotNull Supplier<T> getter, @Nullable Consumer<T> setter, @NotNull IByteBufDeserializer<T> deserializer, @NotNull IByteBufSerializer<T> serializer, @Nullable IEquals<T> equals, @Nullable ICopy<T> copy) {
        this(null, getter, setter, deserializer, serializer, equals, copy);
    }

    public GenericSyncValue(@NotNull Class<T> type, @NotNull Supplier<T> getter, @Nullable Consumer<T> setter, @NotNull IByteBufAdapter<T> adapter, @Nullable ICopy<T> copy) {
        this(type, getter, setter, adapter, adapter, adapter, copy);
    }

    public GenericSyncValue(@NotNull Class<T> type, @NotNull Supplier<T> getter, @Nullable Consumer<T> setter, @NotNull IByteBufAdapter<T> adapter) {
        this(type, getter, setter, adapter, adapter, adapter, null);
    }

    public GenericSyncValue(@NotNull Class<T> type, @NotNull Supplier<T> getter, @Nullable Consumer<T> setter, @NotNull IByteBufDeserializer<T> deserializer, @NotNull IByteBufSerializer<T> serializer, @Nullable IEquals<T> equals, @Nullable ICopy<T> copy) {
        super(type, getter, setter);
        this.deserializer = Objects.requireNonNull(deserializer);
        this.serializer = Objects.requireNonNull(serializer);
        this.equals = equals == null ? Objects::equals : IEquals.wrapNullSafe(equals);
        this.copy = copy == null ? ICopy.ofSerializer(serializer, deserializer) : copy;
    }

    @Override
    protected T createDeepCopyOf(T value) {
        return this.copy.createDeepCopy(value);
    }

    @Override
    protected boolean areEqual(T a, T b) {
        return this.equals.areEqual(a, b);
    }

    @Override
    protected void serialize(PacketBuffer buffer, T value) throws IOException {
        this.serializer.serialize(buffer, value);
    }

    @Override
    protected T deserialize(PacketBuffer buffer) throws IOException {
        return this.deserializer.deserialize(buffer);
    }

    @Override
    public <V> GenericSyncValue<V> cast() {
        return this;
    }

    public static class Builder<T> {
        private final Class<T> type;
        private Supplier<T> getter;
        private Consumer<T> setter;
        private IByteBufDeserializer<T> deserializer;
        private IByteBufSerializer<T> serializer;
        private IEquals<T> equals;
        private ICopy<T> copy;

        public Builder(Class<T> type) {
            this.type = type;
        }

        public Builder<T> getter(Supplier<T> getter) {
            this.getter = getter;
            return this;
        }

        public Builder<T> setter(Consumer<T> setter) {
            this.setter = setter;
            return this;
        }

        public Builder<T> deserializer(IByteBufDeserializer<T> deserializer) {
            this.deserializer = deserializer;
            return this;
        }

        public Builder<T> serializer(IByteBufSerializer<T> serializer) {
            this.serializer = serializer;
            return this;
        }

        public Builder<T> equals(IEquals<T> equals) {
            this.equals = equals;
            return this;
        }

        public Builder<T> equalsDefault() {
            return this.equals(IEquals.defaultTester());
        }

        public Builder<T> equalsReference() {
            return this.equals((T a, T b) -> a == b);
        }

        public Builder<T> copy(ICopy<T> copy) {
            this.copy = copy;
            return this;
        }

        public Builder<T> copyImmutable() {
            return this.copy(ICopy.immutable());
        }

        public Builder<T> adapter(IByteBufAdapter<T> adapter) {
            return this.deserializer(adapter).serializer(adapter).equals(adapter);
        }

        public GenericSyncValue<T> build() {
            return new GenericSyncValue<T>(this.type, this.getter, this.setter, this.deserializer, this.serializer, this.equals, this.copy);
        }
    }
}

