/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.value.sync;

import com.cleanroommc.modularui.api.IPacketWriter;
import com.cleanroommc.modularui.api.value.ISyncOrValue;
import com.cleanroommc.modularui.network.NetworkHandler;
import com.cleanroommc.modularui.network.packets.PacketSyncHandler;
import com.cleanroommc.modularui.value.sync.PanelSyncManager;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.util.Objects;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.MustBeInvokedByOverriders;
import org.jetbrains.annotations.NotNull;

public abstract class SyncHandler
implements ISyncOrValue {
    private PanelSyncManager syncManager;
    private String key;

    @ApiStatus.OverrideOnly
    @MustBeInvokedByOverriders
    public void init(String key, PanelSyncManager syncManager) {
        this.key = key;
        this.syncManager = syncManager;
    }

    @ApiStatus.OverrideOnly
    @MustBeInvokedByOverriders
    public void dispose() {
        this.key = null;
        this.syncManager = null;
    }

    public final void syncToClient(int id, @NotNull IPacketWriter bufferConsumer) {
        PacketBuffer buffer = new PacketBuffer(Unpooled.buffer());
        buffer.writeVarInt(id);
        try {
            bufferConsumer.write(buffer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        SyncHandler.sendToClient(this.getSyncManager().getPanelName(), buffer, this);
    }

    @SideOnly(value=Side.CLIENT)
    public final void syncToServer(int id, @NotNull IPacketWriter bufferConsumer) {
        PacketBuffer buffer = new PacketBuffer(Unpooled.buffer());
        buffer.writeVarInt(id);
        try {
            bufferConsumer.write(buffer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        SyncHandler.sendToServer(this.getSyncManager().getPanelName(), buffer, this);
    }

    public final void sync(int id, @NotNull IPacketWriter bufferConsumer) {
        PacketBuffer buffer = new PacketBuffer(Unpooled.buffer());
        buffer.writeVarInt(id);
        try {
            bufferConsumer.write(buffer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (this.getSyncManager().isClient()) {
            SyncHandler.sendToServer(this.getSyncManager().getPanelName(), buffer, this);
        } else {
            SyncHandler.sendToClient(this.getSyncManager().getPanelName(), buffer, this);
        }
    }

    public final void syncToClient(int id) {
        this.syncToClient(id, buf -> {});
    }

    public final void syncToServer(int id) {
        this.syncToServer(id, buf -> {});
    }

    public final void sync(int id) {
        this.sync(id, buf -> {});
    }

    @SideOnly(value=Side.CLIENT)
    @ApiStatus.OverrideOnly
    public abstract void readOnClient(int var1, PacketBuffer var2) throws IOException;

    @ApiStatus.OverrideOnly
    public abstract void readOnServer(int var1, PacketBuffer var2) throws IOException;

    public void detectAndSendChanges(boolean init) {
    }

    public final String getKey() {
        return this.key;
    }

    public final boolean isValid() {
        return this.key != null && this.syncManager != null;
    }

    public PanelSyncManager getSyncManager() {
        if (!this.isValid()) {
            throw new IllegalStateException("Sync handler is not yet initialised!");
        }
        return this.syncManager;
    }

    @Override
    public boolean isSyncHandler() {
        return true;
    }

    public static void sendToClient(String panel, PacketBuffer buffer, SyncHandler syncHandler) {
        Objects.requireNonNull(buffer);
        Objects.requireNonNull(syncHandler);
        if (!syncHandler.isValid()) {
            throw new IllegalStateException();
        }
        NetworkHandler.sendToPlayer(new PacketSyncHandler(panel, syncHandler.getKey(), false, buffer), (EntityPlayerMP)syncHandler.syncManager.getPlayer());
    }

    public static void sendToServer(String panel, PacketBuffer buffer, SyncHandler syncHandler) {
        Objects.requireNonNull(buffer);
        Objects.requireNonNull(syncHandler);
        if (!syncHandler.isValid()) {
            throw new IllegalStateException();
        }
        NetworkHandler.sendToServer(new PacketSyncHandler(panel, syncHandler.getKey(), false, buffer));
    }
}

