/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.widget;

import com.cleanroommc.modularui.api.GuiAxis;
import com.cleanroommc.modularui.api.layout.ILayoutWidget;
import com.cleanroommc.modularui.api.layout.IResizeable;
import com.cleanroommc.modularui.api.layout.IViewport;
import com.cleanroommc.modularui.api.widget.IWidget;
import com.cleanroommc.modularui.screen.viewport.ModularGuiContext;
import com.cleanroommc.modularui.theme.WidgetThemeEntry;
import com.cleanroommc.modularui.widget.WidgetTree;
import com.cleanroommc.modularui.widgets.layout.IExpander;
import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.function.Predicate;
import net.minecraft.client.renderer.GlStateManager;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;

@ApiStatus.Internal
class InternalWidgetTree {
    InternalWidgetTree() {
    }

    @Contract(value="_,_,_,_,false -> !null")
    static <T extends IWidget> T findChildAt(IWidget parent, Class<T> type, String[] path, int index, boolean nullable) {
        String current = path[index];
        boolean isLast = index == path.length - 1;
        for (IWidget widget : parent.getChildren()) {
            if (!widget.isName(current)) continue;
            if (isLast) {
                if (!widget.isType(type)) {
                    throw new ClassCastException("Found widget at '" + Joiner.on((char)'/').join((Object[])Arrays.copyOfRange(path, 0, index + 1)) + "' with type '" + widget.getClass().getName() + "', but expected type '" + type.getName() + "'.");
                }
                return (T)widget;
            }
            T result = InternalWidgetTree.findChildAt(widget, type, path, index + 1, nullable);
            if (result == null) continue;
            return result;
        }
        if (!nullable) {
            throw new NoSuchElementException("Expected to find widget at '" + Joiner.on((char)'/').join((Object[])Arrays.copyOfRange(path, 0, index + 1)) + "', but none was found.");
        }
        return null;
    }

    static void drawTree(IWidget parent, ModularGuiContext context, boolean ignoreEnabled, boolean drawBackground) {
        if (!parent.isEnabled() && !ignoreEnabled) {
            return;
        }
        if (parent.requiresResize()) {
            WidgetTree.resizeInternal(parent, false);
        }
        float alpha = parent.getPanel().getAlpha();
        IViewport viewport = parent instanceof IViewport ? (IViewport)parent : null;
        context.pushMatrix();
        parent.transform(context);
        boolean canBeSeen = parent.canBeSeen(context);
        GlStateManager.pushMatrix();
        context.applyToOpenGl();
        GlStateManager.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        if (canBeSeen) {
            GlStateManager.color((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
            WidgetThemeEntry<?> widgetTheme = parent.getWidgetTheme(context.getTheme());
            if (drawBackground) {
                parent.drawBackground(context, widgetTheme);
            }
            parent.draw(context, widgetTheme);
            parent.drawOverlay(context, widgetTheme);
        }
        if (viewport != null) {
            if (canBeSeen) {
                GlStateManager.color((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
                viewport.preDraw(context, false);
                GlStateManager.popMatrix();
                context.pushViewport(viewport, parent.getArea());
                viewport.transformChildren(context);
                GlStateManager.pushMatrix();
                context.applyToOpenGl();
                viewport.preDraw(context, true);
            } else {
                context.pushViewport(viewport, parent.getArea());
                viewport.transformChildren(context);
            }
        }
        GlStateManager.popMatrix();
        List<IWidget> children = parent.getChildren();
        if (!children.isEmpty()) {
            boolean backgroundSeparate;
            boolean bl = backgroundSeparate = children.size() > 1;
            if (backgroundSeparate) {
                children.forEach(widget -> InternalWidgetTree.drawBackground(widget, context, ignoreEnabled));
            }
            children.forEach(widget -> InternalWidgetTree.drawTree(widget, context, false, !backgroundSeparate));
        }
        if (viewport != null) {
            if (canBeSeen) {
                GlStateManager.color((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
                GlStateManager.pushMatrix();
                context.applyToOpenGl();
                viewport.postDraw(context, true);
                context.popViewport(viewport);
                GlStateManager.popMatrix();
                GlStateManager.pushMatrix();
                context.applyToOpenGl();
                viewport.postDraw(context, false);
                GlStateManager.popMatrix();
            } else {
                context.popViewport(viewport);
            }
        }
        context.popMatrix();
    }

    static void drawBackground(IWidget parent, ModularGuiContext context, boolean ignoreEnabled) {
        if (!parent.isEnabled() && !ignoreEnabled) {
            return;
        }
        float alpha = parent.getPanel().getAlpha();
        context.pushMatrix();
        parent.transform(context);
        boolean canBeSeen = parent.canBeSeen(context);
        if (!canBeSeen) {
            context.popMatrix();
            return;
        }
        GlStateManager.pushMatrix();
        context.applyToOpenGl();
        GlStateManager.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        GlStateManager.color((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        WidgetThemeEntry<?> widgetTheme = parent.getWidgetTheme(context.getTheme());
        parent.drawBackground(context, widgetTheme);
        GlStateManager.popMatrix();
        context.popMatrix();
    }

    static void drawTreeForeground(IWidget parent, ModularGuiContext context) {
        IViewport viewport1;
        IViewport viewport = parent instanceof IViewport ? (viewport1 = (IViewport)parent) : null;
        context.pushMatrix();
        parent.transform(context);
        GlStateManager.color((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.enableBlend();
        parent.drawForeground(context);
        List<IWidget> children = parent.getChildren();
        if (!children.isEmpty()) {
            if (viewport != null) {
                context.pushViewport(viewport, parent.getArea());
                viewport.transformChildren(context);
            }
            children.forEach(widget -> InternalWidgetTree.drawTreeForeground(widget, context));
            if (viewport != null) {
                context.popViewport(viewport);
            }
        }
        context.popMatrix();
    }

    static boolean resizeWidget(IWidget widget, boolean init, boolean onOpen, boolean isParentLayout) {
        boolean shouldLayout;
        GuiAxis guiAxis;
        boolean selfFullyCalculated;
        boolean isLayout;
        ILayoutWidget layoutWidget;
        boolean alreadyCalculated = false;
        IResizeable resizer = widget.resizer();
        ILayoutWidget layout = widget instanceof ILayoutWidget ? (layoutWidget = (ILayoutWidget)((Object)widget)) : null;
        boolean bl = isLayout = layout != null;
        if (init) {
            widget.beforeResize(onOpen);
            resizer.initResizing();
            if (!isLayout) {
                resizer.setLayoutDone(true);
            }
        } else {
            alreadyCalculated = resizer.isFullyCalculated(isParentLayout);
        }
        boolean bl2 = selfFullyCalculated = resizer.isSelfFullyCalculated() || resizer.resize(widget, isParentLayout);
        if (widget instanceof IExpander) {
            IExpander expander = (IExpander)((Object)widget);
            guiAxis = expander.getExpandAxis();
        } else {
            guiAxis = null;
        }
        GuiAxis expandAxis = guiAxis;
        List<IWidget> anotherResize = Collections.emptyList();
        if (!resizer.areChildrenCalculated() && widget.hasChildren()) {
            anotherResize = new ArrayList();
            for (IWidget child : widget.getChildren()) {
                if (init) {
                    child.flex().checkExpanded(expandAxis);
                }
                if (InternalWidgetTree.resizeWidget(child, init, onOpen, isLayout)) continue;
                anotherResize.add(child);
            }
        }
        boolean bl3 = shouldLayout = init || !resizer.areChildrenCalculated() || !resizer.isLayoutDone();
        if (shouldLayout || !selfFullyCalculated) {
            boolean layoutSuccessful = true;
            BitSet state = InternalWidgetTree.getCalculatedState(anotherResize, isLayout);
            if (layout != null && shouldLayout) {
                layoutSuccessful = layout.layoutWidgets();
            }
            resizer.postResize(widget);
            if (layout != null && shouldLayout) {
                layoutSuccessful &= layout.postLayoutWidgets();
            }
            if (shouldLayout) {
                resizer.setLayoutDone(layoutSuccessful);
            }
            InternalWidgetTree.checkFullyCalculated(anotherResize, state, isLayout);
        }
        if (!anotherResize.isEmpty()) {
            for (int i = 0; i < anotherResize.size(); ++i) {
                if (!InternalWidgetTree.resizeWidget(anotherResize.get(i), false, onOpen, isLayout)) continue;
                anotherResize.remove(i--);
            }
        }
        resizer.setChildrenResized(anotherResize.isEmpty());
        selfFullyCalculated = resizer.isFullyCalculated(isParentLayout);
        if (selfFullyCalculated && !alreadyCalculated) {
            widget.onResized();
        }
        return selfFullyCalculated;
    }

    private static BitSet getCalculatedState(List<IWidget> children, boolean isLayout) {
        if (children.isEmpty()) {
            return null;
        }
        BitSet state = new BitSet();
        for (int i = 0; i < children.size(); ++i) {
            IWidget widget = children.get(i);
            if (!widget.resizer().isFullyCalculated(isLayout)) continue;
            state.set(i);
        }
        return state;
    }

    private static void checkFullyCalculated(List<IWidget> children, BitSet state, boolean isLayout) {
        if (children.isEmpty() || state == null) {
            return;
        }
        int j = 0;
        for (int i = 0; i < children.size(); ++i) {
            IWidget widget = children.get(i);
            if (!state.get(j) && widget.resizer().isFullyCalculated(isLayout)) {
                widget.onResized();
                state.set(j);
                children.remove(i--);
            }
            ++j;
        }
    }

    static void getTree(IWidget root, IWidget parent, Predicate<IWidget> test, StringBuilder builder, WidgetTree.WidgetInfo additionalInfo, String indent, boolean hasNextSibling) {
        if (!indent.isEmpty()) {
            builder.append(indent).append(hasNextSibling ? "\u251c " : "\u2514 ");
        }
        builder.append(parent);
        if (additionalInfo != null) {
            builder.append(" {");
            additionalInfo.addInfo(root, parent, builder);
            builder.append("}");
        }
        builder.append('\n');
        if (parent.hasChildren()) {
            List<IWidget> children = parent.getChildren();
            for (int i = 0; i < children.size(); ++i) {
                IWidget child = children.get(i);
                if (!test.test(child)) continue;
                InternalWidgetTree.getTree(root, child, test, builder, additionalInfo, indent + (hasNextSibling ? "\u2502 " : "  "), i < children.size() - 1);
            }
        }
    }
}

