/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.widget.scroll;

import com.cleanroommc.modularui.api.GuiAxis;
import com.cleanroommc.modularui.api.drawable.IDrawable;
import com.cleanroommc.modularui.drawable.GuiDraw;
import com.cleanroommc.modularui.screen.viewport.ModularGuiContext;
import com.cleanroommc.modularui.theme.WidgetTheme;
import com.cleanroommc.modularui.widget.scroll.ScrollArea;
import com.cleanroommc.modularui.widget.scroll.ScrollData;
import com.cleanroommc.modularui.widget.scroll.VerticalScrollData;

public class HorizontalScrollData
extends ScrollData {
    public HorizontalScrollData() {
        this(false, -1);
    }

    public HorizontalScrollData(boolean topAlignment) {
        this(topAlignment, -1);
    }

    public HorizontalScrollData(boolean topAlignment, int thickness) {
        super(GuiAxis.X, topAlignment, thickness);
    }

    public HorizontalScrollData cancelScrollEdge(boolean cancelScrollEdge) {
        this.setCancelScrollEdge(cancelScrollEdge);
        return this;
    }

    @Override
    protected int getFallbackThickness(WidgetTheme widgetTheme) {
        return widgetTheme.getDefaultHeight();
    }

    @Override
    public VerticalScrollData getOtherScrollData(ScrollArea area) {
        return area.getScrollY();
    }

    @Override
    public boolean isInsideScrollbarArea(ScrollArea area, int x, int y) {
        if (!this.isScrollBarActive(area, false)) {
            return false;
        }
        int scrollbar = this.getThickness();
        VerticalScrollData data = this.getOtherScrollData(area);
        if (data != null && this.isOtherScrollBarActive(area, true)) {
            int thickness = data.getThickness();
            if (data.isOnAxisStart() ? x < thickness : x >= area.w() - thickness) {
                return false;
            }
        }
        return this.isOnAxisStart() ? y >= 0 && y < scrollbar : y >= area.h() - scrollbar && y < area.h();
    }

    @Override
    public void drawScrollbar(ScrollArea area, ModularGuiContext context, WidgetTheme widgetTheme, IDrawable texture) {
        boolean isOtherActive = this.isOtherScrollBarActive(area, true);
        int l = this.getScrollBarLength(area);
        int x = 0;
        int y = this.isOnAxisStart() ? 0 : area.height - this.getThickness();
        int w = area.width;
        int h = this.getThickness();
        GuiDraw.drawRect(x, y, w, h, area.getScrollBarBackgroundColor());
        x = this.getScrollBarStart(area, l, isOtherActive);
        VerticalScrollData data2 = this.getOtherScrollData(area);
        if (data2 != null && isOtherActive && data2.isOnAxisStart()) {
            x += data2.getThickness();
        }
        w = l;
        this.drawScrollBar(context, x, y, w, h, widgetTheme, texture);
    }
}

