/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.widget.sizer;

import com.cleanroommc.modularui.animation.IAnimatable;
import com.cleanroommc.modularui.api.GuiAxis;
import com.cleanroommc.modularui.api.layout.IViewportStack;
import com.cleanroommc.modularui.api.widget.IGuiElement;
import com.cleanroommc.modularui.utils.Interpolations;
import com.cleanroommc.modularui.utils.MathUtils;
import com.cleanroommc.modularui.widget.sizer.Box;
import com.cleanroommc.modularui.widget.sizer.IUnResizeable;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.util.Objects;
import org.jetbrains.annotations.ApiStatus;

public class Area
extends Rectangle
implements IUnResizeable,
IAnimatable<Area> {
    public static final Area SHARED = new Area();
    public static final Area ZERO = new Area();
    public int rx;
    public int ry;
    private int z;
    private final Box margin = new Box();
    private final Box padding = new Box();

    public static boolean isInside(int x, int y, int w, int h, int px, int py) {
        SHARED.set(x, y, w, h);
        return SHARED.isInside(px, py);
    }

    public Area() {
    }

    public Area(int x, int y, int w, int h) {
        super(x, y, w, h);
    }

    public Area(Rectangle rectangle) {
        super(rectangle);
    }

    public Area(Area area) {
        super(area);
        this.rx = area.rx;
        this.ry = area.ry;
        this.z = area.z;
        this.getMargin().set(area.getMargin());
        this.getPadding().set(area.getPadding());
    }

    public int x() {
        return this.x;
    }

    public void x(int x) {
        this.x = x;
    }

    public int y() {
        return this.y;
    }

    public void y(int y) {
        this.y = y;
    }

    public int w() {
        return this.width;
    }

    public void w(int w) {
        this.width = w;
    }

    public int h() {
        return this.height;
    }

    public void h(int h) {
        this.height = h;
    }

    public int ex() {
        return this.x + this.width;
    }

    public void ex(int ex) {
        this.x = ex - this.width;
    }

    public int ey() {
        return this.y + this.height;
    }

    public void ey(int ey) {
        this.y = ey - this.height;
    }

    public int mx() {
        return (int)((double)this.x + (double)this.width * 0.5);
    }

    public int my() {
        return (int)((double)this.y + (double)this.height * 0.5);
    }

    public int z() {
        return this.z;
    }

    public void z(int z) {
        this.z = z;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="3.2.0")
    public byte getPanelLayer() {
        return 0;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="3.2.0")
    public void setPanelLayer(byte panelLayer) {
    }

    public int x(float anchor) {
        return this.x + (int)((float)this.width * anchor);
    }

    public int y(float anchor) {
        return this.y + (int)((float)this.height * anchor);
    }

    public int getPoint(GuiAxis axis) {
        return axis.isHorizontal() ? this.x : this.y;
    }

    public int getEndPoint(GuiAxis axis) {
        return axis.isHorizontal() ? this.x + this.width : this.y + this.height;
    }

    public int getSize(GuiAxis axis) {
        return axis.isHorizontal() ? this.width : this.height;
    }

    public int getRelativePoint(GuiAxis axis) {
        return axis.isHorizontal() ? this.rx : this.ry;
    }

    public void setPoint(GuiAxis axis, int v) {
        if (axis.isHorizontal()) {
            this.x = v;
        } else {
            this.y = v;
        }
    }

    public void setSize(GuiAxis axis, int v) {
        if (axis.isHorizontal()) {
            this.width = v;
        } else {
            this.height = v;
        }
    }

    public void setRelativePoint(GuiAxis axis, int v) {
        if (axis.isHorizontal()) {
            this.rx = v;
        } else {
            this.ry = v;
        }
    }

    public void addPoint(GuiAxis axis, int v) {
        if (axis.isHorizontal()) {
            this.x += v;
        } else {
            this.y += v;
        }
    }

    public void addSize(GuiAxis axis, int v) {
        if (axis.isHorizontal()) {
            this.width += v;
        } else {
            this.height += v;
        }
    }

    public void addRelativePoint(GuiAxis axis, int v) {
        if (axis.isHorizontal()) {
            this.rx += v;
        } else {
            this.ry += v;
        }
    }

    void applyPos(int parentX, int parentY) {
        this.x = parentX + this.rx;
        this.y = parentY + this.ry;
    }

    public int requestedWidth() {
        return this.width + this.getMargin().horizontal();
    }

    public int paddedWidth() {
        return this.width - this.getPadding().horizontal();
    }

    public int requestedHeight() {
        return this.height + this.getMargin().vertical();
    }

    public int paddedHeight() {
        return this.height - this.getPadding().vertical();
    }

    public int requestedSize(GuiAxis axis) {
        return axis.isHorizontal() ? this.requestedWidth() : this.requestedHeight();
    }

    public int relativeEndX() {
        return this.rx + this.width;
    }

    public int relativeEndY() {
        return this.ry + this.height;
    }

    public boolean isInside(int x, int y) {
        return x >= this.x && x < this.x + this.width && y >= this.y && y < this.y + this.height;
    }

    @Override
    public boolean intersects(Rectangle2D area) {
        return (double)this.x < area.getX() + area.getWidth() && (double)this.y < area.getY() + area.getHeight() && area.getX() < (double)(this.x + this.width) && area.getY() < (double)(this.y + this.height);
    }

    public void clamp(Area area) {
        int x1 = area.x();
        int y1 = area.y();
        int x2 = area.ex();
        int y2 = area.ey();
        x1 = MathUtils.clamp(x1, this.x, this.ex());
        y1 = MathUtils.clamp(y1, this.y, this.ey());
        x2 = MathUtils.clamp(x2, this.x, this.ex());
        y2 = MathUtils.clamp(y2, this.y, this.ey());
        area.setPos(x1, y1, x2, y2);
    }

    public void expand(int expand) {
        this.expandX(expand);
        this.expandY(expand);
    }

    public void expand(int expandX, int expandY) {
        this.expandX(expandX);
        this.expandY(expandY);
    }

    public void expandX(int expand) {
        this.offsetX(-expand);
        this.growW(expand * 2);
    }

    public void expandY(int expand) {
        this.offsetY(-expand);
        this.growH(expand * 2);
    }

    public void offset(int offset) {
        this.offsetX(offset);
        this.offsetY(offset);
    }

    public void offset(int offsetX, int offsetY) {
        this.offsetX(offsetX);
        this.offsetY(offsetY);
    }

    public void offsetX(int offset) {
        this.x += offset;
    }

    public void offsetY(int offset) {
        this.y += offset;
    }

    public void grow(int grow) {
        this.growW(grow);
        this.growH(grow);
    }

    @Override
    public void grow(int growW, int growH) {
        this.growW(growW);
        this.growH(growH);
    }

    public void growW(int grow) {
        this.width += grow;
    }

    public void growH(int grow) {
        this.height += grow;
    }

    public void set(int x, int y, int w, int h) {
        this.setPos(x, y);
        this.setSize(w, h);
    }

    public void setPos(int x, int y) {
        this.x = x;
        this.y = y;
    }

    @Override
    public void setSize(int w, int h) {
        this.width = w;
        this.height = h;
    }

    public void setPos(Rectangle rectangle) {
        this.setPos(rectangle.x, rectangle.y);
    }

    public void setSize(Rectangle rectangle) {
        this.setSize(rectangle.width, rectangle.height);
    }

    public void setPos(int sx, int sy, int ex, int ey) {
        int x0 = Math.min(sx, ex);
        int y0 = Math.min(sy, ey);
        ex = Math.max(sx, ex);
        ey = Math.max(sy, ey);
        this.setPos(x0, y0);
        this.setSize(ex - x0, ey - y0);
    }

    public void reset() {
        this.x = 0;
        this.y = 0;
        this.width = 0;
        this.height = 0;
    }

    public void set(Rectangle area) {
        this.setBounds(area.x, area.y, area.width, area.height);
    }

    public void transformAndRectanglerize(IViewportStack stack) {
        int xTL = stack.transformX(this.x, this.y);
        int xTR = stack.transformX(this.ex(), this.y);
        int xBL = stack.transformX(this.x, this.ey());
        int xBR = stack.transformX(this.ex(), this.ey());
        int yTL = stack.transformY(this.x, this.y);
        int yTR = stack.transformY(this.ex(), this.y);
        int yBL = stack.transformY(this.x, this.ey());
        int yBR = stack.transformY(this.ex(), this.ey());
        int x0 = MathUtils.min(xTL, xTR, xBL, xBR);
        int x1 = MathUtils.max(xTL, xTR, xBL, xBR);
        int y0 = MathUtils.min(yTL, yTR, yBL, yBR);
        int y1 = MathUtils.max(yTL, yTR, yBL, yBR);
        this.setPos(x0, y0, x1, y1);
    }

    public Box getMargin() {
        return this.margin;
    }

    public Box getPadding() {
        return this.padding;
    }

    @Override
    public boolean resize(IGuiElement guiElement, boolean isParentLayout) {
        guiElement.getArea().set(this);
        return true;
    }

    @Override
    public Area getArea() {
        return this;
    }

    public Area createCopy() {
        return new Area(this);
    }

    @Override
    public String toString() {
        return "Area{x=" + this.x + ", y=" + this.y + ", width=" + this.width + ", height=" + this.height + '}';
    }

    @Override
    public Area interpolate(Area start, Area end, float t) {
        this.x = Interpolations.lerp(start.x, end.x, t);
        this.y = Interpolations.lerp(start.y, end.y, t);
        this.width = Interpolations.lerp(start.width, end.width, t);
        this.height = Interpolations.lerp(start.height, end.height, t);
        this.rx = Interpolations.lerp(start.rx, end.rx, t);
        this.ry = Interpolations.lerp(start.ry, end.ry, t);
        this.getMargin().interpolate(start.getMargin(), end.getMargin(), t);
        this.getPadding().interpolate(start.getPadding(), end.getPadding(), t);
        return this;
    }

    @Override
    public Area copyOrImmutable() {
        return this.createCopy();
    }

    @Override
    public boolean shouldAnimate(Area target) {
        return this.x != target.x || this.y != target.y || this.width != target.width || this.height != target.height || this.rx != target.rx || this.ry != target.ry || !this.getMargin().isEqual(target.getMargin()) || !this.getPadding().isEqual(target.getPadding());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Area area = (Area)o;
        return this.rx == area.rx && this.ry == area.ry && this.z == area.z && Objects.equals(this.getMargin(), area.getMargin()) && Objects.equals(this.getPadding(), area.getPadding());
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.rx, this.ry, this.z, this.getMargin(), this.getPadding());
    }
}

