/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.widgets;

import com.cleanroommc.modularui.api.ITheme;
import com.cleanroommc.modularui.api.drawable.IDrawable;
import com.cleanroommc.modularui.api.drawable.IKey;
import com.cleanroommc.modularui.api.drawable.ITextLine;
import com.cleanroommc.modularui.api.value.IBoolValue;
import com.cleanroommc.modularui.api.value.IEnumValue;
import com.cleanroommc.modularui.api.value.IIntValue;
import com.cleanroommc.modularui.api.value.ISyncOrValue;
import com.cleanroommc.modularui.api.widget.Interactable;
import com.cleanroommc.modularui.drawable.UITexture;
import com.cleanroommc.modularui.screen.RichTooltip;
import com.cleanroommc.modularui.theme.WidgetThemeEntry;
import com.cleanroommc.modularui.utils.Alignment;
import com.cleanroommc.modularui.value.IntValue;
import com.cleanroommc.modularui.widget.Widget;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AbstractCycleButtonWidget<W extends AbstractCycleButtonWidget<W>>
extends Widget<W>
implements Interactable {
    private int stateCount = 1;
    private IIntValue<?> intValue;
    private int lastValue = -1;
    protected IDrawable[] background = null;
    protected IDrawable[] hoverBackground = null;
    protected IDrawable[] overlay = null;
    protected IDrawable[] hoverOverlay = null;
    private final List<RichTooltip> stateTooltip = new ArrayList<RichTooltip>();

    @Override
    public void onInit() {
        if (this.intValue == null) {
            this.intValue = new IntValue(0);
        }
    }

    @Override
    public boolean isValidSyncOrValue(@NotNull ISyncOrValue syncOrValue) {
        return syncOrValue.isTypeOrEmpty(IIntValue.class);
    }

    @Override
    protected void setSyncOrValue(@NotNull ISyncOrValue syncOrValue) {
        super.setSyncOrValue(syncOrValue);
        this.intValue = syncOrValue.castNullable(IIntValue.class);
        if (syncOrValue instanceof IEnumValue) {
            IEnumValue enumValue = (IEnumValue)syncOrValue;
            this.stateCount(((Enum[])enumValue.getEnumClass().getEnumConstants()).length);
        } else if (syncOrValue instanceof IBoolValue) {
            this.stateCount(2);
        }
    }

    protected int getState() {
        int val = this.intValue.getIntValue();
        if (val != this.lastValue) {
            this.setState(val, false);
        }
        return val;
    }

    public void next() {
        int state = (this.getState() + 1) % this.stateCount;
        this.setState(state, true);
    }

    public void prev() {
        int state = this.getState();
        if (--state == -1) {
            state = this.stateCount - 1;
        }
        this.setState(state, true);
    }

    public void setState(int state, boolean setSource) {
        if (state < 0 || state >= this.stateCount) {
            throw new IndexOutOfBoundsException("CycleButton state out of bounds");
        }
        if (setSource) {
            this.intValue.setIntValue(state);
        }
        this.lastValue = state;
        this.markTooltipDirty();
    }

    @Override
    @NotNull
    public Interactable.Result onMousePressed(int mouseButton) {
        switch (mouseButton) {
            case 0: {
                this.next();
                Interactable.playButtonClickSound();
                return Interactable.Result.SUCCESS;
            }
            case 1: {
                this.prev();
                Interactable.playButtonClickSound();
                return Interactable.Result.SUCCESS;
            }
        }
        return Interactable.Result.IGNORE;
    }

    @Override
    public WidgetThemeEntry<?> getWidgetThemeInternal(ITheme theme) {
        return theme.getButtonTheme();
    }

    @Override
    public IDrawable getCurrentBackground(ITheme theme, WidgetThemeEntry<?> widgetTheme) {
        int state = this.getState();
        if (this.isHovering() && this.hoverBackground != null && this.hoverBackground[state] != null && this.hoverBackground[state] != IDrawable.NONE) {
            return this.hoverBackground[state];
        }
        return this.background != null && this.background[state] != null ? this.background[state] : super.getCurrentBackground(theme, widgetTheme);
    }

    @Override
    public IDrawable getCurrentOverlay(ITheme theme, WidgetThemeEntry<?> widgetTheme) {
        int state = this.getState();
        if (this.isHovering() && this.hoverOverlay != null && this.hoverOverlay[state] != null && this.hoverOverlay[state] != IDrawable.NONE) {
            return this.hoverOverlay[state];
        }
        return this.overlay != null && this.overlay[state] != null ? this.overlay[state] : super.getCurrentOverlay(theme, widgetTheme);
    }

    @Override
    public boolean hasTooltip() {
        int state = this.getState();
        return super.hasTooltip() || this.stateTooltip.size() > state && !this.stateTooltip.get(state).isEmpty();
    }

    @Override
    public void markTooltipDirty() {
        super.markTooltipDirty();
        for (RichTooltip tooltip : this.stateTooltip) {
            tooltip.markDirty();
        }
        this.getState();
    }

    @Override
    @Nullable
    public RichTooltip getTooltip() {
        RichTooltip tooltip = super.getTooltip();
        if (tooltip == null || tooltip.isEmpty()) {
            return this.stateTooltip.get(this.getState());
        }
        return tooltip;
    }

    @Override
    public W disableHoverBackground() {
        if (this.hoverBackground != null) {
            Arrays.fill(this.hoverBackground, IDrawable.NONE);
        }
        if (this.getHoverBackground() == null) {
            super.hoverBackground(IDrawable.NONE);
        }
        return (W)((AbstractCycleButtonWidget)this.getThis());
    }

    @Override
    public W disableHoverOverlay() {
        if (this.hoverOverlay != null) {
            Arrays.fill(this.hoverOverlay, IDrawable.NONE);
        }
        if (this.getHoverOverlay() == null) {
            super.hoverOverlay(IDrawable.NONE);
        }
        return (W)((AbstractCycleButtonWidget)this.getThis());
    }

    protected W value(IIntValue<?> value) {
        this.setSyncOrValue(ISyncOrValue.orEmpty(value));
        return (W)((AbstractCycleButtonWidget)this.getThis());
    }

    public W stateBackground(UITexture texture) {
        AbstractCycleButtonWidget.splitTexture(texture, this.background);
        return (W)((AbstractCycleButtonWidget)this.getThis());
    }

    public W stateOverlay(UITexture texture) {
        AbstractCycleButtonWidget.splitTexture(texture, this.overlay);
        return (W)((AbstractCycleButtonWidget)this.getThis());
    }

    public W stateHoverBackground(UITexture texture) {
        AbstractCycleButtonWidget.splitTexture(texture, this.hoverBackground);
        return (W)((AbstractCycleButtonWidget)this.getThis());
    }

    public W stateHoverOverlay(UITexture texture) {
        AbstractCycleButtonWidget.splitTexture(texture, this.hoverOverlay);
        return (W)((AbstractCycleButtonWidget)this.getThis());
    }

    protected W addTooltip(int state, IDrawable tooltip) {
        if (state >= this.stateTooltip.size() || state < 0) {
            throw new IndexOutOfBoundsException();
        }
        this.stateTooltip.get(state).addLine(tooltip);
        return (W)((AbstractCycleButtonWidget)this.getThis());
    }

    protected W addTooltip(int state, String tooltip) {
        return this.addTooltip(state, IKey.str(tooltip));
    }

    @Override
    public W addTooltipElement(String s) {
        for (RichTooltip tooltip : this.stateTooltip) {
            tooltip.add(s);
        }
        return (W)((AbstractCycleButtonWidget)this.getThis());
    }

    @Override
    public W addTooltipDrawableLines(Iterable<IDrawable> lines) {
        for (RichTooltip tooltip : this.stateTooltip) {
            tooltip.addDrawableLines(lines);
        }
        return (W)((AbstractCycleButtonWidget)this.getThis());
    }

    @Override
    public W addTooltipElement(IDrawable drawable) {
        for (RichTooltip tooltip : this.stateTooltip) {
            tooltip.add(drawable);
        }
        return (W)((AbstractCycleButtonWidget)this.getThis());
    }

    @Override
    public W addTooltipLine(ITextLine line) {
        for (RichTooltip tooltip : this.stateTooltip) {
            tooltip.addLine(line);
        }
        return (W)((AbstractCycleButtonWidget)this.getThis());
    }

    @Override
    public W addTooltipLine(IDrawable drawable) {
        for (RichTooltip tooltip : this.stateTooltip) {
            tooltip.addLine(drawable);
        }
        return (W)((AbstractCycleButtonWidget)this.getThis());
    }

    @Override
    public W addTooltipStringLines(Iterable<String> lines) {
        for (RichTooltip tooltip : this.stateTooltip) {
            tooltip.addStringLines(lines);
        }
        return (W)((AbstractCycleButtonWidget)this.getThis());
    }

    @Override
    public W tooltipStatic(Consumer<RichTooltip> tooltipConsumer) {
        for (RichTooltip tooltip : this.stateTooltip) {
            tooltipConsumer.accept(tooltip);
        }
        return (W)((AbstractCycleButtonWidget)this.getThis());
    }

    @Override
    public W tooltipDynamic(Consumer<RichTooltip> tooltipBuilder) {
        for (RichTooltip tooltip : this.stateTooltip) {
            tooltip.tooltipBuilder(tooltipBuilder);
        }
        return (W)((AbstractCycleButtonWidget)this.getThis());
    }

    @Override
    public W tooltipAlignment(Alignment alignment) {
        for (RichTooltip tooltip : this.stateTooltip) {
            tooltip.alignment(alignment);
        }
        return (W)((AbstractCycleButtonWidget)this.getThis());
    }

    @Override
    public W tooltipPos(RichTooltip.Pos pos) {
        for (RichTooltip tooltip : this.stateTooltip) {
            tooltip.pos(pos);
        }
        return (W)((AbstractCycleButtonWidget)this.getThis());
    }

    @Override
    public W tooltipPos(int x, int y) {
        for (RichTooltip tooltip : this.stateTooltip) {
            tooltip.pos(x, y);
        }
        return (W)((AbstractCycleButtonWidget)this.getThis());
    }

    @Override
    public W tooltipScale(float scale) {
        for (RichTooltip tooltip : this.stateTooltip) {
            tooltip.scale(scale);
        }
        return (W)((AbstractCycleButtonWidget)this.getThis());
    }

    @Override
    public W tooltipTextColor(int textColor) {
        for (RichTooltip tooltip : this.stateTooltip) {
            tooltip.textColor(textColor);
        }
        return (W)((AbstractCycleButtonWidget)this.getThis());
    }

    @Override
    public W tooltipTextShadow(boolean textShadow) {
        for (RichTooltip tooltip : this.stateTooltip) {
            tooltip.textShadow(textShadow);
        }
        return (W)((AbstractCycleButtonWidget)this.getThis());
    }

    @Override
    public W tooltipShowUpTimer(int showUpTimer) {
        for (RichTooltip tooltip : this.stateTooltip) {
            tooltip.showUpTimer(showUpTimer);
        }
        return (W)((AbstractCycleButtonWidget)this.getThis());
    }

    protected W stateCount(int stateCount) {
        this.stateCount = stateCount;
        while (this.stateTooltip.size() < this.stateCount) {
            this.stateTooltip.add(new RichTooltip().parent(this));
        }
        while (this.stateTooltip.size() > this.stateCount) {
            this.stateTooltip.remove(this.stateTooltip.size() - 1);
        }
        this.background = AbstractCycleButtonWidget.checkArray(this.background, stateCount);
        this.overlay = AbstractCycleButtonWidget.checkArray(this.overlay, stateCount);
        this.hoverBackground = AbstractCycleButtonWidget.checkArray(this.hoverBackground, stateCount);
        this.hoverOverlay = AbstractCycleButtonWidget.checkArray(this.hoverOverlay, stateCount);
        return (W)((AbstractCycleButtonWidget)this.getThis());
    }

    private static IDrawable[] checkArray(IDrawable[] array, int length) {
        if (array == null) {
            return new IDrawable[length];
        }
        return array.length < length ? Arrays.copyOf(array, length) : array;
    }

    protected IDrawable[] addToArray(IDrawable[] array, IDrawable[] drawable, int index) {
        return this.addToArray(array, IDrawable.of(drawable), index);
    }

    protected IDrawable[] addToArray(IDrawable[] array, IDrawable drawable, int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (array == null || index >= array.length) {
            IDrawable[] copy = new IDrawable[(int)(Math.ceil((double)(index + 1) / 4.0) * 4.0)];
            if (array != null) {
                System.arraycopy(array, 0, copy, 0, array.length);
            }
            array = copy;
        }
        array[index] = drawable;
        return array;
    }

    protected static void splitTexture(UITexture texture, IDrawable[] dest) {
        for (int i = 0; i < dest.length; ++i) {
            float a = 1.0f / (float)dest.length;
            dest[i] = texture.getSubArea(0.0f, (float)i * a, 1.0f, (float)i * a + a);
        }
    }

    protected W tooltip(int index, Consumer<RichTooltip> builder) {
        builder.accept(this.stateTooltip.get(index));
        return (W)((AbstractCycleButtonWidget)this.getThis());
    }

    protected W tooltipBuilder(int index, Consumer<RichTooltip> builder) {
        this.stateTooltip.get(index).tooltipBuilder(builder);
        return (W)((AbstractCycleButtonWidget)this.getThis());
    }
}

