/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.widgets;

import com.cleanroommc.modularui.ModularUI;
import com.cleanroommc.modularui.api.GuiAxis;
import com.cleanroommc.modularui.api.drawable.IDrawable;
import com.cleanroommc.modularui.api.drawable.IKey;
import com.cleanroommc.modularui.api.widget.IWidget;
import com.cleanroommc.modularui.drawable.GuiTextures;
import com.cleanroommc.modularui.drawable.HueBar;
import com.cleanroommc.modularui.drawable.Rectangle;
import com.cleanroommc.modularui.screen.ModularPanel;
import com.cleanroommc.modularui.utils.Alignment;
import com.cleanroommc.modularui.utils.Color;
import com.cleanroommc.modularui.value.DoubleValue;
import com.cleanroommc.modularui.value.StringValue;
import com.cleanroommc.modularui.widget.Widget;
import com.cleanroommc.modularui.widgets.ButtonWidget;
import com.cleanroommc.modularui.widgets.Dialog;
import com.cleanroommc.modularui.widgets.PageButton;
import com.cleanroommc.modularui.widgets.PagedWidget;
import com.cleanroommc.modularui.widgets.SliderWidget;
import com.cleanroommc.modularui.widgets.layout.Column;
import com.cleanroommc.modularui.widgets.layout.Flow;
import com.cleanroommc.modularui.widgets.layout.Row;
import com.cleanroommc.modularui.widgets.textfield.TextFieldWidget;
import java.util.function.Consumer;

public class ColorPickerDialog
extends Dialog<Integer> {
    private static final IDrawable handleBackground = new Rectangle().setColor(Color.WHITE.main);
    private int color;
    private int red;
    private int green;
    private int blue;
    private double hue;
    private double saturation;
    private double value;
    private int alpha;
    private final boolean controlAlpha;
    private final Rectangle preview = new Rectangle();
    private final Rectangle sliderBackgroundR = new Rectangle();
    private final Rectangle sliderBackgroundG = new Rectangle();
    private final Rectangle sliderBackgroundB = new Rectangle();
    private final Rectangle sliderBackgroundA = new Rectangle();
    private final Rectangle sliderBackgroundS = new Rectangle();
    private final Rectangle sliderBackgroundV = new Rectangle();

    public ColorPickerDialog(Consumer<Integer> resultConsumer, int startColor, boolean controlAlpha) {
        this("color_picker", resultConsumer, startColor, controlAlpha);
    }

    public ColorPickerDialog(String name, Consumer<Integer> resultConsumer, int startColor, boolean controlAlpha) {
        super(name, resultConsumer);
        this.controlAlpha = controlAlpha;
        this.alpha = Color.getAlpha(startColor);
        this.updateAll(startColor);
        ((ModularPanel)this.size(140, controlAlpha ? 106 : 94)).background(GuiTextures.MC_BACKGROUND);
        PagedWidget.Controller controller = new PagedWidget.Controller();
        this.child((IWidget)((Flow)((Flow)((Flow)((Flow)((Flow)((Flow)((Flow)new Column().left(5)).right(5)).top(5)).bottom(5)).child((IWidget)((Flow)((Flow)((Flow)((Flow)new Row().left(5)).right(5)).height(14)).child(((PageButton)new PageButton(0, controller).sizeRel(0.5f, 1.0f)).overlay(IKey.str("RGB")))).child(((PageButton)new PageButton(1, controller).sizeRel(0.5f, 1.0f)).overlay(IKey.str("HSV"))))).child((IWidget)((Flow)((Flow)((Flow)((Flow)((Flow)new Row().widthRel(1.0f)).height(12)).marginTop(4)).child((IWidget)IKey.str("Hex: ").asWidget().heightRel(1.0f))).child(((TextFieldWidget)((TextFieldWidget)new TextFieldWidget().height(12)).expanded()).setValidator(this::validateRawColor).value(new StringValue.Dynamic(() -> {
            if (controlAlpha) {
                return "#" + Color.toFullHexString(this.red, this.green, this.blue, this.alpha);
            }
            return "#" + Color.toFullHexString(this.red, this.green, this.blue);
        }, val -> {
            try {
                this.updateAll((int)Long.decode(val).longValue());
            }
            catch (NumberFormatException ignored) {
                ModularUI.LOGGER.error("Illegal color string '{}'", val);
            }
        })))).child((IWidget)((Widget)this.preview.asWidget().background(GuiTextures.CHECKBOARD).size(10, 10)).margin(1)))).child(((PagedWidget)((PagedWidget)((PagedWidget)((PagedWidget)((PagedWidget)new PagedWidget().left(5)).right(5)).expanded()).controller(controller)).addPage(this.createRGBPage(this.createAlphaSlider("rgb")))).addPage(this.createHSVPage(this.createAlphaSlider("hsv"))))).child((IWidget)((Flow)((Flow)((Flow)((Flow)new Row().left(10)).right(10)).height(14)).mainAxisAlignment(Alignment.MainAxis.SPACE_BETWEEN).child(((ButtonWidget)((ButtonWidget)((ButtonWidget)new ButtonWidget().heightRel(1.0f)).width(50)).overlay(IKey.str("Cancel"))).onMousePressed(button -> {
            this.closeIfOpen();
            return true;
        }))).child(((ButtonWidget)((ButtonWidget)((ButtonWidget)new ButtonWidget().heightRel(1.0f)).width(50)).overlay(IKey.str("Confirm"))).onMousePressed(button -> {
            this.closeWith(this.color);
            return true;
        }))));
    }

    private IWidget createRGBPage(IWidget alphaSlider) {
        return (IWidget)((Flow)((Flow)((Flow)((Flow)new Column().sizeRel(1.0f, 1.0f)).child((IWidget)((Flow)((Flow)((Flow)new Row().widthRel(1.0f)).height(12)).child((IWidget)IKey.str("R: ").asWidget().heightRel(1.0f))).child(((SliderWidget)ColorPickerDialog.createSlider(this.sliderBackgroundR).name("red")).bounds(0.0, 255.0).value(new DoubleValue.Dynamic(() -> this.red, this::updateRed))))).child((IWidget)((Flow)((Flow)((Flow)new Row().widthRel(1.0f)).height(12)).child((IWidget)IKey.str("G: ").asWidget().heightRel(1.0f))).child(((SliderWidget)ColorPickerDialog.createSlider(this.sliderBackgroundG).name("green")).bounds(0.0, 255.0).value(new DoubleValue.Dynamic(() -> this.green, this::updateGreen))))).child((IWidget)((Flow)((Flow)((Flow)new Row().widthRel(1.0f)).height(12)).child((IWidget)IKey.str("B: ").asWidget().heightRel(1.0f))).child(((SliderWidget)ColorPickerDialog.createSlider(this.sliderBackgroundB).name("blue")).bounds(0.0, 255.0).value(new DoubleValue.Dynamic(() -> this.blue, this::updateBlue))))).childIf(alphaSlider != null, alphaSlider);
    }

    private IWidget createHSVPage(IWidget alphaSlider) {
        return (IWidget)((Flow)((Flow)((Flow)((Flow)new Column().sizeRel(1.0f, 1.0f)).child((IWidget)((Flow)((Flow)((Flow)new Row().widthRel(1.0f)).height(12)).child((IWidget)IKey.str("H: ").asWidget().heightRel(1.0f))).child(((SliderWidget)ColorPickerDialog.createSlider(new HueBar(GuiAxis.X)).name("hue")).bounds(0.0, 360.0).value(new DoubleValue.Dynamic(() -> this.hue, this::updateHue))))).child((IWidget)((Flow)((Flow)((Flow)new Row().widthRel(1.0f)).height(12)).child((IWidget)IKey.str("S: ").asWidget().heightRel(1.0f))).child(((SliderWidget)ColorPickerDialog.createSlider(this.sliderBackgroundS).name("saturation")).bounds(0.0, 1.0).value(new DoubleValue.Dynamic(() -> this.saturation, this::updateSaturation))))).child((IWidget)((Flow)((Flow)((Flow)new Row().widthRel(1.0f)).height(12)).child((IWidget)IKey.str("V: ").asWidget().heightRel(1.0f))).child(((SliderWidget)ColorPickerDialog.createSlider(this.sliderBackgroundV).name("value")).bounds(0.0, 1.0).value(new DoubleValue.Dynamic(() -> this.value, this::updateValue))))).childIf(alphaSlider != null, alphaSlider);
    }

    private static SliderWidget createSlider(IDrawable background) {
        return ((SliderWidget)((SliderWidget)((SliderWidget)new SliderWidget().expanded()).heightRel(1.0f)).background(background.asIcon().size(0, 4))).sliderTexture(handleBackground).sliderSize(2, 8);
    }

    private IWidget createAlphaSlider(String s) {
        return this.controlAlpha ? (IWidget)((Flow)((Flow)((Flow)new Row().widthRel(1.0f)).height(12)).child((IWidget)IKey.str("A: ").asWidget().heightRel(1.0f))).child(((SliderWidget)ColorPickerDialog.createSlider(this.sliderBackgroundA).name("alpha " + s)).bounds(0.0, 255.0).value(new DoubleValue.Dynamic(() -> this.alpha, this::updateAlpha))) : null;
    }

    private String validateRawColor(String raw) {
        if (!raw.startsWith("#")) {
            if (raw.startsWith("0x") || raw.startsWith("0X")) {
                raw = raw.substring(2);
            }
            return "#" + raw;
        }
        return raw;
    }

    private void updateRed(double v) {
        this.red = (int)v;
        this.updateFromRGB();
    }

    private void updateGreen(double v) {
        this.green = (int)v;
        this.updateFromRGB();
    }

    private void updateBlue(double v) {
        this.blue = (int)v;
        this.updateFromRGB();
    }

    private void updateHue(double v) {
        this.hue = v;
        this.updateFromHSV();
    }

    private void updateSaturation(double v) {
        this.saturation = v;
        this.updateFromHSV();
    }

    private void updateValue(double v) {
        this.value = v;
        this.updateFromHSV();
    }

    private void updateAlpha(double v) {
        if (!this.controlAlpha) {
            return;
        }
        this.alpha = (int)v;
        this.color = Color.withAlpha(this.color, this.alpha);
    }

    private void updateFromRGB() {
        this.color = Color.argb(this.red, this.green, this.blue, this.alpha);
        this.saturation = Color.getHSVSaturation(this.color);
        this.value = Color.getValue(this.color);
        this.hue = Color.getHue(this.color);
        this.updateColor(this.color);
    }

    private void updateFromHSV() {
        this.color = Color.ofHSV((float)this.hue, (float)this.saturation, (float)this.value, this.alpha);
        this.red = Color.getRed(this.color);
        this.green = Color.getGreen(this.color);
        this.blue = Color.getBlue(this.color);
        this.updateColor(this.color);
    }

    public void updateAll(int color) {
        if (!this.controlAlpha) {
            color = Color.withAlpha(color, this.alpha);
        }
        this.color = color;
        this.alpha = Color.getAlpha(color);
        this.red = Color.getRed(color);
        this.green = Color.getGreen(color);
        this.blue = Color.getBlue(color);
        this.hue = Color.getHue(color);
        this.saturation = Color.getHSVSaturation(color);
        this.value = Color.getValue(color);
        this.updateColor(color);
    }

    public void updateColor(int color) {
        color = Color.withAlpha(color, 255);
        int rs = Color.withRed(color, 0);
        int re = Color.withRed(color, 255);
        int gs = Color.withGreen(color, 0);
        int ge = Color.withGreen(color, 255);
        int bs = Color.withBlue(color, 0);
        int be = Color.withBlue(color, 255);
        int as = Color.withAlpha(color, 0);
        int ae = Color.withAlpha(color, 255);
        this.sliderBackgroundR.setHorizontalGradient(rs, re);
        this.sliderBackgroundG.setHorizontalGradient(gs, ge);
        this.sliderBackgroundB.setHorizontalGradient(bs, be);
        this.sliderBackgroundA.setHorizontalGradient(as, ae);
        this.sliderBackgroundS.setHorizontalGradient(Color.withHSVSaturation(color, 0.0f), Color.withHSVSaturation(color, 1.0f));
        this.sliderBackgroundV.setHorizontalGradient(Color.withValue(color, 0.0f), Color.withValue(color, 1.0f));
        this.preview.setColor(color);
    }
}

