/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.widgets.slot;

import com.cleanroommc.modularui.core.mixins.early.minecraft.InventoryCraftingAccessor;
import com.cleanroommc.modularui.utils.Platform;
import net.minecraft.client.util.RecipeItemHelper;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.NotNull;

public class InventoryCraftingWrapper
extends InventoryCrafting {
    private final IItemHandlerModifiable delegate;
    private final int size;
    private final int startIndex;

    public InventoryCraftingWrapper(Container eventHandlerIn, int width, int height, IItemHandlerModifiable delegate, int startIndex) {
        super(eventHandlerIn, width, height);
        this.size = width * height + 1;
        if (startIndex + this.size < delegate.getSlots()) {
            throw new IllegalArgumentException("Inventory does not have enough slots for given size. Requires " + (startIndex + this.size) + " slots, but only has " + delegate.getSlots() + " slots!");
        }
        this.delegate = delegate;
        this.startIndex = startIndex;
        for (int i = 0; i < this.size - 1; ++i) {
            ItemStack stack = this.delegate.getStackInSlot(i + this.startIndex);
            this.updateSnapshot(i, stack);
        }
    }

    private NonNullList<ItemStack> getBackingList() {
        return ((InventoryCraftingAccessor)((Object)this)).getStackList();
    }

    public Container getContainer() {
        return ((InventoryCraftingAccessor)((Object)this)).getEventHandler();
    }

    private void updateSnapshot(int index, ItemStack stack) {
        this.getBackingList().set(index, (Object)Platform.copyStack(stack));
    }

    public void detectChanges() {
        boolean notify = false;
        for (int i = 0; i < this.size - 1; ++i) {
            ItemStack stack = (ItemStack)this.getBackingList().get(i);
            ItemStack current = this.delegate.getStackInSlot(i + this.startIndex);
            if (Platform.isStackEmpty(current) && current != Platform.EMPTY_STACK) {
                current = Platform.EMPTY_STACK;
                this.delegate.setStackInSlot(i + this.startIndex, Platform.EMPTY_STACK);
            }
            if (Platform.isStackEmpty(stack) == Platform.isStackEmpty(current) && (Platform.isStackEmpty(stack) || ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)current))) continue;
            this.updateSnapshot(i, current);
            notify = true;
        }
        if (notify) {
            this.notifyContainer();
        }
    }

    public IItemHandler getDelegate() {
        return this.delegate;
    }

    public int getStartIndex() {
        return this.startIndex;
    }

    public int getSizeInventory() {
        return this.size;
    }

    public boolean isEmpty() {
        for (int i = 0; i < this.size; ++i) {
            if (Platform.isStackEmpty(this.getStackInSlot(i))) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public ItemStack getStackInSlot(int index) {
        return (index += this.startIndex) >= 0 && index < this.size ? this.delegate.getStackInSlot(index) : Platform.EMPTY_STACK;
    }

    public void setInventorySlotContents(int index, @NotNull ItemStack stack) {
        this.setSlot(index, stack, true);
    }

    public void setSlot(int index, @NotNull ItemStack stack, boolean notifyContainer) {
        this.delegate.setStackInSlot(this.startIndex + index, stack);
        if (notifyContainer) {
            this.notifyContainer();
        }
    }

    @NotNull
    public ItemStack decrStackSize(int index, int count) {
        return this.decrStackSize(index, count, true);
    }

    public ItemStack decrStackSize(int index, int count, boolean notifyContainer) {
        if ((index += this.startIndex) < 0 || index >= this.size || count <= 0) {
            return Platform.EMPTY_STACK;
        }
        ItemStack stack = this.getStackInSlot(index);
        if (Platform.isStackEmpty(stack)) {
            return Platform.EMPTY_STACK;
        }
        stack.splitStack(count);
        if (Platform.isStackEmpty(stack)) {
            this.setSlot(index, Platform.EMPTY_STACK, false);
        }
        if (notifyContainer) {
            this.notifyContainer();
        }
        return stack;
    }

    @NotNull
    public ItemStack removeStackFromSlot(int index) {
        return this.removeStackFromSlot(index, true);
    }

    @NotNull
    public ItemStack removeStackFromSlot(int index, boolean notifyContainer) {
        if ((index += this.startIndex) < 0 || index >= this.size) {
            return Platform.EMPTY_STACK;
        }
        ItemStack stack = this.getStackInSlot(index);
        this.delegate.setStackInSlot(index, Platform.EMPTY_STACK);
        if (notifyContainer) {
            this.notifyContainer();
        }
        return stack;
    }

    public void clear() {
        for (int i = 0; i < this.size; ++i) {
            this.setSlot(i, Platform.EMPTY_STACK, false);
        }
    }

    public void fillStackedContents(@NotNull RecipeItemHelper helper) {
        for (int i = 0; i < this.size; ++i) {
            helper.accountStack(this.getStackInSlot(i));
        }
    }

    public void notifyContainer() {
        this.getContainer().onCraftMatrixChanged((IInventory)this);
    }
}

