/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.widgets.textfield;

import com.cleanroommc.modularui.screen.viewport.GuiContext;
import com.cleanroommc.modularui.widget.scroll.ScrollArea;
import com.cleanroommc.modularui.widgets.textfield.BaseTextFieldWidget;
import com.cleanroommc.modularui.widgets.textfield.TextFieldRenderer;
import com.google.common.base.Joiner;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Nullable;

public class TextFieldHandler {
    private static final Joiner JOINER = Joiner.on((char)'\n');
    private final List<String> text = new ArrayList<String>();
    private final Point cursor = new Point();
    private final Point cursorEnd = new Point();
    private final BaseTextFieldWidget<?> textFieldWidget;
    private TextFieldRenderer renderer;
    @Nullable
    private ScrollArea scrollArea;
    private boolean mainCursorStart = true;
    private int maxLines = 1;
    @Nullable
    private Pattern pattern;
    private int maxCharacters = -1;
    private GuiContext guiContext;

    public TextFieldHandler(BaseTextFieldWidget<?> textFieldWidget) {
        this.textFieldWidget = textFieldWidget;
    }

    public void setPattern(@Nullable Pattern pattern) {
        this.pattern = pattern;
    }

    public void setMaxCharacters(int maxCharacters) {
        this.maxCharacters = maxCharacters;
    }

    public void setScrollArea(@Nullable ScrollArea scrollArea) {
        this.scrollArea = scrollArea;
    }

    public void setRenderer(TextFieldRenderer renderer) {
        this.renderer = renderer;
    }

    public void switchCursors() {
        this.mainCursorStart = !this.mainCursorStart;
    }

    public Point getMainCursor() {
        return this.mainCursorStart ? this.cursor : this.cursorEnd;
    }

    public Point getOffsetCursor() {
        return this.mainCursorStart ? this.cursorEnd : this.cursor;
    }

    public Point getStartCursor() {
        if (!this.hasTextMarked()) {
            return this.cursor;
        }
        return this.cursor.y > this.cursorEnd.y || this.cursor.y == this.cursorEnd.y && this.cursor.x > this.cursorEnd.x ? this.cursorEnd : this.cursor;
    }

    public Point getEndCursor() {
        if (!this.hasTextMarked()) {
            return this.cursor;
        }
        return this.cursor.y > this.cursorEnd.y || this.cursor.y == this.cursorEnd.y && this.cursor.x > this.cursorEnd.x ? this.cursor : this.cursorEnd;
    }

    public boolean hasTextMarked() {
        return this.cursor.y != this.cursorEnd.y || this.cursor.x != this.cursorEnd.x;
    }

    public void setOffsetCursor(int linePos, int charPos) {
        this.getOffsetCursor().setLocation(charPos, linePos);
    }

    public void setMainCursor(int linePos, int charPos, boolean animate) {
        Point main = this.getMainCursor();
        if (main.x != charPos || main.y != linePos) {
            main.setLocation(charPos, linePos);
            if (!this.text.isEmpty() && this.renderer != null && this.scrollArea != null) {
                this.renderer.setSimulate(true);
                this.renderer.draw(this.text);
                this.renderer.setSimulate(false);
                this.scrollArea.getScrollX().setScrollSize((int)this.renderer.getLastActualWidth());
                if (this.scrollArea.getScrollX().isScrollBarActive(this.scrollArea)) {
                    String line = this.text.get(main.y);
                    int scrollTo = (int)this.renderer.getPosOf(this.renderer.measureLines(Collections.singletonList(line)), (Point)main).x;
                    scrollTo -= this.scrollArea.getScrollX().getFullVisibleSize(this.scrollArea) / 2;
                    if (animate) {
                        this.scrollArea.getScrollX().animateTo(this.scrollArea, scrollTo);
                    } else {
                        this.scrollArea.getScrollX().scrollTo(this.scrollArea, scrollTo);
                    }
                }
            }
        }
    }

    public void setCursor(int linePos, int charPos, boolean animate) {
        this.setCursor(linePos, charPos, true, animate);
    }

    public void setCursor(int linePos, int charPos, boolean applyToOffset, boolean animate) {
        this.setMainCursor(linePos, charPos, animate);
        if (applyToOffset) {
            this.setOffsetCursor(linePos, charPos);
        }
    }

    public void setOffsetCursor(Point cursor) {
        this.setOffsetCursor(cursor.y, cursor.x);
    }

    public void setMainCursor(Point cursor, boolean animate) {
        this.setMainCursor(cursor.y, cursor.x, animate);
    }

    public void setCursor(Point cursor, boolean animate) {
        this.setMainCursor(cursor, animate);
        this.setOffsetCursor(cursor);
    }

    public void putMainCursorAtStart() {
        if (this.hasTextMarked() && this.getMainCursor() != this.getStartCursor()) {
            this.switchCursors();
        }
    }

    public void putMainCursorAtEnd() {
        if (this.hasTextMarked() && this.getMainCursor() != this.getEndCursor()) {
            this.switchCursors();
        }
    }

    public void moveCursorLeft(boolean ctrl, boolean shift) {
        if (this.text.isEmpty()) {
            return;
        }
        Point main = this.getMainCursor();
        if (main.x == 0) {
            if (main.y == 0) {
                return;
            }
            this.setCursor(main.y - 1, this.text.get(main.y - 1).length(), !shift, true);
        } else {
            int newPos = main.x - 1;
            if (ctrl && newPos > 0) {
                String line = this.text.get(main.y);
                boolean found = false;
                for (int i = newPos; i >= 0; --i) {
                    char c = line.charAt(i);
                    if (Character.isLetter(c) || Character.isDigit(c)) continue;
                    if (i < newPos) {
                        newPos = i + 1;
                    }
                    found = true;
                    break;
                }
                if (!found) {
                    newPos = 0;
                }
            }
            this.setCursor(main.y, newPos, !shift, true);
        }
    }

    public void moveCursorRight(boolean ctrl, boolean shift) {
        if (this.text.isEmpty()) {
            return;
        }
        Point main = this.getMainCursor();
        String line = this.text.get(main.y);
        if (main.x == line.length()) {
            if (main.y == this.text.size() - 1) {
                return;
            }
            this.setCursor(main.y + 1, 0, !shift, true);
        } else {
            int newPos = main.x + 1;
            if (ctrl && newPos < line.length()) {
                boolean found = false;
                for (int i = main.x; i < line.length(); ++i) {
                    char c = line.charAt(i);
                    if (Character.isLetter(c) || Character.isDigit(c)) continue;
                    if (newPos < i) {
                        newPos = i;
                    }
                    found = true;
                    break;
                }
                if (!found) {
                    newPos = line.length();
                }
            }
            this.setCursor(main.y, newPos, !shift, true);
        }
    }

    public void moveCursorUp(boolean ctrl, boolean shift) {
        if (this.text.isEmpty()) {
            return;
        }
        Point main = this.getMainCursor();
        if (main.y > 0) {
            this.setCursor(main.y - 1, main.x, !shift, true);
        } else {
            this.setCursor(main.y, 0, !shift, true);
        }
    }

    public void moveCursorDown(boolean ctrl, boolean shift) {
        if (this.text.isEmpty()) {
            return;
        }
        Point main = this.getMainCursor();
        if (main.y < this.text.size() - 1) {
            this.setCursor(main.y + 1, main.x, !shift, true);
        } else {
            this.setCursor(main.y, this.text.get(main.y).length(), !shift, true);
        }
    }

    public void markAll() {
        this.setOffsetCursor(0, 0);
        this.setMainCursor(this.text.size() - 1, this.text.get(this.text.size() - 1).length(), true);
    }

    public void markCurrentLine() {
        this.setOffsetCursor(this.getMainCursor().y, 0);
        this.setMainCursor(this.getMainCursor().y, this.text.get(this.getMainCursor().y).length(), true);
    }

    public String getTextAsString() {
        return JOINER.join(this.text);
    }

    public List<String> getText() {
        return this.text;
    }

    public boolean isTextEmpty() {
        if (this.text.isEmpty()) {
            return true;
        }
        for (String line : this.text) {
            if (line.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public void onChanged() {
        this.textFieldWidget.markTooltipDirty();
    }

    public String getSelectedText() {
        if (!this.hasTextMarked()) {
            return "";
        }
        Point min = this.getStartCursor();
        Point max = this.getEndCursor();
        if (min.y == max.y) {
            return this.text.get(min.y).substring(min.x, max.x);
        }
        StringBuilder builder = new StringBuilder();
        builder.append(this.text.get(min.y).substring(min.x));
        if (max.y > min.y + 2) {
            for (int i = min.y + 1; i < max.y - 1; ++i) {
                builder.append(this.text.get(i));
            }
        }
        builder.append(this.text.get(max.y), 0, max.x);
        return builder.toString();
    }

    public boolean test(String text) {
        return this.maxLines > 1 || (this.pattern == null || this.pattern.matcher(text).matches()) && (this.maxCharacters < 0 || this.maxCharacters >= text.length());
    }

    public void insert(String text, boolean hasHorizontalScrolling) {
        this.insert(Arrays.asList(text.split("\n")), hasHorizontalScrolling);
    }

    public void insert(List<String> text, boolean hasHorizontalScrolling) {
        ArrayList<String> copy = new ArrayList<String>(this.text);
        Point point = this.insert(copy, text);
        if (point == null || copy.size() > this.maxLines || !this.renderer.wouldFit(copy, !hasHorizontalScrolling)) {
            return;
        }
        this.text.clear();
        this.text.addAll(copy);
        this.setCursor(point, true);
        this.onChanged();
    }

    private Point insert(List<String> text, List<String> insertion) {
        if (insertion.isEmpty() || insertion.size() > 1 && text.size() + insertion.size() - 1 > this.maxLines) {
            return null;
        }
        int y = this.cursor.y;
        if (this.hasTextMarked()) {
            this.delete(false);
        }
        if (text.isEmpty()) {
            if (insertion.size() == 1 && !this.test(insertion.get(0))) {
                return null;
            }
            text.addAll(insertion);
            return new Point(text.get(text.size() - 1).length(), text.size() - 1);
        }
        String lineStart = text.get(this.cursor.y).substring(0, this.cursor.x);
        String lineEnd = text.get(this.cursor.y).substring(this.cursor.x);
        if (insertion.size() == 1 && text.size() == 1 && !this.test(lineStart + insertion.get(0) + lineEnd)) {
            return null;
        }
        text.set(this.cursor.y, lineStart + insertion.get(0));
        if (insertion.size() == 1) {
            if (!this.test(insertion.get(0))) {
                return null;
            }
            text.set(this.cursor.y, text.get(this.cursor.y) + lineEnd);
            return new Point(this.cursor.x + insertion.get(0).length(), this.cursor.y);
        }
        text.add(this.cursor.y + 1, insertion.get(insertion.size() - 1) + lineEnd);
        int x = insertion.get(insertion.size() - 1).length();
        ++y;
        if (insertion.size() > 2) {
            text.addAll(this.cursor.y + 1, text.subList(1, insertion.size() - 1));
            x = insertion.get(insertion.size() - 1).length();
            y += insertion.size() - 1;
        }
        return new Point(x, y);
    }

    public void newLine() {
        if (this.hasTextMarked()) {
            this.delete(false);
        }
        String line = this.text.get(this.cursor.y);
        this.text.set(this.cursor.y, line.substring(0, this.cursor.x));
        this.text.add(this.cursor.y + 1, line.substring(this.cursor.x));
        this.setCursor(this.cursor.y + 1, 0, false);
    }

    public void clear() {
        this.markAll();
        this.delete();
    }

    public void delete() {
        this.delete(false);
    }

    public void delete(boolean inFront) {
        if (this.hasTextMarked()) {
            Point min = this.getStartCursor();
            Point max = this.getEndCursor();
            String minLine = this.text.get(min.y);
            if (min.y == max.y) {
                this.text.set(min.y, minLine.substring(0, min.x) + minLine.substring(max.x));
            } else {
                String maxLine = this.text.get(Math.min(this.text.size() - 1, max.y));
                this.text.set(min.y, minLine.substring(0, min.x) + maxLine.substring(max.x));
                if (max.y > min.y + 1) {
                    this.text.subList(min.y + 1, max.y + 1).clear();
                }
            }
            this.setCursor(min.y, min.x, false);
        } else {
            String line = this.text.get(this.cursor.y);
            if (inFront) {
                if (this.cursor.x == line.length()) {
                    if (this.text.size() > this.cursor.y + 1) {
                        this.text.set(this.cursor.y, line + this.text.get(this.cursor.y + 1));
                        this.text.remove(this.cursor.y + 1);
                    }
                } else {
                    line = line.substring(0, this.cursor.x) + line.substring(this.cursor.x + 1);
                    this.text.set(this.cursor.y, line);
                }
            } else if (this.cursor.x == 0) {
                if (this.cursor.y > 0) {
                    String lineAbove = this.text.get(this.cursor.y - 1);
                    this.text.set(this.cursor.y - 1, lineAbove + line);
                    this.text.remove(this.cursor.y);
                    this.setCursor(this.cursor.y - 1, lineAbove.length(), false);
                }
            } else {
                line = line.substring(0, this.cursor.x - 1) + line.substring(this.cursor.x);
                this.text.set(this.cursor.y, line);
                this.setCursor(this.cursor.y, this.cursor.x - 1, false);
            }
        }
        if (this.scrollArea != null) {
            this.scrollArea.getScrollX().clamp(this.scrollArea);
        }
        this.onChanged();
    }

    public void setMaxLines(int maxLines) {
        this.maxLines = Math.max(1, maxLines);
    }

    public int getMaxLines() {
        return this.maxLines;
    }

    public GuiContext getGuiContext() {
        return this.guiContext;
    }

    public void setGuiContext(GuiContext guiContext) {
        this.guiContext = guiContext;
    }
}

