/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.widgets.textfield;

import com.cleanroommc.modularui.ModularUI;
import com.cleanroommc.modularui.api.drawable.IDrawable;
import com.cleanroommc.modularui.api.drawable.IKey;
import com.cleanroommc.modularui.api.drawable.ITextLine;
import com.cleanroommc.modularui.api.value.IStringValue;
import com.cleanroommc.modularui.api.value.ISyncOrValue;
import com.cleanroommc.modularui.screen.RichTooltip;
import com.cleanroommc.modularui.screen.viewport.ModularGuiContext;
import com.cleanroommc.modularui.utils.MathUtils;
import com.cleanroommc.modularui.utils.ParseResult;
import com.cleanroommc.modularui.value.StringValue;
import com.cleanroommc.modularui.value.sync.ValueSyncHandler;
import com.cleanroommc.modularui.widgets.textfield.BaseTextFieldWidget;
import java.text.ParsePosition;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class TextFieldWidget
extends BaseTextFieldWidget<TextFieldWidget> {
    private IStringValue<?> stringValue;
    private Function<String, String> validator = val -> val;
    private boolean numbers = false;
    private String mathFailMessage = null;
    private double defaultNumber = 0.0;
    private boolean tooltipOverride = false;

    public double parse(String num) {
        ParseResult result = MathUtils.parseExpression(num, this.defaultNumber, true);
        double value = result.getResult();
        if (result.isFailure()) {
            this.mathFailMessage = result.getError();
            ModularUI.LOGGER.error("Math expression error in {}: {}", (Object)this, (Object)this.mathFailMessage);
        }
        return value;
    }

    public IStringValue<?> createMathFailMessageValue() {
        return new StringValue.Dynamic(() -> this.mathFailMessage, val -> {
            this.mathFailMessage = val;
        });
    }

    @Override
    public void onInit() {
        super.onInit();
        if (this.stringValue == null) {
            this.stringValue = new StringValue("");
        }
        this.setText(this.stringValue.getStringValue());
        if (!this.hasTooltip() && !this.tooltipOverride) {
            this.tooltipBuilder(tooltip -> tooltip.addLine(IKey.str(this.getText())));
            this.tooltipOverride = false;
        }
    }

    @Override
    public boolean isValidSyncOrValue(@NotNull ISyncOrValue syncOrValue) {
        return syncOrValue.isTypeOrEmpty(IStringValue.class);
    }

    @Override
    protected void setSyncOrValue(@NotNull ISyncOrValue syncOrValue) {
        super.setSyncOrValue(syncOrValue);
        this.stringValue = syncOrValue.castNullable(IStringValue.class);
        if (syncOrValue instanceof ValueSyncHandler) {
            ValueSyncHandler valueSyncHandler = (ValueSyncHandler)syncOrValue;
            valueSyncHandler.setChangeListener(() -> {
                this.markTooltipDirty();
                this.setText(this.stringValue.getValue().toString());
            });
        }
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (!this.isFocused()) {
            String s = this.stringValue.getStringValue();
            if (!this.getText().equals(s)) {
                this.setText(s);
            }
        }
    }

    @Override
    public void drawForeground(ModularGuiContext context) {
        if (this.hasTooltip() && (this.tooltipOverride || this.getScrollData().isScrollBarActive(this.getScrollArea())) && this.isHoveringFor(this.getTooltip().getShowUpTimer())) {
            this.getTooltip().draw(this.getContext());
        }
    }

    @NotNull
    public String getText() {
        if (this.handler.getText().isEmpty()) {
            return "";
        }
        if (this.handler.getText().size() > 1) {
            throw new IllegalStateException("TextFieldWidget can only have one line!");
        }
        return this.handler.getText().get(0);
    }

    public void setText(@NotNull String text) {
        if (this.handler.getText().isEmpty()) {
            this.handler.getText().add(text);
        } else {
            this.handler.getText().set(0, text);
        }
    }

    @Override
    public void onRemoveFocus(ModularGuiContext context) {
        super.onRemoveFocus(context);
        if (this.handler.getText().isEmpty()) {
            this.handler.getText().add(this.validator.apply(""));
        } else if (this.handler.getText().size() == 1) {
            this.handler.getText().set(0, this.validator.apply(this.handler.getText().get(0)));
            this.markTooltipDirty();
        } else {
            throw new IllegalStateException("TextFieldWidget can only have one line!");
        }
        this.stringValue.setStringValue(this.numbers ? format.parse(this.getText(), new ParsePosition(0)).toString() : this.getText());
    }

    @Override
    public boolean canHover() {
        return true;
    }

    public String getMathFailMessage() {
        return this.mathFailMessage;
    }

    public TextFieldWidget setMaxLength(int maxLength) {
        this.handler.setMaxCharacters(maxLength);
        return this;
    }

    public TextFieldWidget setPattern(Pattern pattern) {
        this.handler.setPattern(pattern);
        return this;
    }

    public TextFieldWidget setValidator(Function<String, String> validator) {
        this.validator = validator;
        return this;
    }

    public TextFieldWidget setNumbersLong(Function<Long, Long> validator) {
        this.numbers = true;
        this.setValidator(val -> {
            long num = val.isEmpty() ? (long)this.defaultNumber : (long)this.parse((String)val);
            return format.format(validator.apply(num));
        });
        return this;
    }

    public TextFieldWidget setNumbers(Function<Integer, Integer> validator) {
        this.numbers = true;
        return this.setValidator(val -> {
            int num = val.isEmpty() ? (int)this.defaultNumber : (int)this.parse((String)val);
            return format.format(validator.apply(num));
        });
    }

    public TextFieldWidget setNumbersDouble(Function<Double, Double> validator) {
        this.numbers = true;
        return this.setValidator(val -> {
            double num = val.isEmpty() ? this.defaultNumber : this.parse((String)val);
            return format.format(validator.apply(num));
        });
    }

    public TextFieldWidget setNumbers(Supplier<Integer> min, Supplier<Integer> max) {
        return this.setNumbers(val -> Math.min((Integer)max.get(), Math.max((Integer)min.get(), val)));
    }

    public TextFieldWidget setNumbersLong(Supplier<Long> min, Supplier<Long> max) {
        return this.setNumbersLong(val -> Math.min((Long)max.get(), Math.max((Long)min.get(), val)));
    }

    public TextFieldWidget setNumbers(int min, int max) {
        return this.setNumbers(val -> Math.min(max, Math.max(min, val)));
    }

    public TextFieldWidget setNumbers() {
        return this.setNumbers(Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    public TextFieldWidget setDefaultNumber(double defaultNumber) {
        this.defaultNumber = defaultNumber;
        return this;
    }

    public TextFieldWidget value(IStringValue<?> stringValue) {
        this.setSyncOrValue(ISyncOrValue.orEmpty(stringValue));
        return this;
    }

    public TextFieldWidget setTooltipOverride(boolean value) {
        this.tooltipOverride = value;
        return this;
    }

    @Override
    public TextFieldWidget tooltipBuilder(Consumer<RichTooltip> tooltipBuilder) {
        this.tooltipOverride = true;
        return (TextFieldWidget)super.tooltipBuilder(tooltipBuilder);
    }

    @Override
    public TextFieldWidget tooltip(RichTooltip tooltip) {
        this.tooltipOverride = true;
        return (TextFieldWidget)super.tooltip(tooltip);
    }

    @Override
    public TextFieldWidget tooltip(Consumer<RichTooltip> tooltipConsumer) {
        this.tooltipOverride = true;
        return (TextFieldWidget)super.tooltip(tooltipConsumer);
    }

    @Override
    @NotNull
    public RichTooltip tooltip() {
        this.tooltipOverride = true;
        return super.tooltip();
    }

    @Override
    public TextFieldWidget tooltipDynamic(Consumer<RichTooltip> tooltipBuilder) {
        this.tooltipOverride = true;
        return (TextFieldWidget)super.tooltipDynamic(tooltipBuilder);
    }

    @Override
    public TextFieldWidget addTooltipDrawableLines(Iterable<IDrawable> lines) {
        this.tooltipOverride = true;
        return (TextFieldWidget)super.addTooltipDrawableLines(lines);
    }

    @Override
    public TextFieldWidget addTooltipElement(String s) {
        this.tooltipOverride = true;
        return (TextFieldWidget)super.addTooltipElement(s);
    }

    @Override
    public TextFieldWidget addTooltipElement(IDrawable drawable) {
        this.tooltipOverride = true;
        return (TextFieldWidget)super.addTooltipElement(drawable);
    }

    @Override
    public TextFieldWidget addTooltipLine(String line) {
        this.tooltipOverride = true;
        return (TextFieldWidget)super.addTooltipLine(line);
    }

    @Override
    public TextFieldWidget addTooltipLine(ITextLine line) {
        this.tooltipOverride = true;
        return (TextFieldWidget)super.addTooltipLine(line);
    }

    @Override
    public TextFieldWidget addTooltipLine(IDrawable drawable) {
        this.tooltipOverride = true;
        return (TextFieldWidget)super.addTooltipLine(drawable);
    }

    @Override
    public TextFieldWidget addTooltipStringLines(Iterable<String> lines) {
        this.tooltipOverride = true;
        return (TextFieldWidget)super.addTooltipStringLines(lines);
    }
}

