/*
 * Decompiled with CFR 0.152.
 */
package vpp.vac.textmod.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Path;
import net.minecraft.client.Minecraft;
import vpp.vac.textmod.main.TextMod;

public class Config {
    private JsonObject jsonObject;
    private final Gson gson = new GsonBuilder().setPrettyPrinting().create();
    private final Path configPath;

    public Config(Path configPath) throws IOException {
        this.configPath = configPath;
        File file = configPath.toFile();
        if (!file.exists()) {
            TextMod.log.print("Config not found!");
        }
        try (BufferedReader reader = Files.newBufferedReader(configPath);){
            JsonElement element = new JsonParser().parse((Reader)reader);
            if (!element.isJsonObject()) {
                throw new IllegalArgumentException("Config file must contain a JSON object.");
            }
            this.jsonObject = element.getAsJsonObject();
        }
    }

    public synchronized void set(String key, String value) throws IOException {
        this.jsonObject.addProperty(key, value);
        try (FileWriter writer = new FileWriter(this.configPath.toFile());){
            this.gson.toJson((JsonElement)this.jsonObject, (Appendable)writer);
        }
    }

    public String getText() {
        return this.jsonObject.has("text") ? this.jsonObject.get("text").getAsString() : "Default Text";
    }

    public String getCustomColor() {
        return this.jsonObject.has("CustomColor") ? this.jsonObject.get("CustomColor").getAsString() : "#24b3bf";
    }

    public String getColorMode() {
        return this.jsonObject.has("ColorMode") ? this.jsonObject.get("ColorMode").getAsString() : "Cycle";
    }

    public String getX() {
        return this.jsonObject.has("X") ? this.jsonObject.get("X").getAsString() : "4";
    }

    public String getY() {
        return this.jsonObject.has("Y") ? this.jsonObject.get("Y").getAsString() : "4";
    }

    public String get(String key) {
        return this.jsonObject.has(key) ? this.jsonObject.get(key).getAsString() : null;
    }

    public boolean isCustomColor() {
        return !this.getColorMode().equals("Cycle");
    }

    public static Path createDefaultConfigIfMissing() {
        File configFile;
        boolean created;
        File mcDir = Minecraft.func_71410_x().field_71412_D;
        File textModDir = new File(mcDir, "TextMod");
        if (!textModDir.exists() && (created = textModDir.mkdirs())) {
            TextMod.log.print("Created TextMod directory: " + textModDir.getAbsolutePath());
        }
        if (!(configFile = new File(textModDir, "textmod.json")).exists()) {
            JsonObject defaults = new JsonObject();
            defaults.addProperty("text", "Default Text");
            defaults.addProperty("CustomColor", "#24b3bf");
            defaults.addProperty("ColorMode", "Cycle");
            defaults.addProperty("X", "4");
            defaults.addProperty("Y", "4");
            try (FileWriter writer = new FileWriter(configFile);){
                Gson prettyGson = new GsonBuilder().setPrettyPrinting().create();
                prettyGson.toJson((JsonElement)defaults, (Appendable)writer);
                TextMod.log.print("Created default config at: " + configFile.getAbsolutePath());
            }
            catch (IOException e) {
                TextMod.log.print("Failed to create default config: " + e.getMessage());
            }
        }
        return configFile.toPath();
    }
}

