/*
 * Decompiled with CFR 0.152.
 */
package vpp.vac.textmod;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.fabricmc.fabric.api.client.rendering.v1.hud.HudElementRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.hud.VanillaHudElements;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_9779;
import vpp.vac.textmod.util.ColorUtil;
import vpp.vac.textmod.util.Config;
import vpp.vac.textmod.util.Logger;

@Environment(value=EnvType.CLIENT)
public class TextModClient
implements ClientModInitializer {
    public static final String MODID = "textmod";
    public static final String VERSION = "1.4-fabric";
    public static final String PREFIX = "[Textmod]";
    public static final Logger log = new Logger("[Textmod]");
    public static final class_310 client = class_310.method_1551();
    public static File mcDir = TextModClient.client.field_1697;
    public static Path configPath = Config.createDefaultConfigIfMissing();
    public static Config config;

    public void onInitializeClient() {
        HudElementRegistry.attachElementBefore((class_2960)VanillaHudElements.CHAT, (class_2960)class_2960.method_60655((String)MODID, (String)"before_chat"), TextModClient::render);
        ClientCommandRegistrationCallback.EVENT.register((dispatcher, registryAccess) -> dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)MODID).then(ClientCommandManager.literal((String)"text").then(ClientCommandManager.argument((String)"text", (ArgumentType)StringArgumentType.greedyString()).executes(context -> {
            String args = StringArgumentType.getString((CommandContext)context, (String)"text");
            try {
                config.set("text", args);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)("Text successfully set to: " + args)).method_27692(class_124.field_1060));
            return 1;
        })))).then(((LiteralArgumentBuilder)ClientCommandManager.literal((String)"color").then(ClientCommandManager.literal((String)"rainbow").executes(context -> {
            try {
                config.set("ColorMode", "cycle");
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"Color mode successfully set to: rainbow (cycle)").method_27692(class_124.field_1060));
            return 1;
        }))).then(((LiteralArgumentBuilder)ClientCommandManager.literal((String)"custom").executes(context -> {
            try {
                config.set("ColorMode", "custom");
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"Color mode set to custom (color unchanged)").method_27692(class_124.field_1060));
            return 1;
        })).then(ClientCommandManager.argument((String)"HexCode", (ArgumentType)StringArgumentType.greedyString()).executes(context -> {
            String args = StringArgumentType.getString((CommandContext)context, (String)"HexCode");
            try {
                config.set("ColorMode", "custom");
                config.set("CustomColor", args);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)("Custom color set to: " + args)).method_27692(class_124.field_1060));
            return 1;
        }))))).then(ClientCommandManager.literal((String)"pos").then(ClientCommandManager.argument((String)"x", (ArgumentType)IntegerArgumentType.integer()).then(ClientCommandManager.argument((String)"y", (ArgumentType)IntegerArgumentType.integer()).executes(context -> {
            int x = IntegerArgumentType.getInteger((CommandContext)context, (String)"x");
            int y = IntegerArgumentType.getInteger((CommandContext)context, (String)"y");
            try {
                config.set("X", String.valueOf(x));
                config.set("Y", String.valueOf(y));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)("Position set to: " + x + ", " + y)).method_27692(class_124.field_1060));
            return 1;
        }))))).then(ClientCommandManager.literal((String)"info").executes(context -> {
            ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"---TextMod---").method_27695(new class_124[]{class_124.field_1060, class_124.field_1067}));
            ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"TextMod by vaclavak").method_27692(class_124.field_1065));
            ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"You are using version 1.4-fabric").method_27692(class_124.field_1065));
            ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"Please check for new updates/versions here:\nhttps://modrinth.com/mod/textmod").method_27692(class_124.field_1065));
            return 1;
        }))).then(ClientCommandManager.literal((String)"help").executes(context -> {
            ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"---TextMod Commands---").method_27695(new class_124[]{class_124.field_1060, class_124.field_1067}));
            ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"/textmod text <text> - Changes the text\n/textmod color rainbow - Sets color mode to rainbow\n/textmod color custom <HEXCODE> - Sets a custom color (hex)\n/textmod pos <X> <Y> - Sets the position of the text\n/textmod info - Shows info about TextMod\n/textmod help - Shows this help message").method_27692(class_124.field_1065));
            return 1;
        }))));
    }

    private static void render(class_332 context, class_9779 tickCounter) {
        class_310 client = class_310.method_1551();
        class_327 renderer = client.field_1772;
        try {
            int x = Integer.parseInt(config.getX());
            int y = Integer.parseInt(config.getY());
            int color = config.isCustomColor() ? 0xFF000000 | Integer.parseInt(config.getCustomColor().replace("#", ""), 16) : ColorUtil.getRainbow(4.0f, 1.0f, 1.0f);
            context.method_51433(renderer, config.getText(), x, y, color, true);
        }
        catch (Exception e) {
            log.print("Render error: " + e.getMessage());
        }
    }

    private static boolean isValidHex(String hex) {
        return hex.matches("^[0-9A-Fa-f]{6}$");
    }

    static {
        try {
            config = new Config(configPath);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

