/*
 * Decompiled with CFR 0.152.
 */
package com.everydayxp.rpgseteffects.sets;

import com.everydayxp.rpgseteffects.registry.ModItems;
import com.everydayxp.rpgseteffects.system.SetUUIDs;
import com.everydayxp.rpgseteffects.util.AttributeUtils;
import com.everydayxp.rpgseteffects.util.SetTooltipBuilder;
import java.util.List;
import java.util.Set;
import java.util.function.BiFunction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.registries.RegistryObject;
import top.theillusivec4.curios.api.CuriosApi;

public class BloodFurySet {
    private static final Set<RegistryObject<Item>> PIECES = Set.of(ModItems.BLOOD_FURY_EMBLEM, ModItems.BLOOD_FURY_AURA, ModItems.BLOOD_FURY_BARRIER, ModItems.BLOOD_FURY_ALLY);
    private static final double HEALTH_BONUS = 4.0;
    private static final double DAMAGE_BONUS = 2.0;
    private static final double ATTACK_SPEED_MULTIPLIER = 0.15;

    public static void apply(ServerPlayer player) {
        int count = BloodFurySet.getEquippedCount((Player)player);
        if (count == 0) {
            BloodFurySet.removeModifiers((Player)player);
            return;
        }
        BloodFurySet.removeModifiers((Player)player);
        if (count >= 1) {
            AttributeUtils.applyMaxHealth(player, 4.0, SetUUIDs.BLOOD_FURY_HEALTH_1, "blood_fury_health_1");
        }
        if (count >= 2) {
            BloodFurySet.applyAttackDamageFlat((Player)player, 2.0);
        }
        if (count >= 3) {
            AttributeUtils.applyMaxHealth(player, 4.0, SetUUIDs.BLOOD_FURY_HEALTH_2, "blood_fury_health_2");
        }
        if (count == 4) {
            BloodFurySet.applyAttackSpeed((Player)player, 0.15);
        }
    }

    public static BiFunction<ItemStack, Integer, List<Component>> getTooltipLines() {
        return (stack, count) -> SetTooltipBuilder.build("set.blood_fury", count, BloodFurySet.format(4.0), BloodFurySet.format(2.0), BloodFurySet.format(4.0), BloodFurySet.formatPercent(0.15));
    }

    public static int getEquippedCount(Player player) {
        return CuriosApi.getCuriosInventory((LivingEntity)player).map(inv -> inv.findCurios(stack -> PIECES.stream().anyMatch(obj -> obj.isPresent() && obj.get() == stack.m_41720_()))).map(List::size).orElse(0);
    }

    public static Set<RegistryObject<Item>> getPieces() {
        return PIECES;
    }

    public static String format(double value) {
        return value % 1.0 == 0.0 ? String.valueOf((int)value) : String.format("%.1f", value);
    }

    public static String formatPercent(double value) {
        return String.format("%.0f%%", value * 100.0);
    }

    private static void applyAttackDamageFlat(Player player, double amount) {
        AttributeInstance attr = player.m_21051_(Attributes.f_22281_);
        if (attr != null) {
            attr.m_22118_(new AttributeModifier(SetUUIDs.BLOOD_FURY_DAMAGE, "blood_fury_damage", amount, AttributeModifier.Operation.ADDITION));
        }
    }

    private static void applyAttackSpeed(Player player, double multiplier) {
        AttributeInstance attr = player.m_21051_(Attributes.f_22283_);
        if (attr != null) {
            attr.m_22118_(new AttributeModifier(SetUUIDs.BLOOD_FURY_SPEED, "blood_fury_attack_speed", multiplier, AttributeModifier.Operation.MULTIPLY_TOTAL));
        }
    }

    private static void removeModifiers(Player player) {
        AttributeUtils.removeModifier(player, Attributes.f_22276_, SetUUIDs.BLOOD_FURY_HEALTH_1);
        AttributeUtils.removeModifier(player, Attributes.f_22276_, SetUUIDs.BLOOD_FURY_HEALTH_2);
        AttributeUtils.removeModifier(player, Attributes.f_22281_, SetUUIDs.BLOOD_FURY_DAMAGE);
        AttributeUtils.removeModifier(player, Attributes.f_22283_, SetUUIDs.BLOOD_FURY_SPEED);
    }
}

