/*
 * Decompiled with CFR 0.152.
 */
package com.everydayxp.rpgseteffects.sets;

import com.everydayxp.rpgseteffects.registry.ModItems;
import com.everydayxp.rpgseteffects.system.SetUUIDs;
import com.everydayxp.rpgseteffects.util.AttributeUtils;
import com.everydayxp.rpgseteffects.util.SetTooltipBuilder;
import java.util.List;
import java.util.Set;
import java.util.function.BiFunction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.registries.RegistryObject;
import top.theillusivec4.curios.api.CuriosApi;

public class HellbrandSet {
    private static final Set<RegistryObject<Item>> PIECES = Set.of(ModItems.HELLBRAND_EMBLEM, ModItems.HELLBRAND_AURA, ModItems.HELLBRAND_BARRIER, ModItems.HELLBRAND_ALLY);
    private static final double SPEED_MULTIPLIER = 0.1;
    private static final double ATTACK_SPEED_MULTIPLIER = 0.1;
    private static final double HEALTH_BONUS = 4.0;
    private static final double DAMAGE_BONUS = 4.0;

    public static void apply(ServerPlayer player) {
        int count = HellbrandSet.getEquippedCount((Player)player);
        if (count == 0) {
            HellbrandSet.removeModifiers((Player)player);
            return;
        }
        HellbrandSet.removeModifiers((Player)player);
        if (count >= 1) {
            HellbrandSet.applyMovementSpeed((Player)player, 0.1);
        }
        if (count >= 2) {
            HellbrandSet.applyAttackSpeed((Player)player, 0.1);
        }
        if (count >= 3) {
            HellbrandSet.applyMaxHealthSafe(player, 4.0);
        }
        if (count == 4) {
            HellbrandSet.applyAttackDamage((Player)player, 4.0);
        }
    }

    public static BiFunction<ItemStack, Integer, List<Component>> getTooltipLines() {
        return (stack, count) -> SetTooltipBuilder.build("set.hellbrand", count, HellbrandSet.formatPercent(0.1), HellbrandSet.formatPercent(0.1), HellbrandSet.format(4.0), HellbrandSet.format(4.0));
    }

    public static int getEquippedCount(Player player) {
        return CuriosApi.getCuriosInventory((LivingEntity)player).map(inv -> inv.findCurios(stack -> PIECES.stream().anyMatch(obj -> obj.isPresent() && obj.get() == stack.m_41720_()))).map(List::size).orElse(0);
    }

    public static Set<RegistryObject<Item>> getPieces() {
        return PIECES;
    }

    public static String format(double value) {
        return value % 1.0 == 0.0 ? String.valueOf((int)value) : String.format("%.1f", value);
    }

    public static String formatPercent(double value) {
        return String.format("%.0f%%", value * 100.0);
    }

    private static void applyMovementSpeed(Player player, double multiplier) {
        AttributeInstance attr = player.m_21051_(Attributes.f_22279_);
        if (attr != null) {
            attr.m_22118_(new AttributeModifier(SetUUIDs.HELLBRAND_SPEED, "hellbrand_speed", multiplier, AttributeModifier.Operation.MULTIPLY_TOTAL));
        }
    }

    private static void applyAttackSpeed(Player player, double multiplier) {
        AttributeInstance attr = player.m_21051_(Attributes.f_22283_);
        if (attr != null) {
            attr.m_22118_(new AttributeModifier(SetUUIDs.HELLBRAND_ATTACK_SPEED, "hellbrand_attack_speed", multiplier, AttributeModifier.Operation.MULTIPLY_TOTAL));
        }
    }

    private static void applyAttackDamage(Player player, double amount) {
        AttributeInstance attr = player.m_21051_(Attributes.f_22281_);
        if (attr != null) {
            attr.m_22118_(new AttributeModifier(SetUUIDs.HELLBRAND_DAMAGE, "hellbrand_attack_damage", amount, AttributeModifier.Operation.ADDITION));
        }
    }

    private static void applyMaxHealthSafe(ServerPlayer player, double amount) {
        AttributeInstance attr = player.m_21051_(Attributes.f_22276_);
        if (attr != null) {
            attr.m_22120_(SetUUIDs.HELLBRAND_HEALTH);
            attr.m_22118_(new AttributeModifier(SetUUIDs.HELLBRAND_HEALTH, "hellbrand_max_health", amount, AttributeModifier.Operation.ADDITION));
            float current = player.m_21223_();
            float max = player.m_21233_();
            player.m_21153_(Math.min(current, max));
        }
    }

    private static void removeModifiers(Player player) {
        AttributeUtils.removeModifier(player, Attributes.f_22279_, SetUUIDs.HELLBRAND_SPEED);
        AttributeUtils.removeModifier(player, Attributes.f_22283_, SetUUIDs.HELLBRAND_ATTACK_SPEED);
        AttributeUtils.removeModifier(player, Attributes.f_22276_, SetUUIDs.HELLBRAND_HEALTH);
        AttributeUtils.removeModifier(player, Attributes.f_22281_, SetUUIDs.HELLBRAND_DAMAGE);
    }
}

