/*
 * Decompiled with CFR 0.152.
 */
package com.everydayxp.rpgseteffects.sets;

import com.everydayxp.rpgseteffects.registry.ModItems;
import com.everydayxp.rpgseteffects.system.SetUUIDs;
import com.everydayxp.rpgseteffects.util.SetTooltipBuilder;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiFunction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.registries.RegistryObject;
import top.theillusivec4.curios.api.CuriosApi;

public class ShadowHunterSet {
    private static final Set<RegistryObject<Item>> PIECES = Set.of(ModItems.SHADOW_HUNTER_EMBLEM, ModItems.SHADOW_HUNTER_AURA, ModItems.SHADOW_HUNTER_BARRIER, ModItems.SHADOW_HUNTER_ALLY);
    private static final double ATTACK_SPEED_1 = 0.1;
    private static final double MOVE_SPEED = 0.2;
    private static final double DAMAGE = 3.0;
    private static final double ATTACK_SPEED_2 = 0.1;

    public static void apply(ServerPlayer player) {
        int count = ShadowHunterSet.getEquippedCount((Player)player);
        if (count == 0) {
            return;
        }
        ShadowHunterSet.removeModifiers((Player)player);
        if (count >= 1) {
            ShadowHunterSet.applyAttackSpeed((Player)player, 0.1, SetUUIDs.SHADOW_ATTACK_SPEED_1, "shadow_hunter_attack_speed_1");
        }
        if (count >= 2) {
            ShadowHunterSet.applyMovementSpeed((Player)player, 0.2);
        }
        if (count >= 3) {
            ShadowHunterSet.applyAttackDamage((Player)player, 3.0);
        }
        if (count == 4) {
            ShadowHunterSet.applyAttackSpeed((Player)player, 0.1, SetUUIDs.SHADOW_ATTACK_SPEED_2, "shadow_hunter_attack_speed_2");
        }
    }

    public static BiFunction<ItemStack, Integer, List<Component>> getTooltipLines() {
        return (stack, count) -> SetTooltipBuilder.build("set.shadow_hunter", count, ShadowHunterSet.formatPercent(0.1), ShadowHunterSet.formatPercent(0.2), ShadowHunterSet.format(3.0), ShadowHunterSet.formatPercent(0.1));
    }

    public static int getEquippedCount(Player player) {
        return CuriosApi.getCuriosInventory((LivingEntity)player).map(inv -> inv.findCurios(stack -> PIECES.stream().anyMatch(obj -> obj.isPresent() && obj.get() == stack.m_41720_()))).map(List::size).orElse(0);
    }

    public static Set<RegistryObject<Item>> getPieces() {
        return PIECES;
    }

    public static String format(double value) {
        return value % 1.0 == 0.0 ? String.valueOf((int)value) : String.format("%.1f", value);
    }

    public static String formatPercent(double value) {
        return String.format("%.0f%%", value * 100.0);
    }

    private static void applyAttackSpeed(Player player, double multiplier, UUID uuid, String name) {
        AttributeInstance attr = player.m_21051_(Attributes.f_22283_);
        if (attr != null) {
            attr.m_22118_(new AttributeModifier(uuid, name, multiplier, AttributeModifier.Operation.MULTIPLY_TOTAL));
        }
    }

    private static void applyMovementSpeed(Player player, double multiplier) {
        AttributeInstance attr = player.m_21051_(Attributes.f_22279_);
        if (attr != null) {
            attr.m_22118_(new AttributeModifier(SetUUIDs.SHADOW_MOVE_SPEED, "shadow_hunter_move_speed", multiplier, AttributeModifier.Operation.MULTIPLY_TOTAL));
        }
    }

    private static void applyAttackDamage(Player player, double amount) {
        AttributeInstance attr = player.m_21051_(Attributes.f_22281_);
        if (attr != null) {
            attr.m_22118_(new AttributeModifier(SetUUIDs.SHADOW_DAMAGE, "shadow_hunter_damage", amount, AttributeModifier.Operation.ADDITION));
        }
    }

    private static void removeModifiers(Player player) {
        Optional.ofNullable(player.m_21051_(Attributes.f_22283_)).ifPresent(attr -> {
            attr.m_22120_(SetUUIDs.SHADOW_ATTACK_SPEED_1);
            attr.m_22120_(SetUUIDs.SHADOW_ATTACK_SPEED_2);
        });
        Optional.ofNullable(player.m_21051_(Attributes.f_22279_)).ifPresent(attr -> attr.m_22120_(SetUUIDs.SHADOW_MOVE_SPEED));
        Optional.ofNullable(player.m_21051_(Attributes.f_22281_)).ifPresent(attr -> attr.m_22120_(SetUUIDs.SHADOW_DAMAGE));
    }
}

