/*
 * Decompiled with CFR 0.152.
 */
package com.everydayxp.rpgseteffects.system;

import com.everydayxp.rpgseteffects.sets.AltharionSet;
import com.everydayxp.rpgseteffects.sets.BloodFurySet;
import com.everydayxp.rpgseteffects.sets.HellbrandSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class SetEffectTicker {
    private static final List<SetApplier> SETS = List.of(AltharionSet::apply, BloodFurySet::apply, HellbrandSet::apply);
    private static final Map<UUID, PlayerCache> CACHE = new ConcurrentHashMap<UUID, PlayerCache>();

    public static void tick(ServerPlayer player) {
        UUID id = player.m_20148_();
        PlayerCache cache = CACHE.computeIfAbsent(id, k -> new PlayerCache());
        int count = AltharionSet.getEquippedCount((Player)player);
        if (cache.altharion != count) {
            cache.altharion = count;
            AltharionSet.apply(player);
        }
        if (cache.bloodfury != (count = BloodFurySet.getEquippedCount((Player)player))) {
            cache.bloodfury = count;
            BloodFurySet.apply(player);
        }
        if (cache.hellbrand != (count = HellbrandSet.getEquippedCount((Player)player))) {
            cache.hellbrand = count;
            HellbrandSet.apply(player);
        }
    }

    public static void clear(ServerPlayer player) {
        CACHE.remove(player.m_20148_());
    }

    private static class PlayerCache {
        int altharion = -1;
        int bloodfury = -1;
        int hellbrand = -1;

        private PlayerCache() {
        }
    }

    @FunctionalInterface
    public static interface SetApplier {
        public void apply(ServerPlayer var1);
    }
}

