/*
 * Decompiled with CFR 0.152.
 */
package com.everydayxp.rpgseteffects.sets;

import com.everydayxp.rpgseteffects.registry.ModItems;
import com.everydayxp.rpgseteffects.system.EffectCooldownManager;
import com.everydayxp.rpgseteffects.system.SetUUIDs;
import com.everydayxp.rpgseteffects.util.SetTooltipHelper;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import top.theillusivec4.curios.api.CuriosApi;

public class AltharionSet {
    private static final Set<Item> PIECES = Set.of((Item)ModItems.ALTHARION_EMBLEM.get(), (Item)ModItems.ALTHARION_AURA.get(), (Item)ModItems.ALTHARION_BARRIER.get(), (Item)ModItems.ALTHARION_ALLY.get());

    public static void apply(ServerPlayer player) {
        int count = AltharionSet.getEquippedCount((Player)player);
        if (count == 0) {
            AltharionSet.removeAll((Player)player);
            return;
        }
        AltharionSet.removeModifiers((Player)player);
        if (count >= 1) {
            AltharionSet.applyAbsorption((Player)player, 1);
        }
        if (count >= 2) {
            AltharionSet.applyAttackDamage((Player)player, 2.0, SetUUIDs.ALTHARION_DAMAGE_BASE, "altharion_damage_base");
        }
        if (count >= 3) {
            AltharionSet.applyMovementSpeed((Player)player, 0.15);
        }
        if (count == 4) {
            AltharionSet.applyAttackDamage((Player)player, 3.0, SetUUIDs.ALTHARION_DAMAGE_EXTRA, "altharion_damage_extra");
        }
    }

    public static List<Component> getTooltipLines() {
        Player player = SetTooltipHelper.getClientPlayer();
        int count = player != null ? AltharionSet.getEquippedCount(player) : 0;
        List<SetTooltipHelper.BonusLine> bonuses = List.of(new SetTooltipHelper.BonusLine(1, "set.altharion.bonus.1"), new SetTooltipHelper.BonusLine(2, "set.altharion.bonus.2"), new SetTooltipHelper.BonusLine(3, "set.altharion.bonus.3"), new SetTooltipHelper.BonusLine(4, "set.altharion.bonus.4"));
        return SetTooltipHelper.generate("set.altharion.name", count, bonuses);
    }

    public static int getEquippedCount(Player player) {
        return CuriosApi.getCuriosInventory((LivingEntity)player).map(inv -> inv.findCurios(stack -> PIECES.contains(stack.m_41720_()))).map(List::size).orElse(0);
    }

    public static Set<Item> getPieces() {
        return PIECES;
    }

    private static void applyAbsorption(Player player, int amplifier) {
        if (EffectCooldownManager.shouldApply(player, "altharion_absorption", 600)) {
            player.m_7292_(new MobEffectInstance(MobEffects.f_19617_, 600, amplifier, true, false));
        }
    }

    private static void applyMovementSpeed(Player player, double multiplier) {
        AttributeInstance attr = player.m_21051_(Attributes.f_22279_);
        if (attr != null) {
            attr.m_22118_(new AttributeModifier(SetUUIDs.ALTHARION_SPEED, "altharion_speed", multiplier, AttributeModifier.Operation.MULTIPLY_TOTAL));
        }
    }

    private static void applyAttackDamage(Player player, double amount, UUID uuid, String name) {
        AttributeInstance attr = player.m_21051_(Attributes.f_22281_);
        if (attr != null) {
            attr.m_22118_(new AttributeModifier(uuid, name, amount, AttributeModifier.Operation.ADDITION));
        }
    }

    private static void removeModifiers(Player player) {
        Optional.ofNullable(player.m_21051_(Attributes.f_22279_)).ifPresent(attr -> attr.m_22120_(SetUUIDs.ALTHARION_SPEED));
        Optional.ofNullable(player.m_21051_(Attributes.f_22281_)).ifPresent(attr -> {
            attr.m_22120_(SetUUIDs.ALTHARION_DAMAGE_BASE);
            attr.m_22120_(SetUUIDs.ALTHARION_DAMAGE_EXTRA);
        });
    }

    private static void removeAll(Player player) {
        AltharionSet.removeModifiers(player);
        if (player.m_21023_(MobEffects.f_19617_) && EffectCooldownManager.wasApplied(player, "altharion_absorption")) {
            player.m_21195_(MobEffects.f_19617_);
        }
    }
}

